<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Installer Middleware
Route::group(['middleware' => 'Installer', 'scriptsanitizer'], function () {

    // Website routes
    Route::get('/', [App\Http\Controllers\Website\WebController::class, "webIndex"])->name("web.index");
    Route::get('/features', [App\Http\Controllers\Website\WebController::class, "webFeatures"])->name("web.features");
    Route::get('/about', [App\Http\Controllers\Website\WebController::class, "webAbout"])->name("web.about");
    Route::get('/pricing', [App\Http\Controllers\Website\WebController::class, "webPricing"])->name("web.pricing");
    Route::get('/contact', [App\Http\Controllers\Website\WebController::class, "webContact"])->name("web.contact");
    Route::post("/send-email", [App\Http\Controllers\Website\MailerController::class, "composeEmail"])->name("send-email");
    Route::get('/faq', [App\Http\Controllers\Website\WebController::class, "webFAQ"])->name("web.faq");
    Route::get('/privacy-policy', [App\Http\Controllers\Website\WebController::class, "webPrivacy"])->name("web.privacy");
    Route::get('/refund-policy', [App\Http\Controllers\Website\WebController::class, "webRefund"])->name("web.refund");
    Route::get('/terms-and-conditions', [App\Http\Controllers\Website\WebController::class, "webTerms"])->name("web.terms");

    // Optimize images from website
    Route::post('optimize', [App\Http\Controllers\Website\WebController::class, "optimizeImage"])->name('optimize.image');

    // Custom pages
    Route::get('/p/{id}', [App\Http\Controllers\Website\WebController::class, "customPage"])->name("web.custom.page");

    // Blogs
    Route::get('/blogs', [App\Http\Controllers\Website\WebController::class, "blogs"])->name("web.blogs")->middleware('scriptsanitizer');
    Route::get('/blog/{slug}', [App\Http\Controllers\Website\WebController::class, "viewBlog"])->name("web.view.blog")->middleware('scriptsanitizer');

    // Blog post share
    Route::get('/blog/{slug}/share/facebook', [App\Http\Controllers\Website\ShareController::class, "shareToFacebook"])->name("sharetofacebook");
    Route::get('/blog/{slug}/share/twitter', [App\Http\Controllers\Website\ShareController::class, "shareToTwitter"])->name("sharetotwitter");
    Route::get('/blog/{slug}/share/linkedin', [App\Http\Controllers\Website\ShareController::class, "shareToLinkedIn"])->name("sharetolinkedin");
    Route::get('/blog/{slug}/share/instagram', [App\Http\Controllers\Website\ShareController::class, "shareToInstagram"])->name("sharetoinstagram");
    Route::get('/blog/{slug}/share/whatsapp', [App\Http\Controllers\Website\ShareController::class, "shareToWhatsApp"])->name("sharetowhatsapp");

    // Auth routes
    Auth::routes();

    // Admin routes
    Route::group(['as' => 'admin.', 'prefix' => 'admin', 'namespace' => 'Admin', 'middleware' => ['auth', 'admin'], 'where' => ['locale' => '[a-zA-Z]{2}']], function () {
        // Dashboard
        Route::get('dashboard', [App\Http\Controllers\Admin\DashboardController::class, "index"])->name('dashboard');

        // Check Optimizer
        if (env('APP_TYPE') == 'OPTIMIZE' || env('APP_TYPE') == 'BOTH') {
            // Create Optimize Image
            Route::get('optimer/all', [App\Http\Controllers\Admin\OptimerController::class, "indexAllOptimer"])->name('all.optimer');
            Route::get('optimer/create', [App\Http\Controllers\Admin\OptimerController::class, "CreateOptimer"])->name('create.optimer');
            Route::post('optimer/save', [App\Http\Controllers\Admin\OptimerController::class, "saveOptimer"])->name('save.optimer');
            // Delete Optimize Image
            Route::get('optimer/delete', [App\Http\Controllers\Admin\OptimerController::class, "deleteOptimer"])->name('delete.optimer');
            Route::get('optimer/bulk-delete', [App\Http\Controllers\Admin\OptimerController::class, "bulkDeleteOptimer"])->name('bulk.delete');

            // Bulk Download Optimize Image
            Route::get('optimer/bulk-download', [App\Http\Controllers\Admin\OptimerController::class, "bulkDownload"])->name('bulk.download');

            // Download Optimize Image
            Route::get('optimer/{id}', [App\Http\Controllers\Admin\OptimerController::class, "downloadOptimer"])->name("download.optimer");
        }

        Route::get('download-image', [App\Http\Controllers\Admin\OptimerController::class, "downloadImage"])->name("download.image");

        // Trash Optimize Image
        Route::get('trash', [App\Http\Controllers\Admin\TrashController::class, "indexTrash"])->name('all.trash.optimer');
        // Restore Optimize Image
        Route::get('restore', [App\Http\Controllers\Admin\TrashController::class, "restoreOptimer"])->name('restore');
        // Delete Optimize Image
        Route::get('permanent-delete', [App\Http\Controllers\Admin\TrashController::class, "permanentDeleteOptimer"])->name('permanent.delete.optimer');
        // Empty trash
        Route::get('empty-trash', [App\Http\Controllers\Admin\TrashController::class, "emptyTrash"])->name('empty.trash');

        // Media
        Route::get('media', [App\Http\Controllers\Admin\MediaController::class, "media"])->name('media');
        Route::get('add-media', [App\Http\Controllers\Admin\MediaController::class, "addMedia"])->name('add.media');
        Route::post('upload-media', [App\Http\Controllers\Admin\MediaController::class, "uploadMedia"])->name('upload.media');
        Route::get('delete-media/{id}', [App\Http\Controllers\Admin\MediaController::class, "deleteMedia"])->name('media.delete');
        Route::get('bulk-delete-media', [App\Http\Controllers\Admin\MediaController::class, "bulkDeleteMedia"])->name('bulk.delete.media');
        Route::get('bulk-download-media', [App\Http\Controllers\Admin\MediaController::class, "bulkDownloadMedia"])->name('bulk.download.media');

        // Media Optimize Image
        Route::get('optimer-image/{id}', [App\Http\Controllers\Admin\MediaController::class, "optimizeImage"])->name("optimize.image");

        // Users
        Route::get('users', [App\Http\Controllers\Admin\UserController::class, "index"])->name('users');
        Route::get('edit-user/{id}', [App\Http\Controllers\Admin\UserController::class, "editUser"])->name('edit.user');
        Route::post('update-user', [App\Http\Controllers\Admin\UserController::class, "updateUser"])->name('update.user');
        Route::get('view-user/{id}', [App\Http\Controllers\Admin\UserController::class, "viewUser"])->name('view.user');
        Route::get('change-user-plan/{id}', [App\Http\Controllers\Admin\UserController::class, "ChangeUserPlan"])->name('change.user.plan');
        Route::post('update-user-plan', [App\Http\Controllers\Admin\UserController::class, "UpdateUserPlan"])->name('update.user.plan');
        Route::get('update-status', [App\Http\Controllers\Admin\UserController::class, "updateStatus"])->name('update.status');
        Route::get('delete-user', [App\Http\Controllers\Admin\UserController::class, "deleteUser"])->name('delete.user');
        Route::get('login-as/{id}', [App\Http\Controllers\Admin\UserController::class, "authAs"])->name('login-as.user');

        // Plans
        Route::get('plans', [App\Http\Controllers\Admin\PlanController::class, "index"])->name('index.plans');
        Route::get('add-plan', [App\Http\Controllers\Admin\PlanController::class, "addPlan"])->name('add.plan');
        Route::post('save-plan', [App\Http\Controllers\Admin\PlanController::class, "savePlan"])->name('save.plan');
        Route::get('edit-plan/{id}', [App\Http\Controllers\Admin\PlanController::class, "editPlan"])->name('edit.plan');
        Route::post('update-plan', [App\Http\Controllers\Admin\PlanController::class, "updatePlan"])->name('update.plan');
        Route::get('delete-plan', [App\Http\Controllers\Admin\PlanController::class, "deletePlan"])->name('delete.plan');

        // Payment Gateways
        Route::get('payment-methods', [App\Http\Controllers\Admin\PaymentMethodController::class, "index"])->name('payment.methods');
        Route::get('add-payment-method', [App\Http\Controllers\Admin\PaymentMethodController::class, "addPaymentMethod"])->name('add.payment.method');
        Route::post('save-payment-method', [App\Http\Controllers\Admin\PaymentMethodController::class, "savePaymentMethod"])->name('save.payment.method');
        Route::get('edit-payment-method/{id}', [App\Http\Controllers\Admin\PaymentMethodController::class, "editPaymentMethod"])->name('edit.payment.method');
        Route::post('update-payment-method', [App\Http\Controllers\Admin\PaymentMethodController::class, "updatePaymentMethod"])->name('update.payment.method');
        Route::get('delete-payment-method', [App\Http\Controllers\Admin\PaymentMethodController::class, "deletePaymentMethod"])->name('delete.payment.method');

        // Payment Configuration
        Route::get('configure-payment-method/{id}', [App\Http\Controllers\Admin\PaymentMethodController::class, 'configurePaymentMethod'])->name('configure.payment');
        Route::post('update-payment-configuration/{id}', [App\Http\Controllers\Admin\PaymentMethodController::class, 'updatePaymentConfiguration'])->name('update.payment.configuration')->middleware(['demo.mode']);

        // Transactions
        Route::get('transactions', [App\Http\Controllers\Admin\TransactionController::class, "index"])->name('transactions');
        Route::get('transaction-status/{id}/{status}', [App\Http\Controllers\Admin\TransactionController::class, "transactionStatus"])->name('trans.status');
        Route::get('offline-transactions', [App\Http\Controllers\Admin\TransactionController::class, "offlineTransactions"])->name('offline.transactions');
        Route::get('offline-transaction-status/{id}/{status}', [App\Http\Controllers\Admin\TransactionController::class, "offlineTransactionStatus"])->name('offline.trans.status');
        Route::get('view-invoice/{id}', [App\Http\Controllers\Admin\TransactionController::class, "viewInvoice"])->name('view.invoice');

        // Account Setting
        Route::get('account', [App\Http\Controllers\Admin\AccountController::class, "index"])->name('index.account');
        Route::get('edit-account', [App\Http\Controllers\Admin\AccountController::class, "editAccount"])->name('edit.account');
        Route::post('update-account', [App\Http\Controllers\Admin\AccountController::class, "updateAccount"])->name('update.account');
        Route::get('change-password', [App\Http\Controllers\Admin\AccountController::class, "changePassword"])->name('change.password');
        Route::post('update-password', [App\Http\Controllers\Admin\AccountController::class, "UpdatePassword"])->name('update.password');

        // Change theme
        Route::get('theme/{id}', [App\Http\Controllers\Admin\AccountController::class, "changeTheme"])->name('change.theme');

        // Pages
        Route::get('pages', [App\Http\Controllers\Admin\PageController::class, "index"])->name('pages');
        Route::get('add-page', [App\Http\Controllers\Admin\PageController::class, "addPage"])->name('add.page');
        Route::post('save-page', [App\Http\Controllers\Admin\PageController::class, "savePage"])->name('save.page');
        Route::get('custom-page/{id}', [App\Http\Controllers\Admin\PageController::class, "editCustomPage"])->name('edit.custom.page');
        Route::post('custom-update-page', [App\Http\Controllers\Admin\PageController::class, "updateCustomPage"])->name('update.custom.page');
        Route::get('status-page', [App\Http\Controllers\Admin\PageController::class, "statusPage"])->name('status.page');
        Route::get('page/{id}', [App\Http\Controllers\Admin\PageController::class, "editPage"])->name('edit.page');
        Route::post('update-page/{id}', [App\Http\Controllers\Admin\PageController::class, "updatePage"])->name('update.page');
        Route::get('disable-page', [App\Http\Controllers\Admin\PageController::class, "disablePage"])->name('disable.page');
        Route::get('delete-page', [App\Http\Controllers\Admin\PageController::class, "deletePage"])->name('delete.page');

        // Blogs Categories
        Route::get('blog-categories', [App\Http\Controllers\Admin\BlogCategoryController::class, "index"])->name('blog.categories');
        Route::get('create-blog-category', [App\Http\Controllers\Admin\BlogCategoryController::class, "createBlogCategory"])->name('create.blog.category');
        Route::post('publish-blog-category', [App\Http\Controllers\Admin\BlogCategoryController::class, "publishBlogCategory"])->name('publish.blog.category');
        Route::get('edit-blog-category/{id}', [App\Http\Controllers\Admin\BlogCategoryController::class, "editBlogCategory"])->name('edit.blog.category');
        Route::post('update-blog-category/{id}', [App\Http\Controllers\Admin\BlogCategoryController::class, "updateBlogCategory"])->name('update.blog.category');
        Route::get('action-blog-category', [App\Http\Controllers\Admin\BlogCategoryController::class, "actionBlogCategory"])->name('action.blog.category');

        // Blogs
        Route::get('blogs', [App\Http\Controllers\Admin\BlogController::class, "index"])->name('blogs');
        Route::get('create-blog', [App\Http\Controllers\Admin\BlogController::class, "createBlog"])->name('create.blog');
        Route::post('publish-blog', [App\Http\Controllers\Admin\BlogController::class, "publishBlog"])->name('publish.blog');
        Route::get('edit-blog/{id}', [App\Http\Controllers\Admin\BlogController::class, "editBlog"])->name('edit.blog');
        Route::post('update-blog/{id}', [App\Http\Controllers\Admin\BlogController::class, "updateBlog"])->name('update.blog');
        Route::get('action-blog', [App\Http\Controllers\Admin\BlogController::class, "actionBlog"])->name('action.blog');

        // General settings
        Route::get('general-settings', [App\Http\Controllers\Admin\GeneralSettingController::class, "index"])->name('general.settings');
        Route::post('change-general-settings', [App\Http\Controllers\Admin\GeneralSettingController::class, "changeGeneralSettings"])->name('change.general.settings');

        // Optimer settings
        Route::get('change-optimer-settings', [App\Http\Controllers\Admin\OptimerSettingController::class, "index"])->name('optimer.settings');
        Route::post('change-optimer-settings', [App\Http\Controllers\Admin\OptimerSettingController::class, "changeOptimerSettings"])->name('change.optimer.settings');

        // AWS settings
        Route::get('aws-settings', [App\Http\Controllers\Admin\AWSSettingController::class, "index"])->name('aws.settings');
        Route::post('change-aws-s3-settings', [App\Http\Controllers\Admin\AWSSettingController::class, "changeS3Settings"])->name('change.aws.s3.settings');

        // Wasabi settings
        Route::get('wasabi-settings', [App\Http\Controllers\Admin\WasabiSettingController::class, "index"])->name('wasabi.settings');
        Route::post('change-wasabi-s3-settings', [App\Http\Controllers\Admin\WasabiSettingController::class, "changeWasabiS3Settings"])->name('change.wasabi.s3.settings');

        // Backblaze settings
        Route::get('backblaze-settings', [App\Http\Controllers\Admin\BackblazeSettingController::class, "index"])->name('backblaze.settings');
        Route::post('change-backblaze-s3-settings', [App\Http\Controllers\Admin\BackblazeSettingController::class, "changeBackblazeS3Settings"])->name('change.backblaze.s3.settings');

        // Website settings
        Route::get('website-settings', [App\Http\Controllers\Admin\WebsiteSettingController::class, "index"])->name('website.settings');
        Route::post('change-website-settings', [App\Http\Controllers\Admin\WebsiteSettingController::class, "changeWebsiteSettings"])->name('change.website.settings');

        // Payment gateway settings
        Route::get('payments-settings', [App\Http\Controllers\Admin\PaymentSettingController::class, "index"])->name('payments.settings');
        Route::post('change-payments-settings', [App\Http\Controllers\Admin\PaymentSettingController::class, "changePaymentsSettings"])->name('change.payments.settings');

        // Google settings
        Route::get('google-settings', [App\Http\Controllers\Admin\GoogleSettingController::class, "index"])->name('google.settings');
        Route::post('change-google-settings', [App\Http\Controllers\Admin\GoogleSettingController::class, "changeGoogleSettings"])->name('change.google.settings');

        // Email settings
        Route::get('email-settings', [App\Http\Controllers\Admin\EmailSettingController::class, "index"])->name('email.settings');
        Route::post('change-email-settings', [App\Http\Controllers\Admin\EmailSettingController::class, "changeEmailSettings"])->name('change.email.settings');

        // Currencies
        Route::get('currencies', [App\Http\Controllers\Admin\CurrencyController::class, 'currencies'])->name('currencies');
        Route::get('edit-currency/{id}', [App\Http\Controllers\Admin\CurrencyController::class, 'editCurrency'])->name('edit.currency');
        Route::post('update-currency', [App\Http\Controllers\Admin\CurrencyController::class, 'updateCurrency'])->name('update.currency')->middleware(['demo.mode']);
        Route::get('delete-currency', [App\Http\Controllers\Admin\CurrencyController::class, 'deleteCurrency'])->name('delete.currency');

        // Tax settings
        Route::get('tax-setting', [App\Http\Controllers\Admin\SettingController::class, "taxSetting"])->name('tax.setting');
        Route::post('update-tex-setting', [App\Http\Controllers\Admin\SettingController::class, "updateTaxSetting"])->name('update.tax.setting');
        Route::post('update-email-setting', [App\Http\Controllers\Admin\SettingController::class, "updateEmailSetting"])->name('update.email.setting');
        Route::get('test-email', [App\Http\Controllers\Admin\SettingController::class, "testEmail"])->name('test.email');

        // License
        Route::get('license', [App\Http\Controllers\Admin\LicenseController::class, "license"])->name('license');
        Route::post('verify-license', [App\Http\Controllers\Admin\LicenseController::class, "verifyLicense"])->name('verify.license');

        // Log Authentication
        Route::get('logs', [App\Http\Controllers\Admin\AuthenticationLogController::class, "index"])->name('logs');

        // Settingup cron jobs
        Route::get('cron/cron-jobs', [App\Http\Controllers\Admin\CronJobController::class, 'index'])->name('cron.jobs');
        Route::post('cron/cron-jobs/update', [App\Http\Controllers\Admin\CronJobController::class, 'update'])->name('update.cron.jobs')->middleware(['demo.mode']);

        // Test Reminder
        Route::get('cron/test-reminder', [App\Http\Controllers\Admin\CronJobController::class, 'testReminder'])->name('test.reminder');

        // Set cronjob time
        Route::post('cron/set-cronjob-time', [App\Http\Controllers\Admin\CronJobController::class, 'setCronjobTime'])->name('set.cronjob.time')->middleware(['demo.mode']);

        // Clear cache
        Route::get('clear/cache', [App\Http\Controllers\Admin\SettingController::class, 'clearCache'])->name('clear.cache')->middleware(['demo.mode']);

        // Generating a sitemap
        Route::get('sitemap', [App\Http\Controllers\Admin\SitemapController::class, 'index'])->name('sitemap');
        Route::post('generate-sitemap', [App\Http\Controllers\Admin\SitemapController::class, 'generate'])->name('generate.sitemap')->middleware(['demo.mode']);

        // Backup
        Route::get('backups', [App\Http\Controllers\Admin\BackupController::class, 'index'])->name('backups');
        Route::get('backups/get-database-backup', [App\Http\Controllers\Admin\BackupController::class, 'getDatabaseBackup'])->name('get.database.backup');
        Route::get('backups/create-file-backup', [App\Http\Controllers\Admin\BackupController::class, 'createFileBackup'])->name('create.file.backup')->middleware(['demo.mode']);
        Route::get('backups/create-database-backup', [App\Http\Controllers\Admin\BackupController::class, 'createDatabaseBackup'])->name('create.database.backup')->middleware(['demo.mode']);
        Route::get('backups/restore-backup', [App\Http\Controllers\Admin\BackupController::class, 'restore'])->name('backup.restore')->middleware(['demo.mode']);
        Route::get('backups/download-backup', [App\Http\Controllers\Admin\BackupController::class, 'download'])->name('backup.download')->middleware(['demo.mode']);
        Route::get('backups/delete-backup', [App\Http\Controllers\Admin\BackupController::class, 'delete'])->name('backup.delete')->middleware(['demo.mode']);

        // Check update
        Route::get('check', [App\Http\Controllers\Admin\UpdateController::class, 'check'])->name('check');
        Route::post('check-update', [App\Http\Controllers\Admin\UpdateController::class, 'checkUpdate'])->name('check.update');
        Route::post('update-code', [App\Http\Controllers\Admin\UpdateController::class, 'updateCode'])->name('update.code');

        // For developers
        Route::get('for-developers', [App\Http\Controllers\Admin\ForDeveloper::class, "index"])->name('for.developers');
        Route::post('generate-key', [App\Http\Controllers\Admin\ForDeveloper::class, "generateKey"])->name('generate.key');
    });

    // User routes
    Route::group(['as' => 'user.', 'prefix' => 'user', 'namespace' => 'User', 'middleware' => ['auth', 'user'], 'where' => ['locale' => '[a-zA-Z]{2}']], function () {
        // Dashboard
        Route::get('dashboard', [App\Http\Controllers\User\DashboardController::class, "index"])->name('dashboard');

        // Plans
        Route::get('plans', [App\Http\Controllers\User\PlanController::class, "index"])->name('plans');

        // Check Optimizer
        if (env('APP_TYPE') == 'OPTIMIZE' || env('APP_TYPE') == 'BOTH') {
            // Create Optimize Image
            Route::get('optimer/all', [App\Http\Controllers\User\OptimerController::class, "indexAllOptimer"])->name('all.optimer');
            Route::get('optimer/create', [App\Http\Controllers\User\OptimerController::class, "CreateOptimer"])->name('create.optimer');
            Route::post('optimer/save', [App\Http\Controllers\User\OptimerController::class, "saveOptimer"])->name('save.optimer');

            // Delete Optimize Image
            Route::get('optimer/delete', [App\Http\Controllers\User\OptimerController::class, "deleteOptimer"])->name('delete.optimer');
            Route::get('optimer/bulk-delete', [App\Http\Controllers\User\OptimerController::class, "bulkDeleteOptimer"])->name('bulk.delete');

            // Download Optimize Image
            Route::get('optimer/bulk-download', [App\Http\Controllers\User\OptimerController::class, "bulkDownload"])->name('bulk.download');
            Route::get('optimer/{id}', [App\Http\Controllers\User\OptimerController::class, "downloadOptimer"])->name("download.optimer");

            // Trash Optimize Image
            Route::get('trash', [App\Http\Controllers\User\TrashController::class, "indexTrash"])->name('all.trash.optimer');

            // Restore Optimize Image
            Route::get('restore', [App\Http\Controllers\User\TrashController::class, "restoreOptimer"])->name('restore');

            // Delete Optimize Image
            Route::get('permanent-delete', [App\Http\Controllers\User\TrashController::class, "permanentDeleteOptimer"])->name('permanent.delete.optimer');

            // Empty trash
            Route::get('empty-trash', [App\Http\Controllers\User\TrashController::class, "emptyTrash"])->name('empty.trash');
        }

        Route::get('download-image', [App\Http\Controllers\User\OptimerController::class, "downloadImage"])->name("download.image");

        // Media
        Route::get('media', [App\Http\Controllers\User\MediaController::class, "media"])->name('media');
        Route::get('add-media', [App\Http\Controllers\User\MediaController::class, "addMedia"])->name('add.media');
        Route::post('upload-media', [App\Http\Controllers\User\MediaController::class, "uploadMedia"])->name('upload.media');
        Route::get('delete-media/{id}', [App\Http\Controllers\User\MediaController::class, "deleteMedia"])->name('media.delete');
        Route::get('bulk-delete-media', [App\Http\Controllers\User\MediaController::class, "bulkDeleteMedia"])->name('bulk.delete.media');
        Route::get('bulk-download-media', [App\Http\Controllers\User\MediaController::class, "bulkDownloadMedia"])->name('bulk.download.media');


        // Media Optimize Image
        Route::get('optimer-image/{id}', [App\Http\Controllers\User\MediaController::class, "optimizeImage"])->name("optimize.image");

        //Addtional Tootls -> QR Maker
        Route::get('tools/whois-lookup', [App\Http\Controllers\User\AdditionalController::class, "whoisLookup"])->name('whois-lookup');
        Route::post('tools/whois-lookup', [App\Http\Controllers\User\AdditionalController::class, "resultWhoisLookup"])->name('result.whois-lookup');
        Route::get('tools/dns-lookup', [App\Http\Controllers\User\AdditionalController::class, "dnsLookup"])->name('dns-lookup');
        Route::post('tools/dns-lookup', [App\Http\Controllers\User\AdditionalController::class, "resultDnsLookup"])->name('result.dns-lookup');
        Route::get('tools/ip-lookup', [App\Http\Controllers\User\AdditionalController::class, "ipLookup"])->name('ip-lookup');
        Route::post('tools/ip-lookup', [App\Http\Controllers\User\AdditionalController::class, "resultIpLookup"])->name('result.ip-lookup');

        // Transactions
        Route::get('transactions', [App\Http\Controllers\User\TransactionsController::class, "indexTransactions"])->name('transactions');
        Route::get('view-invoice/{id}', [App\Http\Controllers\User\TransactionsController::class, "viewInvoice"])->name('view.invoice');

        // Billing
        Route::get('billing/{id}', [App\Http\Controllers\User\BillingController::class, "billing"])->name('billing');
        Route::post('update-billing', [App\Http\Controllers\User\BillingController::class, "updateBilling"])->name('update.billing');

        // Checkout
        Route::get('checkout/{id}', [App\Http\Controllers\User\CheckOutController::class, "checkout"])->name('checkout');

        // Account Setting
        Route::get('account', [App\Http\Controllers\User\AccountController::class, "index"])->name('index.account');
        Route::get('edit-account', [App\Http\Controllers\User\AccountController::class, "editAccount"])->name('edit.account');
        Route::post('update-account', [App\Http\Controllers\User\AccountController::class, "updateAccount"])->name('update.account');
        Route::get('change-password', [App\Http\Controllers\User\AccountController::class, "changePassword"])->name('change.password');
        Route::post('update-password', [App\Http\Controllers\User\AccountController::class, "updatePassword"])->name('update.password');

        // Change theme
        Route::get('theme/{id}', [App\Http\Controllers\User\AccountController::class, "changeTheme"])->name('change.theme');

        // Resend Email Verfication
        Route::get('verify-email-verification', [App\Http\Controllers\User\VerificationController::class, "verifyEmailVerification"])->name('verify.email.verification');
        Route::get('resend-email-verification', [App\Http\Controllers\User\VerificationController::class, "resendEmailVerification"])->name('resend.email.verification');

        // For developers
        Route::get('for-developers', [App\Http\Controllers\User\ForDeveloper::class, "index"])->name('for.developers');
        Route::post('generate-key', [App\Http\Controllers\User\ForDeveloper::class, "generateKey"])->name('generate.key');
    });

    // Google auth routes
    Route::get('/google-login', [App\Http\Controllers\Auth\LoginController::class, "redirectToProvider"])->name('login.google');
    Route::get('/sign-in-with-google', [App\Http\Controllers\Auth\LoginController::class, "handleProviderCallback"]);


    Route::group(['middleware' => 'checkType'], function () {


        // Choose Payment Gateway
        Route::post('/prepare-payment/{planId}', [App\Http\Controllers\Payment\PaymentController::class, "preparePaymentGateway"])->name('prepare.payment.gateway');

        // PayPal Payment Gateway
        Route::get('/payment-paypal/{planId}', [App\Http\Controllers\Payment\PaypalController::class, "paywithpaypal"])->name('paywithpaypal');
        Route::get('/payment/status', [App\Http\Controllers\Payment\PaypalController::class, "paypalPaymentStatus"])->name('paypalPaymentStatus');

        // RazorPay
        Route::get('payment-razorpay/{planId}', [App\Http\Controllers\Payment\RazorPayController::class, "prepareRazorpay"])->name('paywithrazorpay');
        Route::get('razorpay-payment-status/{oid}/{paymentId}', [App\Http\Controllers\Payment\RazorPayController::class, "razorpayPaymentStatus"])->name('razorpay.payment.status');

        // Phonepe
        Route::get('/payment-phonepe/{planId}', [App\Http\Controllers\Payment\PhonepeController::class, 'preparePhonpe'])->name('paywithphonepe');
        Route::any('/phonepe-payment-status', [App\Http\Controllers\Payment\PhonepeController::class, 'phonepePaymentStatus'])->name('phonepe.payment.status');

        // Stripe
        Route::get('/payment-stripe/{planId}', [App\Http\Controllers\Payment\StripeController::class, "stripeCheckout"])->name('paywithstripe');
        Route::post('/stripe-payment-status/{paymentId}', [App\Http\Controllers\Payment\StripeController::class, "stripePaymentStatus"])->name('stripe.payment.status');
        Route::get('/stripe-payment-cancel/{paymentId}', [App\Http\Controllers\Payment\StripeController::class, "stripePaymentCancel"])->name('stripe.payment.cancel');

        // Paystack
        Route::get('/payment-paystack/{planId}', [App\Http\Controllers\Payment\PaystackController::class, "paystackCheckout"])->name('paywithpaystack');
        Route::get('/paystack-payment/callback', [App\Http\Controllers\Payment\PaystackController::class, 'paystackHandleGatewayCallback'])->name('paystack.handle.gateway.callback');

        // Mollie
        Route::get('/payment-mollie/{planId}', [App\Http\Controllers\Payment\MollieController::class, "prepareMollie"])->name('paywithmollie');
        Route::get('/mollie-payment-status', [App\Http\Controllers\Payment\MollieController::class, "molliePaymentStatus"])->name('mollie.payment.status');

        // Toyyibpay
        Route::get('/payment-toyyibpay/{planId}', [App\Http\Controllers\Payment\ToyyibpayController::class, "prepareToyyibpay"])->name('prepare.toyyibpay');
        Route::get('/toyyibpay-payment-status', [App\Http\Controllers\Payment\ToyyibpayController::class, "toyyibpayPaymentStatus"])->name('toyyibpay.payment.status');
        Route::get('/toyyibpay-payment-success', [App\Http\Controllers\Payment\ToyyibpayController::class, 'toyyibpayPaymentSuccess'])->name('toyyibpay.payment.success');

        // Flutterwave
        Route::get('/payment-flutterwave/{planId}', [App\Http\Controllers\Payment\FlutterwaveController::class, "prepareFlutterwave"])->name('prepare.flutterwave');
        Route::get('/flutterwave-payment-status', [App\Http\Controllers\Payment\FlutterwaveController::class, "flutterwavePaymentStatus"])->name('flutterwave.payment.status');

        // Offline
        Route::get('/payment-offline/{planId}', [App\Http\Controllers\Payment\OfflineController::class, "offlineCheckout"])->name('paywithoffline');
        Route::post('/mark-offline-payment', [App\Http\Controllers\Payment\OfflineController::class, "markOfflinePayment"])->name('mark.payment.payment');
    });
});

// Delete Image
Route::get('download', [App\Http\Controllers\Website\WebController::class, "downloadImge"])->name('download.image');

Route::get('generate', function () {
    \Illuminate\Support\Facades\Artisan::call('storage:link');
    echo 'ok';
});

Route::get('general-cache-clear', function () {
    try {
        // Delete all files in bootstrap/cache except .gitignore
        $cachePath  = base_path('bootstrap/cache');
        $cacheFiles = File::files($cachePath);
        foreach ($cacheFiles as $file) { 
            if ($file->getFilename() !== '.gitignore') {
                File::delete($file);
            }
        }

        // Delete all files in storage/framework/cache except .gitignore
        $cachePath  = base_path('storage/framework/cache');
        $cacheFiles = File::files($cachePath);
        foreach ($cacheFiles as $file) {
            if ($file->getFilename() !== '.gitignore') {
                File::delete($file);
            }
        }

        // Delete all files in storage/framework/views except .gitignore
        $cachePath  = base_path('storage/framework/views');
        $cacheFiles = File::files($cachePath);
        foreach ($cacheFiles as $file) {
            if ($file->getFilename() !== '.gitignore') {
                File::delete($file);
            }
        }

        // Clear application cache
        Cache::flush();

        // Clear caches using Artisan
        Artisan::call('cache:clear');  // Clear application cache
        Artisan::call('route:clear');  // Clear route cache
        Artisan::call('config:clear'); // Clear configuration cache
        Artisan::call('view:clear');   // Clear compiled view files
    } catch (\Exception $e) {
    }

    echo 'cleared';
});

