<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

if (Request::method() == "GET") {
    Route::get('/check-status', [App\Http\Controllers\API\APIController::class, "checkStatus"])->middleware('apiCalls');
} 

// Check form method
if (Request::method() == "POST") {
    Route::post('/upload', [App\Http\Controllers\API\APIController::class, "uploadImage"])->middleware('apiCalls');
} 

if (Request::method() == "GET") {
    Route::get('/get-images', [App\Http\Controllers\API\APIController::class, "getOptimizedImages"])->middleware('apiCalls');
} 

if (Request::method() == "GET") {
    Route::get('/get-media', [App\Http\Controllers\API\APIController::class, "getMediaImages"])->middleware('apiCalls');
} 

if (Request::method() == "GET") {
    Route::get('/get-single-image', [App\Http\Controllers\API\APIController::class, "getSingleImage"])->middleware('apiCalls');
} 

if (Request::method() == "POST") {
    Route::post('/delete', [App\Http\Controllers\API\APIController::class, "deleteImages"])->middleware('apiCalls');
}

return response(['status' => false, 'message' => 'form method must be "GET".'], 413); 