@extends('layouts.modern')

{{-- Custom JS --}}
@section('custom-css')
    {{-- AdSense status --}}
    @if ($setting->adsense_code != 'DISABLE')
        {{-- AdSense code --}}
        <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client={{ $setting->adsense_code }}"
            crossorigin="anonymous"></script>
    @endif
@endsection

@php
    use App\Models\Page;

    $page = Page::where('slug', 'terms-and-conditions')
        ->where('status', 1)
        ->get();
@endphp

@section('content')
    {{-- Topbar --}}
    @include('website.modern.includes.topbar')

    {{-- Terms and conditions --}}
    <section class="relative py-12 md:py-24 bg-gray-900">
        <div class="container px-4 mx-auto">
            <div class="max-w-4xl mx-auto">
                <div class="flex mb-4 items-center justify-center">
                    <span
                        class="inline-flex items-center h-10 md:h-6 px-2 text-sm md:text-md text-center font-medium text-white bg-gradient-to-br from-cyanGreen-800 to-cyan-800 rounded-full">{{ __($page[0]->body) }}</span>
                    <span class="inline-block mx-4">
                        <svg width="1" height="24" viewbox="0 0 1 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <line x1="0.5" y1="2.18558e-08" x2="0.499999" y2="24" stroke="#3B5444"></line>
                        </svg></span>
                    <span class="text-sm text-gray-300">{{ __($page[3]->body) }} : {{ __($page[4]->body) }}</span>
                </div>
                <div class="mb-12 pb-12 text-center border-b border-gray-700">
                    <h2 class="font-heading tracking-tight text-4xl sm:text-5xl font-bold text-white">{{ __($page[1]->body) }}</h2>
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[2]->body) }}</p>
                </div>
                <div class="mb-4">
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[5]->body) }}</p>
                </div>
                <div class="mb-4">
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[6]->body) }}</p>
                </div>
                <div class="mb-4">
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[7]->body) }}</p>
                </div>
                <div class="mb-4">
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[8]->body) }}</p>
                </div>
                <div class="mb-4">
                    <ol class="mb-5 list-decimal list-inside text-lg font-medium leading-7 text-gray-300">
                        <li>
                            <span class="text-lg font-medium leading-8 text-gray-300">{{ __($page[9]->body) }}</span>
                        </li>
                        <li>
                            <span class="text-lg font-medium leading-8 text-gray-300">{{ __($page[10]->body) }}</span>
                        </li>
                        <li>
                            <span class="text-lg font-medium leading-8 text-gray-300">{{ __($page[11]->body) }}</span>
                        </li>
                    </ol>
                </div>
                <div class="mb-4">
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[12]->body) }}</p>
                </div>
            </div>
        </div>
    </section>

    {{-- Footer --}}
    @include('website.modern.includes.footer')
@endsection
