@extends('layouts.modern')

{{-- Custom JS --}}
@section('custom-css')

{{-- AdSense status --}}
@if ($setting->adsense_code != "DISABLE")
{{-- AdSense code --}}
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client={{ $setting->adsense_code }}" crossorigin="anonymous"></script>
@endif

@endsection

@php
use App\Models\Page;

$page = Page::where('slug', 'pricing')->where('status', 1)->get();

// Byte conversion
function formatBytes($size, $precision = 2)
{
$base = log($size, 1024);
$suffixes = array('', 'kB', 'MB', 'GB', 'TB');

return round(pow(1024, $base - floor($base)), $precision) .''. $suffixes[floor($base)];
}
@endphp

@section('content')

{{-- Topbar --}}
@include('website.modern.includes.topbar')

{{-- Plans --}}
<section class="py-12 md:py-24 bg-gray-900">
    <div class="container px-4 mx-auto">
        <div class="max-w-sm md:max-w-md lg:max-w-6xl mx-auto">
            <div class="text-center mb-16">
                <span
                    class="inline-flex items-center h-6 md:h-6 px-2 mb-3 text-sm md:text-md text-center font-medium text-white bg-gradient-to-br from-cyanGreen-800 to-cyan-800 rounded-full">{{ __('Pricing')}}</span>
                <h1 class="font-heading tracking-tight text-4xl sm:text-5xl font-bold text-white mb-4">
                    {{ __($page[1]->body) }}
                </h1>
                <p class="text-lg text-gray-400">
                    {{ __($page[2]->body) }}
                </p>
            </div>
            <div class="flex flex-wrap -mx-4">
                {{-- all plans --}}
                @foreach ($plans as $plan)
                <div class="w-full lg:w-1/3 px-4 mb-12 lg:mb-0">
                    <div class="{{ $plan->recommended == 1 ? 'relative bg-white border border-gray-100' : 'bg-gray-900 border border-gray-700' }} p-8 mb-10 rounded-xl shadow-sm">
                        @if ($plan->recommended == 1)
                        <span class="absolute top-0 right-0 m-8 inline-block px-2.5 leading-relaxed text-sm text-white bg-gray-800 uppercase rounded-full">{{ __('Popular') }}</span>
                        @endif
                        <div class="flex mb-8 items-center">
                            <span class="mr-3">
                                <svg width="24" height="24" viewbox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M15 3.6V14.4C15 14.7314 14.7314 15 14.4 15H3.6C3.26863 15 3 14.7314 3 14.4V3.6C3 3.26863 3.26863 3 3.6 3H14.4C14.7314 3 15 3.26863 15 3.6Z"
                                        stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                    <path d="M13.5 21H16.5" stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                    <path d="M21 13.5V16.5" stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                    <path d="M21 19.5V20.4C21 20.7314 20.7314 21 20.4 21H19.5" stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}"
                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M10.5 21H9.6C9.26863 21 9 20.7314 9 20.4V19.5" stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}"
                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M19.5 9H20.4C20.7314 9 21 9.26863 21 9.6V10.5" stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}"
                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M16.5 9H9.6C9.26863 9 9 9.26863 9 9.6V16.5" stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}"
                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>
                            </span>
                            <span class="text-base font-semibold {{ $plan->recommended == 1 ? '' : 'text-white' }} uppercase">{{ __($plan->name) }}</span>
                        </div>
                        <div class="flex items-end mb-4">
                            {{-- Price --}}
                            @if ($plan->price == 0)
                            <span class="mr-2 text-5xl font-semibold {{ $plan->recommended == 1 ? '' : 'text-white' }} tracking-tighter">{{ __('Free') }}</span>
                            @else
                            <span class="mr-2 text-5xl font-semibold {{ $plan->recommended == 1 ? '' : 'text-white' }} tracking-tighter">
                                {{ $plan->price == 0 ? '' : currency($plan->price) }}
                            </span>
                            @endif

                            <span class="inline-block pb-2 text-lg text-gray-400">
                            /
                            @if ($plan->price != 0 && $plan->validity == 9999)
                                {{ __('Forever') }}</span>
                            @endif
                            @if ($plan->validity == 31)
                            {{ __('Per Month') }}</span>
                            @endif
                            @if ($plan->validity == 366)
                            {{ __('Per Year') }}</span>
                            @endif
                            @if ($plan->validity > 1 && $plan->validity != 31 && $plan->validity != 366 &&
                            $plan->validity != 9999)
                            {{ 'Per'.' '.$plan->validity.' '.__('Days') }}</span>
                            @endif
                            </span>
                        </div>
                        <span class="block text-gray-400 mb-8">{{ __($plan->description) }}</span>
                        <div class="p-4 mb-8 border {{ $plan->recommended == 1 ? 'border-gray-200' : 'border-teal-800' }} rounded-xl">
                            {{-- Formats --}}
                            <div class="mb-4">
                                <span class="text-{{ $plan->recommended == 1 ? 'black' : 'white' }}">{{ $plan->formats == 9999 ? __('Unlimited') : $plan->formats }}</span>
                                <span class="text-gray-{{ $plan->recommended == 1 ? '400' : '400' }} text-sm">{{ __('Formats') }}</span>
                            </div>
                            {{-- Optimize Images --}}
                            <div class="mb-4">
                                <span class="text-{{ $plan->recommended == 1 ? 'black' : 'white' }}">{{ $plan->maximum == 9999 ? __('Unlimited') : $plan->maximum }}</span>
                                <span class="text-gray-{{ $plan->recommended == 1 ? '400' : '400' }} text-sm">{{ __('Optimize Images') }}</span>
                            </div>
                            {{-- Upload Limit --}}
                            <div class="mb-4">
                                <span class="text-{{ $plan->recommended == 1 ? 'black' : 'white' }}">{{ formatBytes($plan->size) }}</span>
                                <span class="text-gray-{{ $plan->recommended == 1 ? '400' : '400' }} text-sm">{{ __('Upload Limit') }}</span>
                            </div>
                            {{-- Storage --}}
                            <div class="mb-4">
                                <span class="text-{{ $plan->recommended == 1 ? 'black' : 'white' }}">{{ formatBytes($plan->storage) }}</span>
                                <span class="text-gray-{{ $plan->recommended == 1 ? '400' : '400' }} text-sm">{{ __('Storage') }}</span>
                            </div>
                            {{-- APIs Request --}}
                            <div class="mb-4">
                                <span class="text-{{ $plan->recommended == 1 ? 'black' : 'white' }}">{{ $plan->limit != 0 ? $plan->limit : 0 }}</span>
                                <span class="text-gray-{{ $plan->recommended == 1 ? '400' : '400' }} text-sm">{{ __('APIs Request') }}</span>
                            </div>
                            {{-- Cloud Storage (S3) --}}
                            <div class="flex items-start mb-4">
                                @if ($plan->s3 == 1)
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg width="14" height="14" viewbox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2.91699 7.58337L5.25033 9.91671L11.0837 4.08337" stroke="white"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </span>
                                @else
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" stroke-width="1.5" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M18 6l-12 12" />
                                        <path d="M6 6l12 12" />
                                    </svg>
                                </span>
                                @endif
                                <div class="ml-4">
                                    <p class="text-sm">
                                        <span class="text-gray-400 text-sm">{{ __('Cloud Storage (S3)') }}</span>
                                    </p>
                                </div>
                            </div>
                            {{-- Daily Usage Statistics --}}
                            <div class="flex items-start mb-4">
                                @if ($plan->statistics == 1)
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg width="14" height="14" viewbox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2.91699 7.58337L5.25033 9.91671L11.0837 4.08337" stroke="white"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </span>
                                @else
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" stroke-width="1.5" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M18 6l-12 12" />
                                        <path d="M6 6l12 12" />
                                    </svg>
                                </span>
                                @endif
                                <div class="ml-4">
                                    <p class="text-sm">
                                        <span class="text-gray-400 text-sm">{{ __('Daily Usage Statistics') }}</span>
                                    </p>
                                </div>
                            </div>
                            {{-- Media Library --}}
                            <div class="flex items-start mb-4">
                                @if ($plan->media_library == 1)
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg width="14" height="14" viewbox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2.91699 7.58337L5.25033 9.91671L11.0837 4.08337" stroke="white"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </span>
                                @else
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" stroke-width="1.5" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M18 6l-12 12" />
                                        <path d="M6 6l12 12" />
                                    </svg>
                                </span>
                                @endif
                                <div class="ml-4">
                                    <p class="text-sm">
                                        <span class="text-gray-400 text-sm">{{ __('Media Library') }}</span>
                                    </p>
                                </div>
                            </div>
                            {{-- Conversation APIs --}}
                            <div class="flex items-start mb-4">
                                @if ($plan->api == 1)
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg width="14" height="14" viewbox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2.91699 7.58337L5.25033 9.91671L11.0837 4.08337" stroke="white"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </span>
                                @else
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" stroke-width="1.5" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M18 6l-12 12" />
                                        <path d="M6 6l12 12" />
                                    </svg>
                                </span>
                                @endif
                                <div class="ml-4">
                                    <p class="text-sm">
                                        <span class="text-gray-400 text-sm">{{ __('Conversation APIs') }}</span>
                                    </p>
                                </div>
                            </div>
                            {{-- Additional Tools --}}
                            <div class="flex items-start mb-4">
                                @if ($plan->additional_tools == 1)
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg width="14" height="14" viewbox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2.91699 7.58337L5.25033 9.91671L11.0837 4.08337" stroke="white"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </span>
                                @else
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" stroke-width="1.5" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M18 6l-12 12" />
                                        <path d="M6 6l12 12" />
                                    </svg>
                                </span>
                                @endif
                                <div class="ml-4">
                                    <p class="text-sm">
                                        <span class="text-gray-400 text-sm">{{ __('Additional Tools') }}</span>
                                    </p>
                                </div>
                            </div>
                            {{-- Support --}}
                            <div class="flex items-start mb-4">
                                @if ($plan->support == 1)
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg width="14" height="14" viewbox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2.91699 7.58337L5.25033 9.91671L11.0837 4.08337" stroke="white"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </span>
                                @else
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" stroke-width="1.5" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M18 6l-12 12" />
                                        <path d="M6 6l12 12" />
                                    </svg>
                                </span>
                                @endif
                                <div class="ml-4">
                                    <p class="text-sm">
                                        <span class="text-gray-400 text-sm">{{ __('Support') }}</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                        {{-- Register --}}
                        @if ($plan->recommended == 1)
                        <a class="group relative flex items-center justify-center px-5 h-12 font-bold text-white bg-gradient-to-br from-cyanGreen-800 to-cyan-800 rounded-lg transition-all duration-300"
                            href="{{ route('register') }}">
                            <div
                                class="absolute top-0 left-0 w-full h-full rounded-lg ring ring-green-300 animate-pulse group-hover:ring-0 transition duration-300">
                            </div>
                            <span>{{ __('Get Started') }}</span>
                        </a> 
                        @else
                        <a class="group flex justify-center w-full h-12 p-1 text-center text-base text-white font-semibold rounded-lg"
                            href="{{ route('register') }}">
                            <div
                                class="inline-flex items-stretch w-full h-12 p-0.5 rounded-lg bg-gradient-to-b from-gray-500 via-gray-700 to-gray-700 hover:to-gray-800">
                                <div
                                    class="flex w-full items-center justify-center px-4 bg-gray-700 group-hover:bg-opacity-40 rounded-md transition duration-300">
                                    <span>{{ __('Get Started') }}</span>
                                </div>
                            </div>
                        </a>  
                        @endif
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>

{{-- Footer --}}
@include('website.modern.includes.footer')
@endsection