@extends('layouts.modern')

{{-- Custom JS --}}
@section('custom-css')
    {{-- AdSense status --}}
    @if ($setting->adsense_code != 'DISABLE')
        {{-- AdSense code --}}
        <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client={{ $setting->adsense_code }}"
            crossorigin="anonymous"></script>
    @endif
@endsection

@php
    use App\Models\Page;

    $page = Page::where('slug', 'faq')
        ->where('status', 1)
        ->get();
@endphp

@section('content')
    {{-- Topbar --}}
    @include('website.modern.includes.topbar')

    {{-- FAQs --}}
    <section class="relative py-12 md:py-24 bg-gray-900">
        <div class="container px-4 mx-auto">
            <div class="text-center mb-20">
                <span
                    class="inline-flex items-center h-6 md:h-6 px-2 mb-3 text-sm md:text-md text-center font-medium text-white bg-gradient-to-br from-cyanGreen-800 to-cyan-800 rounded-full">{{ __($page[0]->body)}}</span>
                <h1 class="font-heading tracking-tight text-4xl sm:text-5xl font-semibold text-white mb-6">{{ __($page[1]->body) }}</h1>
                <p class="text-gray-400">{{ __($page[2]->body) }}</p>
            </div>
            <div class="flex flex-wrap -mx-4 lg:-mx-12 -mb-16">
                <div class="w-full xs:w-1/2 md:w-1/3 px-4 lg:px-12 mb-16">
                    <div class="max-w-sm">
                        <h6 class="text-xl font-semibold text-white mb-1">{{ __($page[3]->body) }}</h6>
                        <p class="text-gray-400">{{ __($page[4]->body) }}</p>
                    </div>
                </div>
                <div class="w-full xs:w-1/2 md:w-1/3 px-4 lg:px-12 mb-16">
                    <div class="max-w-sm">
                        <h6 class="text-xl font-semibold text-white mb-1">{{ __($page[5]->body) }}</h6>
                        <p class="text-gray-400">{{ __($page[6]->body) }}</p>
                    </div>
                </div>
                <div class="w-full xs:w-1/2 md:w-1/3 px-4 lg:px-12 mb-16">
                    <div class="max-w-sm">
                        <h6 class="text-xl font-semibold text-white mb-1">{{ __($page[7]->body) }}</h6>
                        <p class="text-gray-400">{{ __($page[8]->body) }}</p>
                    </div>
                </div>
                <div class="w-full xs:w-1/2 md:w-1/3 px-4 lg:px-12 mb-16">
                    <div class="max-w-sm">
                        <h6 class="text-xl font-semibold text-white mb-1">{{ __($page[9]->body) }}</h6>
                        <p class="text-gray-400">{{ __($page[10]->body) }}</p>
                    </div>
                </div>
                <div class="w-full xs:w-1/2 md:w-1/3 px-4 lg:px-12 mb-16">
                    <div class="max-w-sm">
                        <h6 class="text-xl font-semibold text-white mb-1">{{ __($page[11]->body) }}</h6>
                        <p class="text-gray-400">{{ __($page[12]->body) }}</p>
                    </div>
                </div>
                <div class="w-full xs:w-1/2 md:w-1/3 px-4 lg:px-12 mb-16">
                    <div class="max-w-sm">
                        <h6 class="text-xl font-semibold text-white mb-1">{{ __($page[13]->body) }}</h6>
                        <p class="text-gray-400">{{ __($page[14]->body) }}</p>
                    </div>
                </div>
            </div>
            <div class="mt-16 py-4 px-6 bg-gray-800 rounded-xl">
                <div class="sm:flex items-center">
                    <div class="xs:flex mb-6 md:mb-0 items-center">
                        <div class="flex-shrink-0 flex items-center">
                            <div class="inline-flex items-center justify-center p-1 bg-gray-800 rounded-full">
                                <div class="inline-flex items-center justify-center w-14 h-14 bg-teal-700 rounded-full">
                                    <svg width="24" height="24" viewbox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M8 10L12 10L16 10" stroke="white" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                        <path d="M8 14L10 14L12 14" stroke="white" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                        <path
                                            d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 13.8214 2.48697 15.5291 3.33782 17L2.5 21.5L7 20.6622C8.47087 21.513 10.1786 22 12 22Z"
                                            stroke="white" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="-ml-4 inline-flex items-center justify-center p-1 bg-gray-800 rounded-full">
                                <img class="block w-14 h-14" src="{{ asset('modern/assets/blog/avatar-medium.png') }}" alt="">
                            </div>
                        </div>
                        <div class="mt-6 md:mt-0 xs:ml-6">
                            <h6 class="font-semibold text-white mb-1">{{  __($page[15]->body) }}</h6>
                            <p class="text-sm text-gray-400">{{  __($page[16]->body) }}</p>
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-auto sm:pl-4 text-right">
                        <a class="group inline-block justify-center p-1 text-center text-base text-white font-semibold rounded-lg"
                            href="{{ url($page[18]->body) }}">
                            <div
                                class="inline-flex items-stretch h-12 p-0.5 rounded-lg bg-gradient-to-b from-gray-500 via-gray-700 to-gray-700 hover:to-gray-800">
                                <div
                                    class="flex items-center px-4 bg-gray-700 group-hover:bg-opacity-40 rounded-md transition duration-300">
                                    <span class="mr-2">{{ __($page[17]->body) }}</span>
                                    <span class="transform group-hover:translate-x-1 transition duration-200">
                                        <svg width="20" height="20" viewbox="0 0 20 20" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5.00033 10H15.417M15.417 10L10.417 5M15.417 10L10.417 15"
                                                stroke="white" stroke-width="1.5" stroke-linecap="round"
                                                stroke-linejoin="round"></path>
                                        </svg>
                                    </span>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    {{-- Footer --}}
    @include('website.modern.includes.footer')
@endsection
