@extends('layouts.modern')

@section('content')

{{-- Custom JS --}}
@section('custom-css')
{{-- AdSense status --}}
@if ($setting->adsense_code != "DISABLE")
{{-- AdSense code --}}
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client={{ $setting->adsense_code }}"
    crossorigin="anonymous"></script>
@endif

<style>
    .custom-page h1, .custom-page h2, .custom-page h3, .custom-page h4, .custom-page h5, .custom-page h6, .custom-page p, .custom-page span, .custom-page font {
        color: #ffffff !important;
        margin-bottom: 1.5rem !important;
    }
</style>
@endsection

{{-- Topbar --}}
@include('website.modern.includes.topbar')

{{-- About us --}}
<section class="pt-10">
    <div class="container px-4 pb-8 mx-auto" data-aos="fade-up">
        {{-- Page content --}}
        @if (!empty($page->body))
            @foreach (preg_split("/(<[^>]*>)/", $page->body, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY) as $part)
                @if (strpos($part, '<') === 0)
                    {!! __($part) !!}
                @else
                    {{ __($part) }}
                @endif
            @endforeach
        @endif
    </div>
</section>

{{-- Footer --}}
@include('website.modern.includes.footer')
@endsection