@extends('layouts.modern')

{{-- Custom JS --}}
@section('custom-css')
    {{-- AdSense status --}}
    @if ($setting->adsense_code != 'DISABLE')
        {{-- AdSense code --}}
        <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client={{ $setting->adsense_code }}"
            crossorigin="anonymous"></script>
    @endif
@endsection

@section('content')
    {{-- Topbar --}}
    @include('website.modern.includes.topbar')

    {{-- View blog --}}
    <section class="relative py-12 md:py-24 bg-gray-900">
        <div class="container px-4 mx-auto">
            <div class="max-w-4xl mx-auto text-center mb-12">
                <h2 class="font-heading tracking-tight text-4xl sm:text-5xl font-bold text-white">{{ $blogDetails->heading }}</h2>
            </div>
            <img class="block mb-12 w-full object-cover rounded-xl" src="{{ asset($blogDetails->cover_image) }}" alt="{{ $blogDetails->heading }}">
            <div class="max-w-4xl mx-auto">
                <div class="flex mb-12 py-6 px-6 justify-between items-center border-t border-b border-gray-700">
                    <div class="flex items-center">
                        <img class="block w-16 h-16 rounded-full object-contain bg-gradient-to-br from-cyanGreen-800 to-cyan-800" src="{{ asset($blogDetails->user->profile_image ? $blogDetails->user->profile_image : $setting->site_logo) }}" alt="{{ $blogDetails->user->name }}">
                        <div class="ml-3">
                            <span class="block text-base font-semibold text-white mb-1">{{ $blogDetails->user->name }}</span>
                            <span class="lg:hidden inline-flex items-center h-6 px-2 text-sm text-gray-50 font-medium bg-gray-800 rounded-full">{{ $blogDetails->blogCategory->blog_category_title }}</span>
                            <span class="lg:hidden inline-flex text-sm text-gray-400">{{ Carbon\Carbon::parse($blogDetails->created_at)->format('d M Y h:i A') }}</span>
                        </div>
                    </div>
                    <div class="lg:flex hidden items-center">
                        <span
                            class="inline-flex items-center h-6 px-2 text-sm text-gray-50 font-medium bg-gray-800 rounded-full">{{ $blogDetails->blogCategory->blog_category_title }}</span>
                        <span class="inline-block mx-4">
                            <svg width="1" height="24" viewbox="0 0 1 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <line x1="0.5" y1="2.18558e-08" x2="0.499999" y2="24" stroke="#3B5444"></line>
                            </svg></span>
                        <span class="text-sm text-gray-400">{{ Carbon\Carbon::parse($blogDetails->created_at)->format('d M Y h:i A') }}</span>
                    </div>
                </div>
                <div class="text-lg text-white mb-6">
                    <p class="text-lg text-white mb-6">
                        @if (!empty($blogDetails->long_description))
                            @foreach (preg_split("/(<[^>]*>)/", $blogDetails->long_description, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY) as $part)
                                @if (strpos($part, '<') === 0)
                                    {!! __($part) !!}
                                @else
                                    {{ __($part) }}
                                @endif
                            @endforeach
                        @endif
                    </p>

                    <!-- Tags Heading -->
                    <div class="my-8" data-aos="fade-up" data-aos-duration="800">
                        <h2 class="text-xl font-semibold mb-2">{{ __('Related Tags:') }}</h2>

                        {{-- Tags --}}
                        <div class="flex space-x-2">
                            @php
                                // Tags separated
                                $tags = explode(',', $blogDetails->tags);
                                $tags = collect($tags)->all();
                            @endphp

                            @foreach ($tags as $tag)
                                <span
                                    class="inline-flex items-center h-10 md:h-6 px-2 text-sm md:text-md text-center font-medium text-white bg-gradient-to-br from-cyanGreen-800 to-cyan-800 rounded-full">{{ strtoupper($tag) }}</span>
                            @endforeach
                        </div>
                    </div>

                    {{-- Share This Post --}}
                    <div class="mt-8 mb-24" data-aos="fade-up" data-aos-duration="800">
                        <h2 class="text-xl font-semibold mb-4">{{ __('Share This Blog Post') }}</h2>
                        <div class="flex space-x-4">
                            <!-- Facebook Share Button -->
                            <a href="{{ route('sharetofacebook', $blogDetails->slug) }}" target="_blank"
                                class="flex items-center px-4 py-4 bg-gradient-to-br from-cyanGreen-800 to-cyan-800 text-white rounded-full">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M7 10v4h3v7h4v-7h3l1 -4h-4v-2a1 1 0 0 1 1 -1h3v-4h-3a5 5 0 0 0 -5 5v2h-3" />
                                </svg>
                            </a>

                            <!-- Twitter Share Button -->
                            <a href="{{ route('sharetotwitter', $blogDetails->slug) }}" target="_blank"
                                class="flex items-center px-4 py-4 bg-gradient-to-br from-cyanGreen-800 to-cyan-800 text-white rounded-full">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M4 4l11.733 16h4.267l-11.733 -16z" />
                                    <path d="M4 20l6.768 -6.768m2.46 -2.46l6.772 -6.772" />
                                </svg>
                            </a>

                            <!-- LinkedIn Share Button -->
                            <a href="{{ route('sharetolinkedin', $blogDetails->slug) }}" target="_blank"
                                class="flex items-center px-4 py-4 bg-gradient-to-br from-cyanGreen-800 to-cyan-800 text-white rounded-full">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z" />
                                    <path d="M8 11l0 5" />
                                    <path d="M8 8l0 .01" />
                                    <path d="M12 16l0 -5" />
                                    <path d="M16 16v-3a2 2 0 0 0 -4 0" />
                                </svg>
                            </a>

                            <!-- Instagram Share Button -->
                            <a href="{{ route('sharetoinstagram', $blogDetails->slug) }}" target="_blank"
                                class="flex items-center px-4 py-4 bg-gradient-to-br from-cyanGreen-800 to-cyan-800 text-white rounded-full">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M4 4m0 4a4 4 0 0 1 4 -4h8a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-8a4 4 0 0 1 -4 -4z" />
                                    <path d="M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0" />
                                    <path d="M16.5 7.5l0 .01" />
                                </svg>
                            </a>

                            <!-- WhatsApp Share Button -->
                            <a href="{{ route('sharetowhatsapp', $blogDetails->slug) }}" target="_blank"
                                class="flex items-center px-4 py-4 bg-gradient-to-br from-cyanGreen-800 to-cyan-800 text-white rounded-full">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M3 21l1.65 -3.8a9 9 0 1 1 3.4 2.9l-5.05 .9" />
                                    <path
                                        d="M9 10a.5 .5 0 0 0 1 0v-1a.5 .5 0 0 0 -1 0v1a5 5 0 0 0 5 5h1a.5 .5 0 0 0 0 -1h-1a.5 .5 0 0 0 0 1" />
                                </svg>
                            </a>
                        </div>
                    </div>

                    <!-- Recent Blogs -->
                    @if (count($recentBlogs) > 0)
                    <div class="flex flex-wrap items-end -mx-4 mb-4">
                        <div class="w-full px-4 lg:mb-0">
                            <h1 class="font-heading tracking-tight text-4xl sm:text-5xl lg:text-6xl font-bold text-white mb-4">{{ __('Recent Blogs') }}</h1>
                        </div>
                    </div>
                    <div class="flex flex-wrap -mx-4 -mb-8">
                        @foreach ($recentBlogs as $blog)
                        <div class="w-full md:w-1/3 lg:w-1/3 px-4 mb-16">
                            <a class="flex flex-col h-full p-2 rounded-xl border border-gray-800 shadow-lg hover:border-yellowGreen-500 ring ring-transparent hover:ring-yellowGreen-500"
                                href="{{ route('web.view.blog', $blog->slug) }}">
                                <div class="h-72 rounded-lg overflow-hidden">
                                    <img class="block w-full h-full object-cover"
                                        src="{{ asset($blog->cover_image) }}" alt="{{ $blog->heading }}">
                                </div>
                                <div class="flex-grow-1 pt-6 px-2 pb-4">
                                    <div class="flex mb-4 items-center">
                                        <span
                                            class="inline-flex items-center h-6 px-2 text-xs text-white font-medium bg-gray-800 rounded-full"> {{ $blog->blogCategory->blog_category_title }}</span>
                                        <span class="inline-block mx-4">
                                            <svg width="1" height="24" viewbox="0 0 1 24" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <line x1="0.5" y1="2.18558e-08" x2="0.499999" y2="24"
                                                    stroke="#3B5444"></line>
                                            </svg>
                                        </span>
                                        <span class="text-sm text-gray-400">{{ Carbon\Carbon::parse($blog->created_at)->format('d M Y') }}</span>
                                    </div>
                                    <h2 class="max-w-xs tracking-tight text-xl text-white font-semibold mb-4">{{ $blog->heading }}</h2>
                                </div>
                            </a>
                        </div>
                        @endforeach
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </section>

    {{-- Footer --}}
    @include('website.modern.includes.footer')
@endsection
