@extends('layouts.modern')

{{-- Custom JS --}}
@section('custom-css')
    {{-- AdSense status --}}
    @if ($setting->adsense_code != 'DISABLE')
        {{-- AdSense code --}}
        <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client={{ $setting->adsense_code }}"
            crossorigin="anonymous"></script>
    @endif
@endsection

@section('content')
    {{-- Topbar --}}
    @include('website.modern.includes.topbar')

    {{-- Blogs --}}
    <section class="relative py-12 md:py-24 bg-gray-900">
        <div class="container px-4 mx-auto">
            <div class="flex flex-wrap items-end -mx-4 mb-24">
                <div class="w-full px-4 mb-14 lg:mb-0">
                    <span
                    class="inline-flex items-center h-6 md:h-6 mb-3 px-2 text-sm md:text-md text-center font-medium text-white bg-gradient-to-br from-cyanGreen-800 to-cyan-800 rounded-full">{{ __('Blogs')}}</span>
                    <h1 class="font-heading tracking-tight text-4xl sm:text-5xl lg:text-6xl font-bold text-white mb-4">{{ __('Optimer: Revolutionizing Image Optimization for Peak Performance') }}</h1>
                    <p class="text-lg text-gray-400">{{ __('Unlocking Maximum Efficiency with High-Quality Compression for JPG, PNG, SVG, WEBP, and GIF Files') }}</p>
                </div>
            </div>

            {{-- Blogs --}}
            @if (count($blogs) > 0)
            <div class="flex flex-wrap -mx-4 -mb-8">
                @foreach ($blogs as $blog)
                <div class="w-full md:w-1/2 lg:w-1/3 px-4 mb-16">
                    <a class="flex flex-col h-full p-2 rounded-xl border border-gray-800 shadow-lg hover:border-yellowGreen-500 ring ring-transparent hover:ring-yellowGreen-500"
                        href="{{ route('web.view.blog', $blog->slug) }}">
                        <div class="h-72 rounded-lg overflow-hidden">
                            <img class="block w-full h-full object-cover"
                                src="{{ asset($blog->cover_image) }}" alt="{{ $blog->heading }}">
                        </div>
                        <div class="flex-grow-1 pt-6 px-2 pb-4">
                            <div class="flex mb-4 items-center">
                                <span
                                    class="inline-flex items-center h-6 px-2 text-xs text-white font-medium bg-gray-800 rounded-full"> {{ $blog->blogCategory->blog_category_title }}</span>
                                <span class="inline-block mx-4">
                                    <svg width="1" height="24" viewbox="0 0 1 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <line x1="0.5" y1="2.18558e-08" x2="0.499999" y2="24"
                                            stroke="#3B5444"></line>
                                    </svg>
                                </span>
                                <span class="text-sm text-gray-400">{{ Carbon\Carbon::parse($blog->created_at)->format('d M Y') }}</span>
                            </div>
                            <h2 class="max-w-xs tracking-tight text-xl text-white font-semibold mb-4">{{ $blog->heading }}</h2>
                            <p class="text-base md:text-md text-gray-400 font-small">{{ $blog->short_description }}</p>
                        </div>
                    </a>
                </div>
                @endforeach
            </div>

            {{-- Pagination --}}
            {{ $blogs->links('vendor.pagination.blog') }}
            @else
            <div class="flex flex-wrap -mx-4 -mb-8">
                <div class="w-full md:w-1/2 lg:w-1/3 px-4 mb-16">
                    <h3
                        class="mb-4 text-3xl md:text-4xl leading-tight text-white font-bold tracking-tighter">
                        {{ __('No blog posts found!') }}</h3>
                </div>
            </div>
            @endif
        </div>
    </section>

    {{-- Footer --}}
    @include('website.modern.includes.footer')
@endsection
