@extends('layouts.modern')

{{-- Custom JS --}}
@section('custom-css')
    {{-- AdSense status --}}
    @if ($setting->adsense_code != 'DISABLE')
        {{-- AdSense code --}}
        <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client={{ $setting->adsense_code }}"
            crossorigin="anonymous"></script>
    @endif
@endsection

@php
    use App\Models\Page;

    $page = Page::where('slug', 'about')
        ->where('status', 1)
        ->get();
@endphp

@section('content')
    {{-- Topbar --}}
    @include('website.modern.includes.topbar')

    {{-- About us --}}
    <section class="relative py-12 md:py-12 bg-gray-900">
        <div class="container px-4 mx-auto">
            <div class="max-w-4xl mx-auto text-center mb-12">
                <span
                    class="inline-flex items-center h-6 md:h-6 mb-3 px-2 text-sm md:text-md text-center font-medium text-white bg-gradient-to-br from-cyanGreen-800 to-cyan-800 rounded-full">{{ __($page[0]->body)}}</span>
                <h2 class="font-heading tracking-tight text-4xl sm:text-5xl font-bold text-white">{{ __($page[1]->body) }}</h2>
            </div>
            <div class="max-w-full mx-auto">
                <div class="flex mb-12 py-6 px-2 justify-between items-center border-t border-b border-gray-700">
                <div class="mb-2">
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[2]->body) }}</p>
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[3]->body) }}</p>
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[4]->body) }}</p>
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[5]->body) }}</p>
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[6]->body) }}</p>
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[7]->body) }}</p>
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[8]->body) }}</p>
                    <p class="text-lg text-gray-300 mb-6">{{ __($page[9]->body) }}</p>
                    <p class="text-lg text-gray-300">{{ __($page[10]->body) }}</p>
                </div>
            </div>
        </div>
    </section>

    {{-- Footer --}}
    @include('website.modern.includes.footer')
@endsection
