@extends('layouts.modern')

{{-- Custom JS --}}
@section('custom-css')
<style>
    @keyframes textShine {
        0% {
        background-position: 0% 50%;
        }
        100% {
        background-position: 100% 50%;
        }
    }
    
    .textShine {
        font-weight: 800;
        background: linear-gradient(
        to right,
        #efffd5 20%,
        #25aca0 70%,
        #A3E33A 80%
        );
        -webkit-background-clip: text;
        background-clip: text;
        -webkit-text-fill-color: transparent;
        text-fill-color: transparent;
        background-size: 500% auto;
        animation: textShine 5s ease-in-out infinite alternate;
    }
    
    td {
        max-width: 100px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    
    .drop-wrapper {
        max-width: 50rem;
        padding: 2.5rem 1rem;
        border: 2px solid #91D85A;
        border-radius: 30px;
        background: rgba(68, 68, 68, 0.2);
    }
    
    .pen_info {
        margin: 1rem 0;
        padding: 0 1rem;
        border-radius: 0.4rem;
    }
    
    .dropzone {
        box-sizing: border-box !important;
        display: none;
        position: fixed !important;
        width: 100% !important;
        height: 100% !important;
        left: 0 !important;
        top: 0 !important;
        z-index: 99999 !important;
        background: rgba(18, 18, 17, 0.95) !important;
        border: 1px dashed #91D85A !important;
        justify-content: center !important;
        align-items: center !important;
    }
    
    .dropzone::before {
        color: #ffffff !important;
        font-size: 50px !important; 
        padding: 50%;
        content: "Drop image anywhere" !important;
        font-family: fantasy !important;
    }
</style>

{{-- AdSense status --}}
@if ($setting->adsense_code != "DISABLE")
{{-- AdSense code --}}
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client={{ $setting->adsense_code }}" crossorigin="anonymous"></script>
@endif
@endsection

@php
use App\Models\Page;

$page = Page::where('slug', 'home')->where('status', 1)->get();
$planPage = Page::where('slug', 'pricing')->where('status', 1)->get();

// Byte conversion
function formatBytes($size, $precision = 2)
{
    $base = log($size, 1024);
    $suffixes = array('', 'kB', 'MB', 'GB', 'TB');

    return round(pow(1024, $base - floor($base)), $precision) .''. $suffixes[floor($base)];
}
@endphp

@section('content')
{{-- Topbar --}}
@include('website.modern.includes.topbar')

{{-- Features --}}
<section class="py-12 md:py-24 bg-gray-900">
    <div class="container px-4 mx-auto">
        <div>
            <div class="max-w-2xl mx-auto mb-24 text-center">
                <span
                    class="inline-flex items-center h-6 md:h-6 mb-3 px-2 text-sm md:text-md text-center font-medium text-white bg-gradient-to-br from-cyanGreen-800 to-cyan-800 rounded-full">{{ __('Features')}}</span>
                <h1 class="font-heading tracking-tight text-4xl sm:text-5xl font-bold text-white mb-4">
                    {{ __($page[20]->body) }}
                </h1>
                <p class="text-gray-400">
                    {{ __($page[19]->body) }}
                </p>
            </div>
            <div class="flex flex-wrap -mx-4 -mb-16">
                <div class="w-full sm:w-1/2 lg:w-1/3 px-4 mb-16">
                    <div class="max-w-xs lg:px-4 mx-auto text-center">
                        <div class="flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-gray-800">
                            <svg width="33" height="32" viewbox="0 0 33 32" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M4.33301 23.4V8.6C4.33301 8.26863 4.60164 8 4.93301 8H22.6786C22.8792 8 23.0665 8.10026 23.1778 8.26718L28.1111 15.6672C28.2455 15.8687 28.2455 16.1313 28.1111 16.3328L23.1778 23.7328C23.0665 23.8997 22.8792 24 22.6786 24H4.93301C4.60164 24 4.33301 23.7314 4.33301 23.4Z"
                                    stroke="white" stroke-width="1.5"></path>
                            </svg>
                        </div>
                        <div class="mt-3">
                            <h5 class="text-xl font-bold text-white mb-1">
                                {{ __($page[21]->body) }}
                            </h5>
                            <p class="text-lg text-gray-400">
                                {{ __($page[22]->body) }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="w-full sm:w-1/2 lg:w-1/3 px-4 mb-16">
                    <div class="max-w-xs lg:px-4 mx-auto text-center">
                        <div class="flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-gray-800">
                            <svg width="33" height="32" viewbox="0 0 33 32" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M3 14.6667V5.93334C3 5.60197 3.26863 5.33334 3.6 5.33334H12.1114C12.2546 5.33334 12.3931 5.38458 12.5019 5.47779L16.8315 9.1889C16.9402 9.28211 17.0787 9.33334 17.222 9.33334H29.0667C29.398 9.33334 29.6667 9.60197 29.6667 9.93334V14.6667M3 14.6667V26.0667C3 26.398 3.26863 26.6667 3.6 26.6667H29.0667C29.398 26.6667 29.6667 26.398 29.6667 26.0667V14.6667M3 14.6667H29.6667"
                                    stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                </path>
                            </svg>
                        </div>
                        <div class="mt-3">
                            <h5 class="text-xl font-bold text-white mb-1">
                                {{ __($page[23]->body) }}
                            </h5>
                            <p class="text-lg text-gray-400">
                                {{ __($page[24]->body) }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="w-full sm:w-1/2 lg:w-1/3 px-4 mb-16">
                    <div class="max-w-xs lg:px-4 mx-auto text-center">
                        <div class="flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-gray-800">
                            <svg width="33" height="32" viewbox="0 0 33 32" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M19 15.9968C19 12.6745 15.9107 9.33334 12.1429 9.33334C11.6965 9.33334 10.2254 9.33335 9.85714 9.33335C6.07005 9.33335 3 12.3167 3 15.9968C3 19.1681 5.27964 21.8219 8.33333 22.4952C8.82341 22.6033 9.33342 22.6603 9.85714 22.6603"
                                    stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                </path>
                                <path
                                    d="M13.666 15.9968C13.666 19.3191 16.7553 22.6603 20.5232 22.6603C20.9695 22.6603 22.4406 22.6603 22.8089 22.6603C26.596 22.6603 29.666 19.677 29.666 15.9968C29.666 12.8256 27.3864 10.1718 24.3327 9.49843C23.8426 9.39037 23.3326 9.33331 22.8089 9.33331"
                                    stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                </path>
                            </svg>
                        </div>
                        <div class="mt-3">
                            <h5 class="text-xl font-bold text-white mb-1">
                                {{ __($page[25]->body) }}
                            </h5>
                            <p class="text-lg text-gray-400">
                                {{ __($page[26]->body) }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="w-full sm:w-1/2 lg:w-1/3 px-4 mb-16">
                    <div class="max-w-xs lg:px-4 mx-auto text-center">
                        <div class="flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-gray-800">
                            <svg width="33" height="32" viewbox="0 0 33 32" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_3018_21098)">
                                    <path
                                        d="M1.66602 26.6667V23C1.66602 19.134 4.80002 16 8.66601 16H13.3327C17.1987 16 20.3327 19.134 20.3327 23V26.6667"
                                        stroke="white" stroke-width="1.5" stroke-linecap="round"></path>
                                    <path
                                        d="M17.666 18.6667V18.6667C17.666 14.9848 20.6508 12 24.3327 12V12C28.0146 12 30.9993 14.9848 30.9993 18.6667V19.3333"
                                        stroke="white" stroke-width="1.5" stroke-linecap="round"></path>
                                    <path
                                        d="M10.9993 16C13.9449 16 16.3327 13.6122 16.3327 10.6667C16.3327 7.72115 13.9449 5.33334 10.9993 5.33334C8.05383 5.33334 5.66602 7.72115 5.66602 10.6667C5.66602 13.6122 8.05383 16 10.9993 16Z"
                                        stroke="white" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                    <path
                                        d="M24.333 12C26.5421 12 28.333 10.2091 28.333 8C28.333 5.79086 26.5421 4 24.333 4C22.1239 4 20.333 5.79086 20.333 8C20.333 10.2091 22.1239 12 24.333 12Z"
                                        stroke="white" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                </g>
                            </svg>
                        </div>
                        <div class="mt-3">
                            <h5 class="text-xl font-bold text-white mb-1">
                                {{ __($page[27]->body) }}
                            </h5>
                            <p class="text-lg text-gray-400">
                                {{ __($page[28]->body) }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="w-full sm:w-1/2 lg:w-1/3 px-4 mb-16">
                    <div class="max-w-xs lg:px-4 mx-auto text-center">
                        <div class="flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-gray-800">
                            <svg width="33" height="32" viewbox="0 0 33 32" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M28.333 4.6V27.4C28.333 27.7314 28.0644 28 27.733 28H4.93301C4.60164 28 4.33301 27.7314 4.33301 27.4V4.6C4.33301 4.26863 4.60164 4 4.93301 4H27.733C28.0644 4 28.333 4.26863 28.333 4.6Z"
                                    stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                </path>
                                <path
                                    d="M13.2307 11.1796C12.8307 10.9511 12.333 11.2399 12.333 11.7006V20.2994C12.333 20.7601 12.8307 21.0489 13.2307 20.8204L20.7547 16.5209C21.1578 16.2906 21.1578 15.7094 20.7547 15.4791L13.2307 11.1796Z"
                                    stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                </path>
                            </svg>
                        </div>
                        <div class="mt-3">
                            <h5 class="text-xl font-bold text-white mb-1">
                                {{ __($page[29]->body) }}
                            </h5>
                            <p class="text-lg text-gray-400">
                                {{ __($page[30]->body) }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="w-full sm:w-1/2 lg:w-1/3 px-4 mb-16">
                    <div class="max-w-xs lg:px-4 mx-auto text-center">
                        <div class="flex items-center justify-center w-16 h-16 mx-auto rounded-full bg-gray-800">
                            <svg width="33" height="32" viewbox="0 0 33 32" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_3018_21112)">
                                    <path d="M11 24L15 28L21.6667 21.3333" stroke="white" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path
                                        d="M26.9993 23.4763C28.991 22.6962 30.9993 20.9185 30.9993 17.3333C30.9993 12 26.5549 10.6667 24.3327 10.6667C24.3327 8 24.3327 2.66666 16.3327 2.66666C8.33268 2.66666 8.33268 8 8.33268 10.6667C6.11046 10.6667 1.66602 12 1.66602 17.3333C1.66602 20.9185 3.67438 22.6962 5.66602 23.4763"
                                        stroke="white" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                </g>
                            </svg>
                        </div>
                        <div class="mt-3">
                            <h5 class="text-xl font-bold text-white mb-1">
                                {{ __($page[31]->body) }}
                            </h5>
                            <p class="text-lg text-gray-400">
                                {{ __($page[32]->body) }}
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

{{-- Plans --}}
<section class="py-12 md:py-24 bg-gray-900">
    <div class="container px-4 mx-auto">
        <div class="max-w-sm md:max-w-md lg:max-w-8xl mx-auto">
            <div class="text-center mb-16">
                <span
                    class="inline-flex items-center h-6 md:h-6 mb-3 px-2 text-sm md:text-md text-center font-medium text-white bg-gradient-to-br from-cyanGreen-800 to-cyan-800 rounded-full">{{ __('Pricing')}}</span>
                <h1 class="font-heading tracking-tight text-4xl sm:text-5xl font-bold text-white mb-4">
                    {{ __($planPage[1]->body) }}
                </h1>
                <p class="text-lg text-gray-400">
                    {{ __($planPage[2]->body) }}
                </p>
            </div>
            <div class="flex flex-wrap -mx-4">
                {{-- all plans --}}
                @foreach ($plans as $plan)
                <div class="w-full lg:w-1/3 px-4 mb-12 lg:mb-0">
                    <div class="{{ $plan->recommended == 1 ? 'relative bg-white border border-gray-100' : 'bg-gray-900 border border-gray-700' }} p-8 mb-10 rounded-xl shadow-sm">
                        @if ($plan->recommended == 1)
                        <span class="absolute top-0 right-0 m-8 inline-block px-2.5 leading-relaxed text-sm text-white bg-gray-800 uppercase rounded-full">{{ __('Popular') }}</span>
                        @endif
                        <div class="flex mb-8 items-center">
                            <span class="mr-3">
                                <svg width="24" height="24" viewbox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M15 3.6V14.4C15 14.7314 14.7314 15 14.4 15H3.6C3.26863 15 3 14.7314 3 14.4V3.6C3 3.26863 3.26863 3 3.6 3H14.4C14.7314 3 15 3.26863 15 3.6Z"
                                        stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                    <path d="M13.5 21H16.5" stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                    <path d="M21 13.5V16.5" stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                    <path d="M21 19.5V20.4C21 20.7314 20.7314 21 20.4 21H19.5" stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}"
                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M10.5 21H9.6C9.26863 21 9 20.7314 9 20.4V19.5" stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}"
                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M19.5 9H20.4C20.7314 9 21 9.26863 21 9.6V10.5" stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}"
                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M16.5 9H9.6C9.26863 9 9 9.26863 9 9.6V16.5" stroke="{{ $plan->recommended == 1 ? 'black' : 'white' }}"
                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>
                            </span>
                            <span class="text-base font-semibold {{ $plan->recommended == 1 ? '' : 'text-white' }} uppercase">{{ __($plan->name) }}</span>
                        </div>
                        <div class="flex items-end mb-4">
                            {{-- Price --}}
                            @if ($plan->price == 0)
                            <span class="mr-2 text-5xl font-semibold {{ $plan->recommended == 1 ? '' : 'text-white' }} tracking-tighter">{{ __('Free') }}</span>
                            @else
                                <span class="mr-2 text-5xl font-semibold {{ $plan->recommended == 1 ? '' : 'text-white' }} tracking-tighter">
                                    {{ currency($plan->price) }}
                                </span>
                            @endif
                        
                            <span class="inline-block pb-2 text-lg text-gray-400">
                            /
                            @if ($plan->price != 0 && $plan->validity == 9999)
                                {{ __('Forever') }}</span>
                            @endif
                            @if ($plan->validity == 31)
                            {{ __('Per Month') }}</span>
                            @endif
                            @if ($plan->validity == 366)
                            {{ __('Per Year') }}</span>
                            @endif
                            @if ($plan->validity > 1 && $plan->validity != 31 && $plan->validity != 366 &&
                            $plan->validity != 9999)
                            {{ 'Per'.' '.$plan->validity.' '.__('Days') }}</span>
                            @endif
                            </span>
                        </div>
                        <span class="block text-gray-400 mb-8">{{ __($plan->description) }}</span>
                        <div class="p-4 mb-8 border {{ $plan->recommended == 1 ? 'border-gray-200' : 'border-teal-800' }} rounded-xl">
                            {{-- Formats --}}
                            <div class="mb-4">
                                <span class="text-{{ $plan->recommended == 1 ? 'black' : 'white' }}">{{ $plan->formats == 9999 ? __('Unlimited') : $plan->formats }}</span>
                                <span class="text-gray-{{ $plan->recommended == 1 ? '400' : '400' }} text-sm">{{ __('Formats') }}</span>
                            </div>
                            {{-- Optimize Images --}}
                            <div class="mb-4">
                                <span class="text-{{ $plan->recommended == 1 ? 'black' : 'white' }}">{{ $plan->maximum == 9999 ? __('Unlimited') : $plan->maximum }}</span>
                                <span class="text-gray-{{ $plan->recommended == 1 ? '400' : '400' }} text-sm">{{ __('Optimize Images') }}</span>
                            </div>
                            {{-- Upload Limit --}}
                            <div class="mb-4">
                                <span class="text-{{ $plan->recommended == 1 ? 'black' : 'white' }}">{{ formatBytes($plan->size) }}</span>
                                <span class="text-gray-{{ $plan->recommended == 1 ? '400' : '400' }} text-sm">{{ __('Upload Limit') }}</span>
                            </div>
                            {{-- Storage --}}
                            <div class="mb-4">
                                <span class="text-{{ $plan->recommended == 1 ? 'black' : 'white' }}">{{ formatBytes($plan->storage) }}</span>
                                <span class="text-gray-{{ $plan->recommended == 1 ? '400' : '400' }} text-sm">{{ __('Storage') }}</span>
                            </div>
                            {{-- APIs Request --}}
                            <div class="mb-4">
                                <span class="text-{{ $plan->recommended == 1 ? 'black' : 'white' }}">{{ $plan->limit != 0 ? $plan->limit : 0 }}</span>
                                <span class="text-gray-{{ $plan->recommended == 1 ? '400' : '400' }} text-sm">{{ __('APIs Request') }}</span>
                            </div>
                            {{-- Cloud Storage (S3) --}}
                            <div class="flex items-start mb-4">
                                @if ($plan->s3 == 1)
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg width="14" height="14" viewbox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2.91699 7.58337L5.25033 9.91671L11.0837 4.08337" stroke="white"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </span>
                                @else
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" stroke-width="1.5" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M18 6l-12 12" />
                                        <path d="M6 6l12 12" />
                                    </svg>
                                </span>
                                @endif
                                <div class="ml-4">
                                    <p class="text-sm">
                                        <span class="text-gray-400 text-sm">{{ __('Cloud Storage (S3)') }}</span>
                                    </p>
                                </div>
                            </div>
                            {{-- Daily Usage Statistics --}}
                            <div class="flex items-start mb-4">
                                @if ($plan->statistics == 1)
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg width="14" height="14" viewbox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2.91699 7.58337L5.25033 9.91671L11.0837 4.08337" stroke="white"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </span>
                                @else
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" stroke-width="1.5" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M18 6l-12 12" />
                                        <path d="M6 6l12 12" />
                                    </svg>
                                </span>
                                @endif
                                <div class="ml-4">
                                    <p class="text-sm">
                                        <span class="text-gray-400 text-sm">{{ __('Daily Usage Statistics') }}</span>
                                    </p>
                                </div>
                            </div>
                            {{-- Media Library --}}
                            <div class="flex items-start mb-4">
                                @if ($plan->media_library == 1)
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg width="14" height="14" viewbox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2.91699 7.58337L5.25033 9.91671L11.0837 4.08337" stroke="white"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </span>
                                @else
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" stroke-width="1.5" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M18 6l-12 12" />
                                        <path d="M6 6l12 12" />
                                    </svg>
                                </span>
                                @endif
                                <div class="ml-4">
                                    <p class="text-sm">
                                        <span class="text-gray-400 text-sm">{{ __('Media Library') }}</span>
                                    </p>
                                </div>
                            </div>
                            {{-- Conversation APIs --}}
                            <div class="flex items-start mb-4">
                                @if ($plan->api == 1)
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg width="14" height="14" viewbox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2.91699 7.58337L5.25033 9.91671L11.0837 4.08337" stroke="white"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </span>
                                @else
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" stroke-width="1.5" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M18 6l-12 12" />
                                        <path d="M6 6l12 12" />
                                    </svg>
                                </span>
                                @endif
                                <div class="ml-4">
                                    <p class="text-sm">
                                        <span class="text-gray-400 text-sm">{{ __('Conversation APIs') }}</span>
                                    </p>
                                </div>
                            </div>
                            {{-- Additional Tools --}}
                            <div class="flex items-start mb-4">
                                @if ($plan->additional_tools == 1)
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg width="14" height="14" viewbox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2.91699 7.58337L5.25033 9.91671L11.0837 4.08337" stroke="white"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </span>
                                @else
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" stroke-width="1.5" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M18 6l-12 12" />
                                        <path d="M6 6l12 12" />
                                    </svg>
                                </span>
                                @endif
                                <div class="ml-4">
                                    <p class="text-sm">
                                        <span class="text-gray-400 text-sm">{{ __('Additional Tools') }}</span>
                                    </p>
                                </div>
                            </div>
                            {{-- Support --}}
                            <div class="flex items-start mb-4">
                                @if ($plan->support == 1)
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg width="14" height="14" viewbox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2.91699 7.58337L5.25033 9.91671L11.0837 4.08337" stroke="white"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </span>
                                @else
                                <span class="flex-shrink-0 inline-flex w-5 h-5 items-center justify-center bg-gray-800 rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" stroke-width="1.5" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M18 6l-12 12" />
                                        <path d="M6 6l12 12" />
                                    </svg>
                                </span>
                                @endif
                                <div class="ml-4">
                                    <p class="text-sm">
                                        <span class="text-gray-400 text-sm">{{ __('Support') }}</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                        {{-- Register --}}
                        @if ($plan->recommended == 1)
                        <a class="group relative flex items-center justify-center px-5 h-12 font-bold text-white bg-gradient-to-br from-cyanGreen-800 to-cyan-800 rounded-lg transition-all duration-300"
                            href="{{ route('register') }}">
                            <div
                                class="absolute top-0 left-0 w-full h-full rounded-lg ring ring-green-300 animate-pulse group-hover:ring-0 transition duration-300">
                            </div>
                            <span>{{ __('Get Started') }}</span>
                        </a> 
                        @else
                        <a class="group flex justify-center w-full h-12 p-1 text-center text-base text-white font-semibold rounded-lg"
                            href="{{ route('register') }}">
                            <div
                                class="inline-flex items-stretch w-full h-12 p-0.5 rounded-lg bg-gradient-to-b from-gray-500 via-gray-700 to-gray-700 hover:to-gray-800">
                                <div
                                    class="flex w-full items-center justify-center px-4 bg-gray-700 group-hover:bg-opacity-40 rounded-md transition duration-300">
                                    <span>{{ __('Get Started') }}</span>
                                </div>
                            </div>
                        </a>  
                        @endif
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>

{{-- Footer --}}
@include('website.modern.includes.footer')

{{-- Custom JS --}}
@section('custom-js')
<script src="{{ asset('js/smooth-scroll.js')}}"></script>
<script src="{{ asset('js/dropzone.min.js')}}"></script>
<script src="{{ asset('js/jszip.min.js') }}"></script>
<script>
    Dropzone.autoDiscover = false;

    var dropZone = document.getElementById('dropzone');
    
    function showDropZone() {
        dropZone.style.display = "flex";
    }
    function hideDropZone() {
        dropZone.style.display = "none";
    }
    
    function allowDrag(e) {
        if (true) {  // Test that the item being dragged is a valid one
            e.dataTransfer.dropEffect = 'copy';
            e.preventDefault();
        }
    }
    
    function handleDrop(e) {
        e.preventDefault();
        hideDropZone(); 
    }
    
    // 1
    window.addEventListener('dragenter', function(e) {
        showDropZone();
    });
    
    // 2
    dropZone.addEventListener('dragenter', allowDrag);
    dropZone.addEventListener('dragover', allowDrag);
    
    // 3
    dropZone.addEventListener('dragleave', function(e) {
        console.log('dragleave');
        hideDropZone();
    });
    
    // 4
    dropZone.addEventListener('drop', handleDrop);

    $(document).ready(function () {
        $(["#formDropzone", "#dropzone"]).dropzone({
            maxFilesize: {{ $config[36]->config_value }},
            maxFiles: {{ $config[35]->config_value }},
            acceptedFiles: `{{ $acceptedFiles }}`,
            url: `{{ route('optimize.image') }}`,
            autoProcessQueue: true,
            addRemoveLinks: true,
            previewTemplate: '<div style="display:none"></div>',
            timeout: 180000,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function (file, response) {
            if(response.status == true) {
                    $('.errorStatus').hide();
                    $('#success').show();
                    $('.optimizeDownload').removeClass('hidden');
                    $('table[id="optimizeData"]').append(`<tr>
                        <td class="py-2 px-4 border-b">
                            `+response.file_name+`
                        </td>
                        <td class="py-2 px-4 border-b hidden md:table-cell">
                            `+formatBytes(response.size)+`
                        </td>
                        <td class="py-2 px-4 border-b hidden md:table-cell">
                            `+formatBytes(response.optimizeSize)+`
                        </td>
                        <td class="py-2 px-4 border-b">
                            `+formatBytes(Math.round(response.savedYou))+`
                        </td>
                        <td class="py-2 px-4 border-b">
                            <a class="bg-gradient-to-br from-cyanGreen-800 to-cyan-800 hover:bg-cyanGreen-700 text-white font-bold py-1 px-2 rounded" id="download-`+Math.round(response.size)+`">{{ __('Download') }}</a>
                        </td>
                    </tr>`);

                    // Save image URL to local storage
                    saveImageURL(response.url, Math.round(response.size));
                } else {
                    $('.errorStatus').show();
                };
            },
        });
   });

   // Save image URL to local storage
   function saveImageURL(url, id) {
        // Get existing URLs from local storage
        let existingURLs = JSON.parse(localStorage.getItem("storedImageURLs")) || [];
        
        // Add the new URL to the list
        existingURLs.push(url);

        // Save the updated list back to local storage
        localStorage.setItem("storedImageURLs", JSON.stringify(existingURLs));

        // Generate a random name for the file
        const randomName = generateRandomName();

        // Set href value
        var downloadLink = document.getElementById("download-"+id);
        downloadLink.getAttribute("href");
        downloadLink.setAttribute("href", url);
        downloadLink.setAttribute("download", randomName);
    }

    // Delete local storage items on page refresh
    window.addEventListener("beforeunload", function() {
        localStorage.removeItem("storedImageURLs");
    });

    // Download all in ZIP format
    document.getElementById("downloadAll").addEventListener("click", function() {
        // Get image URLs from local storage
        let imageURLs = JSON.parse(localStorage.getItem("storedImageURLs")) || [];

        if (imageURLs.length === 0) {
            alert("No images to download.");
            return;
        }

        // Create a new instance of JSZip
        let zip = new JSZip();
        let appName = `{{ config('app.name') }}`;
        appName.replace(' ', '-');

        // Download each image and add it to the zip file
        let promises = imageURLs.map(function(url, index) {
            return fetch(url)
                .then(response => response.blob())
                .then(blob => zip.file(appName+`-${index + 1}.png`, blob));
        });

        // After all images are added, create and download the zip file
        Promise.all(promises).then(function() {
            zip.generateAsync({ type: "blob" })
                .then(function(content) {
                    // Trigger the download
                    const a = document.createElement("a");
                    const url = URL.createObjectURL(content);
                    a.href = url;
                    a.download = appName+".zip";
                    document.body.appendChild(a);
                    a.click();
                    document.body.removeChild(a);
                    URL.revokeObjectURL(url);
                });
        });
    });

    function formatBytes(bytes, decimals = 2) {
        if (!+bytes) return '0kB'

        const k = 1024
        const dm = decimals < 0 ? 0 : decimals
        const sizes = ['Bytes', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB']

        const i = Math.floor(Math.log(bytes) / Math.log(k))

        return `${parseFloat((bytes / Math.pow(k, i)).toFixed(dm))}${sizes[i]}`
    }

    // Function to generate a random name for the file
    function generateRandomName() {
        const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        const length = 10; // Adjust the length of the random name as needed
        let randomName = '';

        for (let i = 0; i < length; i++) {
            const randomIndex = Math.floor(Math.random() * characters.length);
            randomName += characters.charAt(randomIndex);
        }

        return randomName;
    }
</script>
@endsection
@endsection