{{-- Custom CSS --}}
@section('custom-css')
{{-- <link rel="stylesheet" href="{{ asset('css/styles.css') }}"> --}}
@endsection

@php
// Settings
use App\Models\Setting;
use App\Models\Page;
use App\Models\Blog;

$setting = Setting::where('status', 1)->first();
$pages = Page::where('status', 1)->get();
$blogs = Blog::where('status', 1)->count();
@endphp

<section class="relative bg-gray-900">
    <nav class="relative">
        <div class="container mx-auto px-4">
            <div class="relative flex h-24 items-center">
                <a class="inline-block" href="{{ route('web.index') }}">
                    <img class="h-10" src="{{ asset($setting->site_logo) }}" alt="{{ config('app.name') }}" />
                </a>
                <button
                    class="lg:hidden navbar-burger flex items-center justify-center h-10 w-10 ml-auto border border-teal-900 bg-teal-200 bg-opacity-30 hover:bg-teal-700 rounded-lg">
                    <svg width="24" height="24" viewbox="0 0 24 24" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path d="M3 5H21" stroke="white" stroke-width="1.5" stroke-linecap="round"
                            stroke-linejoin="round"></path>
                        <path d="M3 12H21" stroke="white" stroke-width="1.5" stroke-linecap="round"
                            stroke-linejoin="round"></path>
                        <path d="M3 19H21" stroke="white" stroke-width="1.5" stroke-linecap="round"
                            stroke-linejoin="round"></path>
                    </svg>
                </button>
                <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 hidden lg:flex items-center">
                    {{-- Home --}}
                    <a class="inline-block text-white hover:text-teal-400 mr-10 {{ request()->is('/') ? 'font-bold' : '' }}" href="{{ route('web.index') }}">{{  __('Home') }}</a>
                    
                    {{-- Features --}}
                    <a class="inline-block text-white hover:text-teal-400 mr-10 {{ request()->is('features') ? 'font-bold' : '' }}" href="{{ route('web.features') }}">{{  __('Features') }}</a>
                    
                    {{-- About Us --}}
                    @if($pages[41]->slug == 'about' && $pages[41]->status == 1)
                    <a class="inline-block text-white hover:text-teal-400 mr-10 {{ request()->is('about') ? 'font-bold' : '' }}" href="{{ route('web.about') }}">{{  __('About Us') }}</a>
                    @endif

                    {{-- Pricing --}}
                    @if($pages[51]->slug == 'pricing' && $pages[51]->status == 1)
                    <a class="inline-block text-white hover:text-teal-400 mr-10 {{ request()->is('pricing') ? 'font-bold' : '' }}" href="{{ route('web.pricing') }}">{{  __('Pricing') }}</a>
                    @endif

                    {{-- Blogs --}}
                    @if($blogs > 0)
                    <a class="inline-block text-white hover:text-teal-400 mr-10 {{ request()->is('blogs') || request()->is('blog*') ? 'font-bold' : '' }}" href="{{ route('web.blogs') }}">{{  __('Blogs') }}</a>
                    @endif

                    {{-- Contact Us --}} 
                    @if($pages[56]->slug == 'contact' && $pages[56]->status == 1)
                    <a class="inline-block text-white hover:text-teal-400 mr-10 {{ request()->is('contact') ? 'font-bold' : '' }}" href="{{ route('web.contact') }}">{{  __('Contact') }}</a>
                    @endif

                    <!-- Custom Pages -->
                    @if($pages)
                        @foreach($pages as $page)
                            @if($page->slug != 'home' && $page->slug != 'about' && $page->slug != 'contact' && $page->slug != 'faq' && $page->slug != 'pricing' && $page->slug != 'privacy-policy' && $page->slug != 'refund-policy' && $page->slug != 'terms-and-conditions')
                                <a class="inline-block text-white hover:text-teal-400 mr-10 {{ request()->is($page->slug) ? 'font-bold' : '' }}" href="{{ route('web.custom.page', $page->slug) }}">{{ __($page->title) }}</a>
                            @endif
                        @endforeach
                    @endif
                </div>

                {{-- Login & Register --}}
                <div class="hidden lg:block ml-auto">

                    {{-- Languages --}}
                    @if(count(config('app.languages')) > 1)
                    <div class="dropdown inline-block relative">
                        <button class="text-white font-semibold py-2 px-4 rounded inline-flex items-center">
                            <span class="mr-1">{{ strtoupper(app()->getLocale()) }}</span>
                            <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z" />
                            </svg>
                        </button>
                        <ul class="text-white dropdown-menu absolute hidden pt-1">
                            @foreach(config('app.languages') as $langLocale => $langName)
                            <li class="">
                                <a class="py-2 px-4 block whitespace-no-wrap" href="{{ url()->current() }}?change_language={{ $langLocale }}">{{ strtoupper($langName) }}</a>
                            </li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @guest
                        {{-- Login --}}
                        @if (Route::has('login'))
                        <a class="inline-flex items-center justify-center h-10 mr-4 px-4 text-center text-sm text-white hover:text-teal-400 font-semibold transition duration-200"
                            href="{{ route('login') }}">{{ __('Login') }}</a>
                        @endif

                        {{-- Register --}}
                        @if (Route::has('register'))
                        <a class="group inline-block justify-center p-1 text-center text-sm text-white font-semibold rounded-lg"
                            href="{{ route('register') }}">
                            <div
                                class="inline-flex items-stretch h-10 p-0.5 rounded-lg bg-gradient-to-b from-gray-500 via-gray-700 to-gray-700 hover:to-gray-800">
                                <div
                                    class="flex items-center px-4 bg-gray-700 group-hover:bg-opacity-40 rounded-md transition duration-300">
                                    <span>{{ __('Get Started') }}</span>
                                </div>
                            </div>
                        </a>
                        @endif
                    @else
                        {{-- Dashboard --}}
                        <a class="group inline-block justify-center p-1 text-center text-sm text-white font-semibold rounded-lg"
                            href="{{ route('user.dashboard') }}">
                            <div
                                class="inline-flex items-stretch h-10 p-0.5 rounded-lg bg-gradient-to-b from-gray-500 via-gray-700 to-gray-700 hover:to-gray-800">
                                <div
                                    class="flex items-center px-4 bg-gray-700 group-hover:bg-opacity-40 rounded-md transition duration-300">
                                    <span>{{ __('Dashboard') }}</span>
                                </div>
                            </div>
                        </a>
                    @endguest
                </div>
            </div>
        </div>
    </nav>

    {{-- Banner --}}
    @php
    if(Request::is('/')) { @endphp

    @include('website.modern.includes.banner')

    @php } @endphp

    {{-- Mobile navbar --}}
    <div class="hidden navbar-menu fixed top-0 left-0 bottom-0 w-5/6 max-w-md z-50">
        <div class="navbar-backdrop fixed inset-0 bg-teal-800 opacity-70"></div>
        <nav class="relative flex flex-col py-6 px-10 w-full h-full bg-white overflow-y-auto">
            <div class="flex mb-auto items-center">
                <a class="inline-block mr-auto" href="#">
                    <img class="h-10" src="{{ asset($setting->site_logo) }}" alt="{{ config('app.name') }}" />
                </a>
                <a class="navbar-close" href="#">
                    <svg width="24" height="24" viewbox="0 0 24 24" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path d="M6 18L18 6M6 6L18 18" stroke="#111827" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round"></path>
                    </svg>
                </a>
            </div>
            <div class="py-12 mb-auto">
                <ul class="flex-col">
                    {{-- Home --}}
                    <li class="mb-6">
                        <a class="inline-block text-black" href="{{ route('web.index') }}">{{ __('Home') }}</a>
                    </li>

                    {{-- Features --}}
                    <li class="mb-6">
                        <a class="inline-block text-black" href="{{ route('web.features') }}">{{ __('Features') }}</a>
                    </li>

                    {{-- About us --}}
                    @if($pages[41]->slug == 'about' && $pages[41]->status == 1)
                    <li class="mb-6">
                        <a class="inline-block text-black" href="{{ route('web.about') }}">{{ __('About Us') }}</a>
                    </li>
                    @endif
                    
                    {{-- Pricing --}}
                    @if($pages[51]->slug == 'pricing' && $pages[51]->status == 1)
                    <li class="mb-6">
                        <a class="inline-block text-black" href="{{ route('web.pricing') }}">{{ __('Pricing') }}</a>
                    </li>
                    @endif

                    {{-- Blogs --}}
                    @if($blogs > 0)
                    <li class="mb-6">
                        <a class="inline-block text-black" href="{{ route('web.blogs') }}">{{ __('Blogs') }}</a>
                    </li>
                    @endif

                    {{-- Contact --}}
                    @if($pages[56]->slug == 'contact' && $pages[56]->status == 1)
                    <li class="mb-6">
                        <a class="inline-block text-black" href="{{ route('web.contact') }}">{{ __('Contact') }}</a>
                    </li>
                    @endif
                </ul>

                {{-- Languages --}}
                @if(count(config('app.languages')) > 1)
                <div class="dropdown inline-block relative">
                    <button class="rounded text-black inline-flex items-center">
                        <span class="mr-1">{{ strtoupper(app()->getLocale()) }}</span>
                        <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                            <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z" />
                        </svg>
                    </button>
                    <ul class="mobile-dropdown-menu absolute hidden h-60 pt-1">
                        @foreach(config('app.languages') as $langLocale => $langName)
                        <li class="">
                            <a class="py-2 px-4 text-black block whitespace-no-wrap" href="{{ url()->current() }}?change_language={{ $langLocale }}">{{ strtoupper($langName) }}</a>
                        </li>
                        @endforeach
                    </ul>
                </div>
                @endif
            </div>
            <div>
                {{-- Login & Register --}}
                @guest
                @if (Route::has('login'))

                <a class="flex items-center justify-center h-12 mb-4 px-4 text-center text-base text-gray-700 font-semibold border border-gray-200 hover:bg-gray-100 shadow-lg rounded-lg transition duration-200"
                    href="{{ route('login') }}">{{ __('Sign In') }}</a>
                @endif
                @if (Route::has('register'))
                <a class="flex items-center justify-center h-12 px-4 text-center text-base text-white font-semibold bg-gradient-to-b from-cyanGreen-800 to-cyan-800 rounded-lg transition duration-200"
                    href="{{ route('register') }}">{{ __('Get Started') }}</a>
                @endif
                @else
                <a class="flex items-center justify-center h-12 mb-4 px-4 text-center text-base text-gray-700 font-semibold border border-gray-200 hover:bg-gray-100 shadow-lg rounded-lg transition duration-200"
                    href="{{ route('user.dashboard') }}">{{ __('Dashboard') }}</a>
                @endguest
            </div>
        </nav>
    </div>
</section>
