@php
// Settings
use App\Models\Config;
use App\Models\Page;

$config = Config::get();
$page = Page::where('slug', 'home')->where('status', 1)->get();
@endphp

<div class="max-w-2xl mx-auto text-center h-80 md:mb-10 mb-8">
    <div id="dropzone" class="dropzone"></div>
    <div class="drop-wrapper">
        <div class="pen_info">
            <form action="{{ route('optimize.image') }}" class="shadow-lg" id="formDropzone" dz-max-files-reached="{{ $config[35]->config_value }}"
                enctype="multipart/form-data">
                @csrf
                <div class="dz-message font-bold text-white dropzone-width">
                    {{ __($page[7]->body) }} 
                    <span class="textShine">{{ __($page[8]->body) }}</span> 
                    {{ __($page[9]->body) }} <br> 
                    <span class="textShine mb-4">{{ __($page[11]->body) }} {{ $config[35]->config_value}} {{ __($page[10]->body) }} ({{ __('OR') }}) {{ $config[36]->config_value }} {{ __($page[12]->body) }}</span>
                    <br><br><span class="my-4">{{ __('OR') }}</span><br>
                    <a class="inline-block cursor-pointer lg:px-20 px-10 py-2 my-4 bg-gradient-to-br from-cyanGreen-800 to-cyan-800 hover:bg-cyanGreen-700 text-white font-bold leading-loose rounded-l-xl rounded-t-xl transition duration-200">{{ __('Choose an files') }}</a>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="overflow-x-auto optimizeDownload md:mt-2 mt-20 hidden">
    {{-- Download All --}}
    <div class="flex justify-between mb-4">
        <div></div>
        <button class="bg-gradient-to-br from-cyanGreen-800 to-cyan-800 hover:bg-cyanGreen-700 text-white font-bold py-2 px-4 rounded" id="downloadAll">
          {{ __('Download All') }}
        </button>
    </div>
    <table class="min-w-full border border-gray-300" id="optimizeData">
      <thead class="bg-gradient-to-br from-cyanGreen-800 to-cyan-800 text-white">
        <tr>
          <th class="py-2 px-4 border-b">{{ __($page[13]->body) }}</th>
          <th class="py-2 px-4 border-b hidden md:table-cell">{{ __($page[14]->body) }}</th>
          <th class="py-2 px-4 border-b hidden md:table-cell">{{ __($page[15]->body) }}</th>
          <th class="py-2 px-4 border-b">{{ __($page[16]->body) }}</th>
          <th class="py-2 px-4 border-b">{{ __($page[17]->body) }}</th>
        </tr>
      </thead>
      <tbody class="text-white text-center"></tbody>
    </table>
</div>