@php
    // Settings
    use App\Models\Config;
    use App\Models\Page;
    $config = Config::get();
    $page = Page::where('slug', 'home')
        ->where('status', 1)
        ->get();
@endphp

<div class="relative pt-10 pb-20 md:pt-40">
    <div class="container px-4 mx-auto"> 
        {{-- Check website optimer --}}
        @if ($config[34]->config_value != 1)
        <div class="max-w-full mb-14 mx-auto text-center">
            <a class="group relative inline-flex mb-6 items-center rounded-full overflow-hidden shadow-3xl"
                href="{{ url($page[4]->body) }}">
                <div
                    class="animate-showLine absolute bottom-0 left-1/2 transform -translate-x-1/2 p-px mx-auto w-auto bg-gradient-to-r from-transparent via-yellowGreen-500 to-transparent">
                </div>
                <div
                    class="flex flex-wrap sm:flex-nowrap items-center px-6 sm:px-4 py-4 sm:py-2 bg-gray-800 group-hover:bg-opacity-60 rounded-full transition duration-300">
                    <span class="text-lg text-white">{{ __('Optimize your JPG, PNG, SVG, WEBP or GIF with the best quality and compression.') }}</span>
                    <div class="mt-1 sm:mt-0 mx-auto sm:mr-0 sm:ml-2 flex items-center">
                        <span
                            class="text-lg text-transparent bg-clip-text bg-gradient-to-br font-bold from-green-500 via-teal-500 to-cyan-800 transition duration-300">{{ __('Read more') }}</span>
                        <span class="ml-3">
                            <svg width="11" height="10" viewbox="0 0 11 10" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M1.00004 5H9.33337M9.33337 5L5.33337 1M9.33337 5L5.33337 9"
                                    stroke="url(#paint0_linear_3112_14890)" stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round"></path>
                                <defs>
                                    <lineargradient id="paint0_linear_3112_14890" x1="9.46358" y1="-1.5"
                                        x2="5.46163" y2="9.11123" gradientunits="userSpaceOnUse">
                                        <stop stop-color="#ACE348">
                                            <stop offset="1" stop-color="#25ACA0"></stop>
                                        </stop>
                                    </lineargradient>
                                </defs>
                            </svg>
                        </span>
                    </div>
                </div>
            </a>
            <div class="max-w-lg sm:max-w-xl lg:max-w-none mx-auto">
                <h1 class="font-heading tracking-tight  sm:text-5xl lg:text-8xl font-bold text-white mb-6 textShine">
                    {{ __($page[1]->body) }} {{ __($page[0]->body) }}
                </h1>
                <p class="max-w-lg mx-auto text-xl text-gray-300 mb-10">
                    {{ __($page[2]->body) }}
                </p>
                <a class="group relative flex xs:inline-flex items-center justify-center px-16 px-4 h-12 font-bold text-gray-900 bg-yellowGreen-600 rounded-lg transition-all duration-300"
                    href="{{ url($page[4]->body) }}">
                    <div
                        class="absolute top-0 left-0 w-full h-full rounded-lg ring ring-yellowGreen-900 animate-pulse group-hover:ring-0 transition duration-300">
                    </div>
                    <span class="text-lg mr-3">{{ __($page[3]->body) }}</span>
                    <span class="transform group-hover:translate-x-1 transition duration-300">
                        <svg width="7" height="12" viewbox="0 0 7 12" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 1L6 6L1 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                stroke-linejoin="round"></path>
                        </svg>
                    </span>
                </a>
            </div>
        </div>
        @else
        @include('website.modern.includes.optimer')
        @endif
    </div>
</div>