@extends('layouts.classic')

@section('content')

{{-- Custom JS --}}
@section('custom-css')
{{-- AdSense status --}}
@if ($setting->adsense_code != "DISABLE")
{{-- AdSense code --}}
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client={{ $setting->adsense_code }}"
    crossorigin="anonymous"></script>
@endif
@endsection

{{-- Topbar --}}
@include('website.classic.includes.topbar')

@php
use App\Models\Page;
$page = Page::where('slug', 'pricing')->where('status', 1)->get();

// Byte conversion
function formatBytes($size, $precision = 2)
{
$base = log($size, 1024);
$suffixes = array('', 'kB', 'MB', 'GB', 'TB');

return round(pow(1024, $base - floor($base)), $precision) .''. $suffixes[floor($base)];
}
@endphp

{{-- Pricing --}}
<section class="py-20 xl:py-24 bg-white"
    style="background-image: url('{{ asset('images/web/elements/pattern-white.svg') }}'); background-position: center;">
    <div class="container px-4 mx-auto">
        <div class="text-center" data-aos="fade-up">
            <span
                class="inline-block py-px px-2 mb-4 text-xs leading-5 text-{{ $config[11]->config_value }}-500 bg-{{ $config[11]->config_value }}-100 font-medium uppercase rounded-9xl">{{ __($page[0]->body) }}</span>
            <h3 class="mb-4 text-3xl md:text-5xl text-gray-900 font-bold tracking-tighter">{{ __($page[1]->body) }}</h3>
            <p class="mb-12 text-lg md:text-xl text-gray-500 font-medium">{{ __($page[2]->body) }}</p>
        </div>
        <div class="flex flex-wrap justify-center -mx-4">
            {{-- all plans --}}
            @foreach ($plans as $plan)
            <div class="w-full md:w-1/2 lg:w-1/3 p-4" data-aos="fade-up" data-aos-delay="100">
                <div
                    class="flex flex-col pt-8 pb-8 bg-gray-50 rounded-md shadow-md hover:scale-105 transition duration-500">
                    <div class="px-8 pb-8">
                        <h3 class="mb-6 text-lg md:text-xl text-gray-800 font-medium">{{ __($plan->name) }}</h3>
                        <div class="mb-6">
                            {{-- Price --}}
                            @if ($plan->price == 0)
                                <span class="text-6xl md:text-7xl font-semibold {{ $plan->recommended == 1 ? 'text-white' : '' }}">{{ __('Free') }}</span>
                            @endif

                            @if ($plan->price != 0)
                                <span class="relative -top-10 right-1 text-3xl text-gray-900 font-bold">{{ $currency->symbol }}</span>
                                <span class="text-6xl md:text-7xl text-gray-900 font-semibold">{{ $plan->price }}</span>
                            @endif
                            <span class="inline-block ml-1 text-gray-500 font-semibold">
                            @if ($plan->price != 0 && $plan->validity == 9999)
                                {{ __('Forever') }}</span>
                            @endif
                            @if ($plan->validity == 31)
                            {{ __('Per Month') }}</span>
                            @endif 
                            @if ($plan->validity == 366)
                            {{ __('Per Year') }}</span>
                            @endif
                            @if ($plan->validity > 1 && $plan->validity != 31 && $plan->validity != 366 &&
                            $plan->validity != 9999)
                            {{ 'Per'.' '.$plan->validity.' '.__('Days') }}</span>
                            @endif
                            </span>
                        </div>
                        <p class="mb-6 text-gray-400 font-medium">{{ __($plan->description) }}</p>
                        <a class="inline-block mb-3 lg:mb-0 lg:mr-3 w-full lg:full py-2 px-6 leading-loose bg-{{ $config[11]->config_value }}-600 hover:bg-{{ $config[11]->config_value }}-700 text-white font-semibold rounded-l-xl rounded-t-xl transition duration-200 text-center"
                            href="{{ route('register') }}">{{ __('Get Started') }}</a>
                    </div>
                    <div class="border-b border-gray-100"></div>
                    <ul class="self-start px-8 pt-8">
                        {{-- Formats --}}
                        <li class="flex items-center mb-3 text-gray-500 font-medium">
                            <img class="mr-3" src="{{ asset('images/web/elements/checkbox-green.svg') }}">
                            <span>{{ $plan->formats == 9999 ? __('Unlimited') : $plan->formats }} {{ __('Formats') }}</span>
                        </li>

                        {{-- Optimize Images --}}
                        <li class="flex items-center mb-3 text-gray-500 font-medium">
                            <img class="mr-3" src="{{ asset('images/web/elements/checkbox-green.svg') }}">
                            <span>{{ $plan->maximum == 9999 ? __('Unlimited') : $plan->maximum }} {{ __('Optimize Images') }}</span>
                        </li>

                        {{-- Maximum Upload Size --}}
                        <li class="flex items-center mb-3 text-gray-500 font-medium">
                            <img class="mr-3" src="{{ asset('images/web/elements/checkbox-green.svg') }}">
                            <span>{{ formatBytes($plan->size) }} {{ __('Upload Limit')
                                }}</span>
                        </li>

                        {{-- Storage --}}
                        <li class="flex items-center mb-3 text-gray-500 font-medium">
                            <img class="mr-3" src="{{ asset('images/web/elements/checkbox-green.svg') }}">
                            <span>{{ formatBytes($plan->storage) }} {{ __('Storage')
                                }}</span>
                        </li>

                        {{-- Cloud Storage (S3) --}}
                        <li class="flex items-center mb-3 text-gray-500 font-medium">
                            @if ($plan->s3 == 1)
                            <img class="mr-3" src="{{ asset('images/web/elements/checkbox-green.svg') }}">
                            @else
                            <img class="mr-3" src="{{ asset('images/web/elements/icons8-cancel-1.svg') }}">
                            @endif
                            <span>{{ __('Cloud Storage (S3)') }}</span>
                        </li>

                        {{-- Daily Usage Statistics --}}
                        <li class="flex items-center mb-3 text-gray-500 font-medium">
                            @if ($plan->statistics == 1)
                            <img class="mr-3" src="{{ asset('images/web/elements/checkbox-green.svg') }}">
                            @else
                            <img class="mr-3" src="{{ asset('images/web/elements/icons8-cancel-1.svg') }}">
                            @endif
                            <span>{{ __('Daily Usage Statistics') }}</span>
                        </li>

                        {{-- Media Library --}}
                        <li class="flex items-center mb-3 text-gray-500 font-medium">
                            @if ($plan->media_library == 1)
                            <img class="mr-3" src="{{ asset('images/web/elements/checkbox-green.svg') }}">
                            @else
                            <img class="mr-3" src="{{ asset('images/web/elements/icons8-cancel-1.svg') }}">
                            @endif
                            <span>{{ __('Media Library') }}</span>
                        </li>

                        {{-- Conversation APIs --}}
                        <li class="flex items-center mb-3 text-gray-500 font-medium">
                            @if ($plan->api == 1)
                            <img class="mr-3" src="{{ asset('images/web/elements/checkbox-green.svg') }}">
                            @else
                            <img class="mr-3" src="{{ asset('images/web/elements/icons8-cancel-1.svg') }}">
                            @endif
                            <span>{{ __('Conversation APIs') }}</span>
                        </li>

                        {{-- APIs Request --}}
                        <li class="flex items-center mb-3 text-gray-500 font-medium">
                            @if ($plan->limit != 0)
                            <img class="mr-3" src="{{ asset('images/web/elements/checkbox-green.svg') }}">
                            @else
                            <img class="mr-3" src="{{ asset('images/web/elements/icons8-cancel-1.svg') }}">
                            @endif
                            <span>{{ $plan->limit != 0 ? $plan->limit : '' }} {{ __('APIs Request')
                                }}</span>
                        </li>

                        {{-- Additional Tools --}}
                        <li class="flex items-center mb-3 text-gray-500 font-medium">
                            @if ($plan->additional_tools == 1)
                            <img class="mr-3" src="{{ asset('images/web/elements/checkbox-green.svg') }}">
                            @else
                            <img class="mr-3" src="{{ asset('images/web/elements/icons8-cancel-1.svg') }}">
                            @endif
                            <span>{{ __('Additional Tools') }}</span>
                        </li>

                        {{-- Support --}}
                        <li class="flex items-center mb-3 text-gray-500 font-medium">
                            @if ($plan->support == 1)
                            <img class="mr-3" src="{{ asset('images/web/elements/checkbox-green.svg') }}">
                            @else
                            <img class="mr-3" src="{{ asset('images/web/elements/icons8-cancel-1.svg') }}">
                            @endif
                            <span>{{ __('Support (Email)') }}</span>
                        </li>
                    </ul>
                </div>
            </div>
            @endforeach

        </div>
    </div>
</section>

{{-- Footer --}}
@include('website.classic.includes.footer')
@endsection