@extends('layouts.classic')

@section('content')

{{-- Custom JS --}}
@section('custom-css')
{{-- AdSense status --}}
@if ($setting->adsense_code != "DISABLE")
{{-- AdSense code --}}
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client={{ $setting->adsense_code }}"
    crossorigin="anonymous"></script>
@endif
@endsection

{{-- Topbar --}}
@include('website.classic.includes.topbar')

@php
use App\Models\Page;
$page = Page::where('slug', 'home')->where('status', 1)->get();
@endphp

{{-- Features --}}
<section id="features">
    <div class="skew skew-top mr-for-radius">
        <svg class="h-8 md:h-12 lg:h-20 w-full text-gray-50" viewbox="0 0 10 10" preserveaspectratio="none">
            <polygon fill="currentColor" points="0 0 10 10 0 10"></polygon>
        </svg>
    </div>
    <div class="skew skew-top ml-for-radius">
        <svg class="h-8 md:h-12 lg:h-20 w-full text-gray-50" viewbox="0 0 10 10" preserveaspectratio="none">
            <polygon fill="currentColor" points="0 10 10 0 10 10"></polygon>
        </svg>
    </div>
    <div class="py-20 bg-gray-50 radius-for-skewed">
        <div class="container mx-auto px-4">
            <div class="mb-16 max-w-md mx-auto text-center" data-aos="fade-up">
                <span class="text-{{ $config[11]->config_value }}-600 font-bold">{{ __($page[19]->body) }}</span>
                <h2 class="text-4xl lg:text-5xl font-bold font-heading">{{ __($page[20]->body) }}</h2>
            </div>
            <div class="flex flex-wrap -mx-4" data-aos="fade-up" data-aos-delay="100">
                <div class="mb-8 lg:mb-0 w-full lg:w-1/3 px-4">
                    <div class="py-12 px-6 bg-white rounded shadow text-center">
                        <span class="mb-6 inline-block p-2 rounded-lg bg-{{ $config[11]->config_value }}-100">
                            <svg class="w-10 h-10 text-{{ $config[11]->config_value }}-500"
                                xmlns="http://www.w3.org/2000/svg" viewbox="0 0 20 20" fill="currentColor">
                                <path
                                    d="M3 1a1 1 0 000 2h1.22l.305 1.222a.997.997 0 00.01.042l1.358 5.43-.893.892C3.74 11.846 4.632 14 6.414 14H15a1 1 0 000-2H6.414l1-1H14a1 1 0 00.894-.553l3-6A1 1 0 0017 3H6.28l-.31-1.243A1 1 0 005 1H3zM16 16.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0zM6.5 18a1.5 1.5 0 100-3 1.5 1.5 0 000 3z">
                                </path>
                            </svg>
                        </span>
                        <h3 class="px-8 mb-4 text-2xl font-bold font-heading">{{ __($page[21]->body) }}
                        </h3>
                        <p class="text-gray-500">{{ __($page[22]->body) }}</p>
                    </div>
                </div>
                <div class="w-full lg:w-1/3 px-4">
                    <div class="py-12 px-6 bg-white rounded shadow text-center">
                        <span class="mb-6 inline-block p-2 rounded bg-{{ $config[11]->config_value }}-100">
                            <svg class="w-10 h-10 text-{{ $config[11]->config_value }}-500"
                                xmlns="http://www.w3.org/2000/svg" fill="none" viewbox="0 0 24 24"
                                stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M16 4v12l-4-2-4 2V4M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                </path>
                            </svg>
                        </span>
                        <h3 class="px-8 mb-4 text-2xl font-bold font-heading">{{ __($page[23]->body) }}
                        </h3>
                        <p class="text-gray-500">{{ __($page[24]->body) }}</p>
                    </div>
                </div>
                <div class="mb-8 lg:mb-0 w-full lg:w-1/3 px-4">
                    <div class="py-12 px-6 bg-white rounded shadow text-center">
                        <span class="mb-6 inline-block p-2 rounded-lg bg-{{ $config[11]->config_value }}-100">
                            <svg class="w-10 h-10 text-{{ $config[11]->config_value }}-500"
                                xmlns="http://www.w3.org/2000/svg" fill="none" viewbox="0 0 24 24"
                                stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                </path>
                            </svg>
                        </span>
                        <h3 class="px-8 mb-4 text-2xl font-bold font-heading">{{ __($page[25]->body) }}
                        </h3>
                        <p class="text-gray-500">{{ __($page[26]->body) }}</p>
                    </div>
                </div>
            </div>

            <div class="flex flex-wrap -mx-4 mt-4" data-aos="fade-up" data-aos-delay="200">
                <div class="mb-8 lg:mb-0 w-full lg:w-1/3 px-4">
                    <div class="py-12 px-6 bg-white rounded shadow text-center">
                        <span class="mb-6 inline-block p-2 rounded-lg bg-{{ $config[11]->config_value }}-100">
                            <svg class="w-10 h-10 text-{{ $config[11]->config_value }}-500"
                                xmlns="http://www.w3.org/2000/svg" viewbox="0 0 20 20" fill="currentColor">
                                <path
                                    d="M3 1a1 1 0 000 2h1.22l.305 1.222a.997.997 0 00.01.042l1.358 5.43-.893.892C3.74 11.846 4.632 14 6.414 14H15a1 1 0 000-2H6.414l1-1H14a1 1 0 00.894-.553l3-6A1 1 0 0017 3H6.28l-.31-1.243A1 1 0 005 1H3zM16 16.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0zM6.5 18a1.5 1.5 0 100-3 1.5 1.5 0 000 3z">
                                </path>
                            </svg>
                        </span>
                        <h3 class="px-8 mb-4 text-2xl font-bold font-heading">{{ __($page[27]->body) }}
                        </h3>
                        <p class="text-gray-500">{{ __($page[28]->body) }}</p>
                    </div>
                </div>
                <div class="w-full lg:w-1/3 px-4">
                    <div class="py-12 px-6 bg-white rounded shadow text-center">
                        <span class="mb-6 inline-block p-2 rounded bg-{{ $config[11]->config_value }}-100">
                            <svg class="w-10 h-10 text-{{ $config[11]->config_value }}-500"
                                xmlns="http://www.w3.org/2000/svg" fill="none" viewbox="0 0 24 24"
                                stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M16 4v12l-4-2-4 2V4M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                </path>
                            </svg>
                        </span>
                        <h3 class="px-8 mb-4 text-2xl font-bold font-heading">{{ __($page[29]->body) }}
                        </h3>
                        <p class="text-gray-500">{{ __($page[30]->body) }}</p>
                    </div>
                </div>
                <div class="mb-8 lg:mb-0 w-full lg:w-1/3 px-4">
                    <div class="py-12 px-6 bg-white rounded shadow text-center">
                        <span class="mb-6 inline-block p-2 rounded-lg bg-{{ $config[11]->config_value }}-100">
                            <svg class="w-10 h-10 text-{{ $config[11]->config_value }}-500"
                                xmlns="http://www.w3.org/2000/svg" fill="none" viewbox="0 0 24 24"
                                stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                </path>
                            </svg>
                        </span>
                        <h3 class="px-8 mb-4 text-2xl font-bold font-heading">{{ __($page[31]->body) }}
                        </h3>
                        <p class="text-gray-500">{{ __($page[32]->body)
                            }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="skew skew-bottom mr-for-radius">
        <svg class="h-8 md:h-12 lg:h-20 w-full text-gray-50" viewbox="0 0 10 10" preserveaspectratio="none">
            <polygon fill="currentColor" points="0 0 10 0 0 10"></polygon>
        </svg>
    </div>
    <div class="skew skew-bottom ml-for-radius">
        <svg class="h-8 md:h-12 lg:h-20 w-full text-gray-50" viewbox="0 0 10 10" preserveaspectratio="none">
            <polygon fill="currentColor" points="0 0 10 0 10 10"></polygon>
        </svg>
    </div>
</section>

<section class="py-20 bg-gray-50" data-aos="fade-up" data-aos-delay="300">
    <div class="container mx-auto px-4">
        <div class="flex flex-wrap items-center justify-center">
            <div class="w-auto mb-10 lg:mb-0 lg:mr-8 py-8 px-2 rounded">
                <img class="h-16" src="{{ asset($setting->site_logo) }}" alt="">
            </div>
            <div class="w-full lg:w-auto mb-10 lg:mb-0 text-center lg:text-left">
                <h2 class="max-w-xl mx-auto lg:mx-0 mb-2 text-4xl lg:text-5xl font-bold font-heading">{{
                    __($page[33]->body) }}</h2>
                <p class="max-w-xl mx-auto lg:mx-0 text-gray-500 leading-loose">{{ __($page[34]->body)
                    }}</p>
            </div>
            <div class="w-full lg:w-auto lg:ml-auto text-center"><a
                    class="inline-block py-2 px-6 mx-24 bg-{{ $config[11]->config_value }}-600 hover:bg-{{ $config[11]->config_value }}-700 text-white font-bold leading-loose rounded-l-xl rounded-t-xl transition duration-200"
                    href="{{ url($page[36]->body) }}">{{ __($page[35]->body) }}</a></div>
        </div>
    </div>
</section>

{{-- Footer --}} 
@include('website.classic.includes.footer')
@endsection