@php
// Settings
use App\Models\Config;
use App\Models\Page;

$config = Config::get();
$page = Page::where('slug', 'home')->where('status', 1)->get();
@endphp

<style>
    td {
        max-width: 70px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
</style>

<div class="w-full">
    <div class="flex flex-wrap -mx-4">
        <form action="{{ route('optimize.image') }}" class="shadow-lg dropzone" id="dropzone"
            data-aos="fade-up" dz-max-files-reached="{{ $config[35]->config_value }}"
            enctype="multipart/form-data">
            @csrf
            <div class="dz-message font-bold dropzone-width">
                {{ __($page[7]->body) }} <span class="text-{{ $config[11]->config_value }}-600">{{
                    __($page[8]->body) }}</span> {{
                __($page[9]->body) }} <br> <span
                    class="text-{{ $config[11]->config_value }}-600 mb-4">{{
                    __($page[11]->body) }} {{ $config[35]->config_value}} {{ __($page[10]->body) }}, {{
                    $config[36]->config_value }} {{ __($page[12]->body) }}</span> <br><br>
                    <span class="px-2 my-4">{{ __('OR') }}</span><br><br>
                <a
                    class="cursor-pointer px-8 py-3 bg-{{ $config[11]->config_value }}-600 hover:bg-{{ $config[11]->config_value }}-700 text-white font-bold leading-loose rounded-l-xl rounded-t-xl transition duration-200">{{
                    __('Choose an files') }}</a>
            </div>
        </form>
    </div>

    <div class="flex flex-wrap -mx-2 optimizeDownload hidden">
        <div class="mx-auto w-full lg:w-2/3 xl:w-1/2">
            <div class="mb-8 rounded-lg mt-12 overflow-x-auto aos-init aos-animate mx-8" data-aos="fade-up">
                <div class="flex justify-between mb-4">
                    <div></div>
                    <button class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded" id="downloadAll">
                        {{ __('Download All') }}
                    </button>
                </div>
                <table id="optimizeData" class="w-full">
                    <thead>
                        <tr class="text-md font-semibold tracking-wide text-left text-gray-900 bg-gray-100 uppercase border-b border-gray-600">
                            <th class="px-4 py-3">
                                {{ __('File') }}
                            </th>
                            <th class="px-4 py-3 hidden md:table-cell">
                                {{ __('Original') }}
                            </th>
                            <th class="px-4 py-3 hidden md:table-cell">
                                {{ __('Optimized') }}
                            </th>
                            <th class="px-4 py-3">
                                {{ __('Saved') }}
                            </th>
                            <th class="px-4 py-3">
                                {{ __('Download') }}
                            </th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
            
            <div class="-m-2 text-center errorStatus hidden aos-init aos-animate" data-aos="fade-up">
                <div class="p-2 mt-4">
                    <div class="inline-flex items-center bg-white leading-none text-red-600 rounded-full p-2 shadow text-teal text-sm">
                        <span class="inline-flex bg-red-600 text-white rounded-full h-6 px-3 justify-center items-center"><strong>{{ __('Sorry') }}</strong>,</span>
                        <span class="inline-flex px-2"><strong>{{ __('You are reached maximum optimized count. So, Please try tomorrow.') }}</strong></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Custom JS --}}
@section('custom-js')
<script src="{{ asset('js/dropzone.min.js')}}"></script>
<script src="{{ asset('js/jszip.min.js') }}"></script>
<script type="text/javascript">
    "use strict";
    $('#success').hide();
    $('#failed').hide();
    Dropzone.autoDiscover = false;

   $(document).ready(function () {
        $("#dropzone").dropzone({
            maxFilesize: {{ $config[36]->config_value }},
            maxFiles: {{ $config[35]->config_value }},
            acceptedFiles: `{{ $acceptedFiles }}`,
            url: `{{ route('optimize.image') }}`,
            autoProcessQueue: true,
            addRemoveLinks: true,
            timeout: 180000,
            success: function (file, response) {
            if(response.status == true) { 
                    $('.errorStatus').hide();
                    $('#success').show();
                    $('.optimizeDownload').removeClass('hidden');
                    $('table[id="optimizeData"]').append(`<tr>
                        <td class="px-4 py-3 border">
                            `+response.file_name+`
                        </td>
                        <td class="px-4 py-3 border hidden md:table-cell">
                            <p class="text-gray-900 whitespace-no-wrap">`+formatBytes(response.size)+`</p>
                        </td>
                        <td class="px-4 py-3 border hidden md:table-cell">
                            <p class="text-gray-900 whitespace-no-wrap">`+formatBytes(response.optimizeSize)+`</p>
                        </td>
                        <td class="px-4 py-3 border">
                            <p class="text-gray-900 whitespace-no-wrap">`+formatBytes(Math.round(response.savedYou))+`</p>
                        </td>
                        <td class="px-4 py-3 border">
                            <a class="inline-block py-1 px-2 bg-{{ $config[11]->config_value }}-600 hover:bg-{{ $config[11]->config_value }}-700 text-white font-bold leading-loose rounded-l-xl rounded-t-xl transition duration-200" id="download-`+Math.round(response.size)+`">{{ __('Download') }}</a>
                        </td>
                    </tr>`);

                    // Save image URL to local storage
                    saveImageURL(response.url, Math.round(response.size));
                } else {
                    $('.errorStatus').show();
                };
            },
        });
   });

   // Save image URL to local storage
   function saveImageURL(url, id) {
        // Get existing URLs from local storage
        let existingURLs = JSON.parse(localStorage.getItem("storedImageURLs")) || [];
        
        // Add the new URL to the list
        existingURLs.push(url);

        // Save the updated list back to local storage
        localStorage.setItem("storedImageURLs", JSON.stringify(existingURLs));

        // Generate a random name for the file
        const randomName = generateRandomName();

        // Set href value
        var downloadLink = document.getElementById("download-"+id);
        downloadLink.getAttribute("href");
        downloadLink.setAttribute("href", url);
        downloadLink.setAttribute("download", randomName);
    }

    // Delete local storage items on page refresh
    window.addEventListener("beforeunload", function() {
        localStorage.removeItem("storedImageURLs");
    });

    // Download all in ZIP format
    document.getElementById("downloadAll").addEventListener("click", function() {
        // Get image URLs from local storage
        let imageURLs = JSON.parse(localStorage.getItem("storedImageURLs")) || [];

        if (imageURLs.length === 0) {
            alert("No images to download.");
            return;
        }

        // Create a new instance of JSZip
        let zip = new JSZip();
        let appName = `{{ config('app.name') }}`;
        appName.replace(' ', '-');

        // Download each image and add it to the zip file
        let promises = imageURLs.map(function(url, index) {
            return fetch(url)
                .then(response => response.blob())
                .then(blob => zip.file(appName+`-${index + 1}.png`, blob));
        });

        // After all images are added, create and download the zip file
        Promise.all(promises).then(function() {
            zip.generateAsync({ type: "blob" })
                .then(function(content) {
                    // Trigger the download
                    const a = document.createElement("a");
                    const url = URL.createObjectURL(content);
                    a.href = url;
                    a.download = appName+".zip";
                    document.body.appendChild(a);
                    a.click();
                    document.body.removeChild(a);
                    URL.revokeObjectURL(url);
                });
        });
    });

    function formatBytes(bytes, decimals = 2) {
        if (!+bytes) return '0kB'

        const k = 1024
        const dm = decimals < 0 ? 0 : decimals
        const sizes = ['Bytes', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB']

        const i = Math.floor(Math.log(bytes) / Math.log(k))

        return `${parseFloat((bytes / Math.pow(k, i)).toFixed(dm))}${sizes[i]}`
    }

    // Function to generate a random name for the file
    function generateRandomName() {
        const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        const length = 10; // Adjust the length of the random name as needed
        let randomName = '';

        for (let i = 0; i < length; i++) {
            const randomIndex = Math.floor(Math.random() * characters.length);
            randomName += characters.charAt(randomIndex);
        }

        return randomName;
    }
</script>
@endsection