@php
// Settings
use App\Models\Setting;
use App\Models\Page;
use App\Models\Blog;

$setting = Setting::where('status', 1)->first();
$contactPage = Page::where('slug', 'contact')->get();
$blogs = Blog::where('status', 1)->count();

$pages = Page::get();
@endphp

<section>
    <div class="skew skew-top mr-for-radius">
        <svg class="h-8 md:h-12 lg:h-20 w-full text-gray-50" viewbox="0 0 10 10" preserveaspectratio="none">
            <polygon fill="currentColor" points="0 0 10 10 0 10"></polygon>
        </svg>
    </div>
    <div class="skew skew-top ml-for-radius">
        <svg class="h-8 md:h-12 lg:h-20 w-full text-gray-50" viewbox="0 0 10 10" preserveaspectratio="none">
            <polygon fill="currentColor" points="0 10 10 0 10 10"></polygon>
        </svg>
    </div>
    <div class="py-20 px-5 bg-gray-50 radius-for-skewed">
        <div class="container mx-auto">
            <div class="pb-12 flex flex-wrap items-center justify-between border-b border-gray-100">
                <div class="w-full lg:w-1/5 mb-12 lg:mb-4">
                    <a class="inline-block text-3xl font-bold leading-none" href="{{ url('/') }}">
                        <img class="h-12" src="{{ asset($setting->site_logo) }}" alt="{{ config('app.name') }}"
                            width="auto">
                    </a>
                </div>
                <div class="w-full lg:w-auto">
                    <ul class="flex flex-wrap lg:space-x-1 items-center">
                        @if($pages[41]->slug == 'about' && $pages[41]->status == 1)
                        <li class="w-full md:w-auto mb-2 md:mb-0"><a
                                class="lg:text-sm text-gray-900 hover:text-gray-500 {{ request()->is('about') ? 'font-bold' : '' }}"
                                href="{{ route('web.about') }}">{{ __('About Us') }}</a></li>
                        <li class="hidden md:block">
                            <svg class="mx-4 w-4 h-4 text-gray-300" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewbox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 5v.01M12 12v.01M12 19v.01M12 6a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2z">
                                </path>
                            </svg>
                        </li>
                        @endif

                        @if($pages[56]->slug == 'contact' && $pages[56]->status == 1)
                        <li class="w-full md:w-auto mb-2 md:mb-0"><a
                                class="lg:text-sm text-gray-900 hover:text-gray-500 {{ request()->is('contact') ? 'font-bold' : '' }}"
                                href="{{ route('web.contact') }}">{{ __('Help') }}</a></li>
                        <li class="hidden md:block">
                            <svg class="mx-4 w-4 h-4 text-gray-300" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewbox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 5v.01M12 12v.01M12 19v.01M12 6a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2z">
                                </path>
                            </svg>
                        </li>
                        @endif

                        @if($pages[71]->slug == 'faq' && $pages[71]->status == 1)
                        <li class="w-full md:w-auto mb-2 md:mb-0"><a
                                class="lg:text-sm text-gray-900 hover:text-gray-500 {{ request()->is('faq') ? 'font-bold' : '' }}"
                                href="{{ route('web.faq') }}">{{
                                __('FAQs') }}</a></li>
                        <li class="hidden md:block">
                            <svg class="mx-4 w-4 h-4 text-gray-300" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewbox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 5v.01M12 12v.01M12 19v.01M12 6a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2z">
                                </path>
                            </svg>
                        </li>
                        @endif

                        @if($pages[90]->slug == 'privacy-policy' && $pages[90]->status == 1)
                        <li class="w-full md:w-auto mb-2 md:mb-0"><a
                                class="lg:text-sm text-gray-900 hover:text-gray-500 {{ request()->is('privacy-policy') ? 'font-bold' : '' }}"
                                href="{{ route('web.privacy') }}">{{
                                __('Privacy Policy') }}</a></li>
                        <li class="hidden md:block">
                            <svg class="mx-4 w-4 h-4 text-gray-300" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewbox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 5v.01M12 12v.01M12 19v.01M12 6a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2z">
                                </path>
                            </svg>
                        </li>
                        @endif

                        @if($pages[103]->slug == 'refund-policy' && $pages[103]->status == 1)
                        <li class="w-full md:w-auto mb-2 md:mb-0"><a
                                class="lg:text-sm text-gray-900 hover:text-gray-500 {{ request()->is('refund-policy') ? 'font-bold' : '' }}"
                                href="{{ route('web.refund') }}">{{
                                __('Refund Policy') }}</a></li>
                        <li class="hidden md:block">
                            <svg class="mx-4 w-4 h-4 text-gray-300" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewbox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 5v.01M12 12v.01M12 19v.01M12 6a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2z">
                                </path>
                            </svg>
                        </li>
                        @endif

                        @if($pages[116]->slug == 'terms-and-conditions' && $pages[116]->status == 1)
                        <li class="w-full md:w-auto mb-2 md:mb-0"><a
                                class="lg:text-sm text-gray-900 hover:text-gray-500 {{ request()->is('terms-and-conditions') ? 'font-bold' : '' }}"
                                href="{{ route('web.terms') }}">{{
                                __('Terms and Conditions') }}</a></li>
                        @endif
                    </ul>
                </div>
            </div>
            <div class="mt-8 flex flex-wrap justify-between items-center">
                <p class="order-last text-sm text-gray-900">© {{ date("Y") }} {{ __(config('app.name')) }}. {{ __('All rights reserved.') }}</p>
                <div class="mb-4 lg:mb-0 order-first lg:order-last">
                    <a class="inline-block mr-2 p-2 bg-gray-50 hover:bg-gray-100 rounded"  href="{{ $contactPage[13]->body }}" target="_blank" rel="noreferrer">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-brand-facebook"
                            width="24" height="24" viewbox="0 0 24 24" stroke-width="2" stroke="currentColor"
                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M7 10v4h3v7h4v-7h3l1 -4h-4v-2a1 1 0 0 1 1 -1h3v-4h-3a5 5 0 0 0 -5 5v2h-3"></path>
                        </svg>
                    </a>
                    <a class="inline-block mr-2 p-2 bg-gray-50 hover:bg-gray-100 rounded"  href="{{ $contactPage[14]->body }}" target="_blank" rel="noreferrer">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-brand-twitter"
                            width="24" height="24" viewbox="0 0 24 24" stroke-width="2" stroke="currentColor"
                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path
                                d="M22 4.01c-1 .49 -1.98 .689 -3 .99c-1.121 -1.265 -2.783 -1.335 -4.38 -.737s-2.643 2.06 -2.62 3.737v1c-3.245 .083 -6.135 -1.395 -8 -4c0 0 -4.182 7.433 4 11c-1.872 1.247 -3.739 2.088 -6 2c3.308 1.803 6.913 2.423 10.034 1.517c3.58 -1.04 6.522 -3.723 7.651 -7.742a13.84 13.84 0 0 0 .497 -3.753c-.002 -.249 1.51 -2.772 1.818 -4.013z">
                            </path>
                        </svg>
                    </a>
                    <a class="inline-block mr-2 p-2 bg-gray-50 hover:bg-gray-100 rounded"  href="{{ $contactPage[15]->body }}" target="_blank" rel="noreferrer">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-brand-instagram"
                            width="24" height="24" viewbox="0 0 24 24" stroke-width="2" stroke="currentColor"
                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <rect x="4" y="4" width="16" height="16" rx="4"></rect>
                            <circle cx="12" cy="12" r="3"></circle>
                            <line x1="16.5" y1="7.5" x2="16.5" y2="7.501"></line>
                        </svg>
                    </a>
                    <a class="inline-block mr-2 p-2 bg-gray-50 hover:bg-gray-100 rounded" href="{{ $contactPage[16]->body }}" target="_blank" rel="noreferrer">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-brand-linkedin" 
                            width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" 
                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z"></path>
                                <path d="M8 11l0 5"></path>
                                <path d="M8 8l0 .01"></path>
                                <path d="M12 16l0 -5"></path>
                            <path d="M16 16v-3a2 2 0 0 0 -4 0"></path>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="skew skew-bottom mr-for-radius">
        <svg class="h-8 md:h-12 lg:h-20 w-full text-gray-50" viewbox="0 0 10 10" preserveaspectratio="none">
            <polygon fill="currentColor" points="0 0 10 0 0 10"></polygon>
        </svg>
    </div>
    <div class="skew skew-bottom ml-for-radius">
        <svg class="h-8 md:h-12 lg:h-20 w-full text-gray-50" viewbox="0 0 10 10" preserveaspectratio="none">
            <polygon fill="currentColor" points="0 0 10 0 10 10"></polygon>
        </svg>
    </div>
</section>