@php
// Settings
use App\Models\Config;
use App\Models\Page;

$config = Config::get();
$page = Page::where('slug', 'home')->where('status', 1)->get();
@endphp

<div class="relative bg-gray-50 md:pt-10 pb-24 lg:py-20">
    <div class="mx-auto lg:px-20 px-6">
        <div class="{{ $config[34]->config_value == 1 ? "" : "flex flex-wrap -mx-4" }}">
            {{-- Check optimer is enabled --}}
            @if ($config[34]->config_value == 1)
            @include('website.classic.includes.optimer')
            @else
            <div class="w-full lg:w-1/2 px-4 flex items-center">
                <div class="w-full text-center lg:text-left">
                    <div class="relative max-w-md mx-auto lg:mx-0" data-aos="fade-up">
                        <h2 class="mb-3 text-4xl lg:text-5xl font-bold font-heading">
                            <span>{{ __($page[1]->body) }}</span><br>
                            <span class="text-{{ $config[11]->config_value }}-600">{{ __($page[0]->body) }}</span>
                        </h2>
                    </div>
                    <div class="relative max-w-md mx-auto lg:mx-0" data-aos="fade-up">
                        <p class="mb-6 text-gray-400 leading-loose">{{ __($page[2]->body) }}</p>
                        <div><a class="inline-block mb-3 lg:mb-0 lg:mr-3 w-full lg:w-auto py-2 px-6 leading-loose bg-{{ $config[11]->config_value }}-700 hover:bg-{{ $config[11]->config_value }}-600 text-white font-semibold rounded-l-xl rounded-t-xl transition duration-200"
                                href="{{ url($page[4]->body) }}">{{ __($page[3]->body) }}</a><a
                                class="inline-block w-full lg:w-auto py-2 px-6 mr-2 leading-loose font-semibold text-gray-50 bg-gray-700 hover:bg-gray-600 rounded-l-xl rounded-t-xl transition duration-200"
                                href="{{ $page[6]->body }}">{{ __($page[5]->body) }}</a></div>
                    </div>
                    @if ($requiredCreditCard == true)
                    <p class="my-1 text-gray-800 leading-loose text-xs" data-aos="fade-up">{{ __('Signup for free - No credit card required') }}</p>
                    @endif
                </div>
            </div>
            <div class="w-full lg:w-1/2">
                <div class="flex flex-wrap -mx-4">
                    <img class="lg:absolute top-0 my-12 lg:my-0 h-full w-full lg:w-1/2 rounded-3xl lg:rounded-none object-cover"
                        src="{{ asset($config[12]->config_value) }}" alt="{{ config('app.name') }}">
                </div>
            </div>
            @endif
        </div>
    </div>
</div>