@php
function generateNew($fill)
{
    $basicManifest = [
        'name' => $fill['name'],
        'short_name' => $fill['short_name'],
        'start_url' => $fill['start_url'],
        'background_color' => '#ffffff',
        'theme_color' => '#000000',
        'display' => 'standalone',
        'orientation' => "any",
        'status_bar' => "black",
        'splash' => $fill['splash']
    ];

    foreach ($fill['icons'] as $size => $file) {
        $fileInfo = pathinfo($file['path']);
        $basicManifest['icons'][] = [
            'src' => $file['path'],
            'type' => 'image/' . $fileInfo['extension'],
            'sizes' => $size,
            'purpose' => $file['purpose']
        ];
    }

    if ($fill['shortcuts']) {
        foreach ($fill['shortcuts'] as $shortcut) {

            if (array_key_exists("icons", $shortcut)) {
                $fileInfo = pathinfo($shortcut['icons']['src']);
                $icon = [
                    'src' => $shortcut['icons']['src'],
                    'type' => 'image/' . $fileInfo['extension'],
                    'purpose' => $shortcut['icons']['purpose']
                ];
            } else {
                $icon = [];
            }

            $basicManifest['shortcuts'][] = [
                'name' => trans($shortcut['name']),
                'description' => trans($shortcut['description']),
                'url' => $shortcut['url'],
                'icons' => [
                    $icon
                ]
            ];
        }
    }
    return $basicManifest;
}

use App\Models\Config;
use App\Models\Setting;
use App\Models\Page;

// Queries
$config = Config::get();
$setting = Setting::where('status', 1)->first();
$page = Page::where('slug', 'home')->where('status', 1)->get();

$icons = [
    '512x512' => [
        'path' => asset($setting->favicon),
        'purpose' => 'any'
    ]
];

$splash = [
    '640x1136' => asset($setting->favicon),
    '750x1334' => asset($setting->favicon),
    '828x1792' => asset($setting->favicon),
    '1125x2436' => asset($setting->favicon),
    '1242x2208' => asset($setting->favicon),
    '1242x2688' => asset($setting->favicon),
    '1536x2048' => asset($setting->favicon),
    '1668x2224' => asset($setting->favicon),
    '1668x2388' => asset($setting->favicon),
    '2048x2732' => asset($setting->favicon),
];

$shortcuts = [
    [
        'name' => $setting->site_name,
        'description' => $page[0]->description,
        'url' => "/",
        'icons' => [
            "src" => asset($setting->favicon),
            "purpose" => "any"
        ]
    ]
];

$fill = [
    "name" => $setting->site_name,
    "short_name" => $setting->site_name,
    "start_url" => "/",
    "icons" => $icons,
    "splash" => $splash,
    "shortcuts" => $shortcuts,
];

$out = generateNew($fill);

Storage::disk('public_uploads')->put('manifest.json', json_encode($out));
@endphp

<!-- Web Application Manifest -->
<link rel="manifest" href="{{ route('laravelpwa.manifest') }}">
<!-- Chrome for Android theme color -->
<meta name="theme-color" content="#ffffff">

<!-- Add to homescreen for Chrome on Android -->
<meta name="mobile-web-app-capable" content="yes">
<meta name="application-name" content="{{ $setting->site_name }}">
<link rel="icon" sizes="96x96" href="{{ asset($setting->favicon) }}">

<!-- Add to homescreen for Safari on iOS -->
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="{{ $config[11]->config_value }}">
<meta name="apple-mobile-web-app-title" content="{{ $setting->site_name }}">
<link rel="apple-touch-icon" href="{{ asset($setting->favicon) }}">


<link href="{{ asset($setting->favicon) }}" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2)" rel="apple-touch-startup-image" />
<link href="{{ asset($setting->favicon) }}" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2)" rel="apple-touch-startup-image" />
<link href="{{ asset($setting->favicon) }}" media="(device-width: 621px) and (device-height: 1104px) and (-webkit-device-pixel-ratio: 3)" rel="apple-touch-startup-image" />
<link href="{{ asset($setting->favicon) }}" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3)" rel="apple-touch-startup-image" />
<link href="{{ asset($setting->favicon) }}" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2)" rel="apple-touch-startup-image" />
<link href="{{ asset($setting->favicon) }}" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3)" rel="apple-touch-startup-image" />
<link href="{{ asset($setting->favicon) }}" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2)" rel="apple-touch-startup-image" />
<link href="{{ asset($setting->favicon) }}" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2)" rel="apple-touch-startup-image" />
<link href="{{ asset($setting->favicon) }}" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2)" rel="apple-touch-startup-image" />
<link href="{{ asset($setting->favicon) }}" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2)" rel="apple-touch-startup-image" />

<!-- Tile for Win8 -->
<meta name="msapplication-TileColor" content="{{ $config[11]->config_value }}">
<meta name="msapplication-TileImage" content="{{ asset($setting->favicon) }}">

<script type="text/javascript">
    // Initialize the service worker
    if ('serviceWorker' in navigator) {
        navigator.serviceWorker.register('/serviceworker.js', {
            scope: '.'
        }).then(function (registration) {
            // Registration was successful
            // console.log('Laravel PWA: ServiceWorker registration successful with scope: ', registration.scope);
        }, function (err) {
            // registration failed :(
            // console.log('Laravel PWA: ServiceWorker registration failed: ', err);
        });
    }
</script>