@extends('user.layouts.app')

{{-- Custom CSS & JS --}}
@section('custom-css')
    <link rel="stylesheet" href="{{ asset('css/lightgallery.min.css') }}" />
    <script src="{{ asset('js/lightgallery.min.js') }}"></script>
    <script src="{{ asset('js/clipboard.min.js') }}"></script>

    <style>
        .form-imagecheck {
            width: 100%;
        }

        .form-imagecheck-figure {
            box-shadow: none !important;
        }

        .word-break {
            display: block;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
    </style>
@endsection

@php
    // Byte conversion
    function formatBytes($size, $precision = 2)
    {
        $base = log($size, 1024);
        $suffixes = ['', 'kB', 'MB', 'GB', 'TB'];
        $result = round(pow(1024, $base - floor($base)), $precision) . '' . $suffixes[floor($base)];
        if ($result != 'NAN ') {
            return $result;
        } else {
            return $result = 0;
        }
    }
@endphp

@section('content')
    <div class="page-wrapper">
        <div class="container-fluid">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <div class="page-pretitle">
                            {{ __('Overview') }}
                        </div>
                        <h2 class="page-title">
                            {{ __('Media Library') }}
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">
                        <div class="btn-list">
                            <a href="#" class="btn btn-primary d-none" id="bulkDownload" data-bs-toggle="tooltip"
                                data-bs-placement="top" title="{{ __('Bulk Download') }}">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-file-zip"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                    fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M6 20.735a2 2 0 0 1 -1 -1.735v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-1" />
                                    <path d="M11 17a2 2 0 0 1 2 2v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a2 2 0 0 1 2 -2z" />
                                    <path d="M11 5l-1 0" />
                                    <path d="M13 7l-1 0" />
                                    <path d="M11 9l-1 0" />
                                    <path d="M13 11l-1 0" />
                                    <path d="M11 13l-1 0" />
                                    <path d="M13 15l-1 0" />
                                </svg>
                                <span class="d-none d-sm-inline-block">{{ __('Download') }}</span>
                            </a>
                            <a href="#" class="btn btn-primary d-none" id="bulkDelete" data-bs-toggle="tooltip"
                                data-bs-placement="top" title="{{ __('Bulk Delete') }}">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-trash"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                    fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M4 7l16 0" />
                                    <path d="M10 11l0 6" />
                                    <path d="M14 11l0 6" />
                                    <path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12" />
                                    <path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3" />
                                </svg>
                                <span class="d-none d-sm-inline-block">{{ __('Delete') }}</span>
                            </a>
                            <a href="{{ route('user.add.media') }}" class="btn btn-primary" data-bs-toggle="tooltip"
                                data-bs-placement="top" title="{{ __('Upload') }}">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-upload"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                    fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M4 17v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-2"></path>
                                    <polyline points="7 9 12 4 17 9"></polyline>
                                    <line x1="12" y1="4" x2="12" y2="16"></line>
                                </svg>
                                <span class="d-none d-sm-inline-block">{{ __('Upload') }}</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-body">
            <div class="container-fluid">

                {{-- Failed --}}
                @if (Session::has('failed'))
                    <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('failed') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                {{-- Success --}}
                @if (Session::has('success'))
                    <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('success') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                <div row class="row row-cards mb-3">
                    {{-- Storage Usage --}}
                    <div class="col-6 col-lg-6">
                        <div class="card bg-custom4">
                            <div class="card-body mb-3 text-custom">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="subheader">{{ __('Media(s)') }}</div>
                                </div>
                                <div class="h1">{{ count($media) }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-lg-6">
                        <div class="card bg-custom8">
                            <div class="card-body text-custom">
                                <div class="row">
                                    <div class="col-6 col-lg-6">
                                        <small class="mb-3">{{ __('Storage Usage') }}</small>
                                        <p class="mb-3 word-break">
                                            <strong>{{ $storageUsage != 0 ? formatBytes($storageUsage) : 0 }}
                                            </strong> {{ __('of') }}
                                            <strong>{{ $current_storage != 0 ? formatBytes($current_storage) : 0 }}</strong>
                                        </p>
                                    </div>
                                    <div class="col-6 col-lg-6">
                                        <h1 class="float-right">
                                            {{ number_format(((float) $storageUsage / $current_storage) * 100, 2, '.', '') }}%
                                        </h1>
                                    </div>
                                </div>
                                <div class="progress progress-separated mb-3">
                                    <div class="progress-bar bg-danger" role="progressbar"
                                        style="width: {{ number_format(((float) $storageUsage / $current_storage) * 100, 2, '.', '') }}%"
                                        aria-label="Regular"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row row-cards mt-3" id="captions">
                    {{-- Medias --}}
                    @if (!empty($media) && $media->count())
                        @foreach ($media as $gallery)
                            <div class="col-6 col-lg-2">
                                <div class="card card-sm">
                                    <div class="d-block">
                                        <div class="item card-img-top img-responsive img-responsive-16by9"
                                            data-src="{{ $gallery->media_url }}"
                                            data-sub-html="<h4>{{ __('Name') }} : {{ $gallery->media_name }}</h4>"
                                            style="background-image: url({{ asset($gallery->media_url) }})">
                                        </div>
                                    </div>

                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-lg-2 col-2">
                                                <input class="form-check-input" type="checkbox"
                                                    value="{{ $gallery->id }}" class="form-imagecheck-input"
                                                    onclick="bulkDelete(this), bulkDownload(this)">
                                            </div>
                                            <div class="col-lg-8 col-8">
                                                <div class="font-weight-bold mb-2 word-break">
                                                    {{ $gallery->media_name }}
                                                </div>
                                                <div class="small">
                                                    <small>{{ __('Uploaded on:') }}{{ formatDateForUser($gallery->created_at) }}</small>
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-2">
                                                <div class="card-actions">
                                                    <div class="dropdown">
                                                        <a href="#" class="btn-action dropdown-toggle"
                                                            data-bs-toggle="dropdown" aria-haspopup="true"
                                                            aria-expanded="false"><!-- Download SVG icon from http://tabler-icons.io/i/dots-vertical -->
                                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon"
                                                                width="24" height="24" viewBox="0 0 24 24"
                                                                stroke-width="2" stroke="currentColor" fill="none"
                                                                stroke-linecap="round" stroke-linejoin="round">
                                                                <path stroke="none" d="M0 0h24v24H0z" fill="none">
                                                                </path>
                                                                <path d="M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                                <path d="M12 19m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                                <path d="M12 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                            </svg>
                                                        </a>
                                                        <div class="dropdown-menu dropdown-menu-end" style="">
                                                            {{-- Optimize --}}
                                                            @if (substr($gallery->media_url, 0, 5) != 'https')
                                                                <a class="dropdown-item"
                                                                    href="{{ route('user.optimize.image', $gallery->id) }}"
                                                                    data-bs-toggle="tooltip" data-bs-placement="top"
                                                                    title="{{ __('Optimize') }}">
                                                                    {{ __('Optimize') }}
                                                                </a>
                                                            @else
                                                                <a class="dropdown-item" data-bs-toggle="tooltip"
                                                                    data-bs-placement="top"
                                                                    title="{{ __('You cannot optimize this image.') }}">
                                                                    {{ __('Optimize') }}
                                                                </a>
                                                            @endif
                                                            <a class="dropdown-item copyBoard" data-bs-toggle="tooltip"
                                                                data-bs-placement="top" title="{{ __('Copy') }}"
                                                                data-clipboard-text="{{ url($gallery->media_url) }}">
                                                                {{ __('Copy') }}
                                                            </a>
                                                            <a class="dropdown-item" data-bs-toggle="tooltip"
                                                                data-bs-placement="top" title="{{ __('Download') }}"
                                                                onclick="downloadImage('{{ $gallery->media_url }}', '{{ $gallery->media_name }}'); return false;">
                                                                {{ __('Download') }}
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div class="empty">
                            <div class="empty-img"><img src="{{ asset('images/undraw_printing_invoices_5r4r.svg') }}"
                                    width="300" height="128" alt="">
                            </div>
                            <p class="empty-title">{{ __('No media found') }}</p>
                            <p class="empty-subtitle">
                                {{ __('Try adjusting your add to find what you are looking for.') }}
                            </p>
                        </div>
                    @endif

                    <div class="col-lg-12">
                        {{-- Pagination --}}
                        {{ $media->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Footer --}}
    @include('user.includes.footer')
    </div>

    {{-- Delete modal --}}
    <div class="modal modal-blur fade" id="deleteModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title">{{ __('Are you sure?') }}</div>
                    <div>{{ __('If you proceed, you will permanent delete this media.') }}</div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary me-auto"
                        data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <a class="btn btn-danger" id="plan_id">{{ __('Yes, proceed') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- Bulk Delete Optimize Modal --}}
    <div class="modal modal-blur fade" id="bulk-delete-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title">{{ __('Are you sure?') }}</div>
                    <div id="bulk_delete_status"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary me-auto"
                        data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <a class="btn btn-danger" id="bulk_delete_optimer_id">{{ __('Yes, proceed') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- Bulk Download Optimize Modal --}}
    <div class="modal modal-blur fade" id="bulk-download-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title">{{ __('Are you sure?') }}</div>
                    <div id="bulk_download_status"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary me-auto"
                        data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <a class="btn btn-danger" id="bulk_download_optimer_id">{{ __('Yes, proceed') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- Download Optimize --}}
    <div class="modal modal-blur fade" id="download-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title">{{ __('Download Formats') }}</div>
                    <div class="row">
                        <div class="col-6 col-sm-4 col-md-2 col-xl-3 py-3">
                            <a class="btn btn-blue w-100" id="jpgImage">
                                {{ __('JPG') }}
                            </a>
                        </div>
                        <div class="col-6 col-sm-4 col-md-2 col-xl-3 py-3">
                            <a class="btn btn-blue w-100" id="pngImage">
                                {{ __('PNG') }}
                            </a>
                        </div>
                        <div class="col-6 col-sm-4 col-md-2 col-xl-3 py-3">
                            <a class="btn btn-blue w-100" id="gifImage">
                                {{ __('GIF') }}
                            </a>
                        </div>
                        <div class="col-6 col-sm-4 col-md-2 col-xl-3 py-3">
                            <a class="btn btn-blue w-100" id="webpImage">
                                {{ __('WEBP') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Custom JS --}}
@section('custom-js')
    <script>
        "use strict";
        $('#captions').lightGallery({
            thumbnail: true,
            download: false,
            selector: '.item'
        });

        // Copyboard
        var clipboard = new ClipboardJS('.copyBoard');

        clipboard.on('success', function(e) {
            swal({
                title: `{{ __('Copied!') }}`,
                text: `{{ __('Image URL was copied.') }}`,
                icon: "success",
                buttons: false,
                timer: 2000
            });
        });

        clipboard.on('error', function(e) {
            swal({
                title: `{{ __('Oops!') }}`,
                text: `{{ __('Something wrong.') }}`,
                icon: "error",
                buttons: false,
                timer: 2000
            });
        });

        // Delete media image
        function deleteMedia(mid) {
            swal({
                    title: "{{ __('Are you sure?') }}",
                    text: "{{ __('Do you want to delete this image?') }}",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                })
                .then((willDelete) => {
                    if (willDelete) {
                        window.location.href = "delete-media/" + mid;
                    } else {
                        //Nothing...
                    }
                });
        }

        // Download Image
        function downloadImage(imageUrl, imageName) {
            "use strict";

            $("#download-modal").modal("show");
            var JpgImage = document.getElementById("jpgImage");
            JpgImage.getAttribute("href");
            JpgImage.setAttribute("href", "{{ route('user.download.image') }}?image=" + imageUrl + "&name=" + imageName +
                "&format=jpg");

            var PngImage = document.getElementById("pngImage");
            PngImage.getAttribute("href");
            PngImage.setAttribute("href", "{{ route('user.download.image') }}?image=" + imageUrl + "&name=" + imageName +
                "&format=png");

            var gifImage = document.getElementById("gifImage");
            gifImage.getAttribute("href");
            gifImage.setAttribute("href", "{{ route('user.download.image') }}?image=" + imageUrl + "&name=" + imageName +
                "&format=gif");

            var webpImage = document.getElementById("webpImage");
            webpImage.getAttribute("href");
            webpImage.setAttribute("href", "{{ route('user.download.image') }}?image=" + imageUrl + "&name=" + imageName +
                "&format=webp");
        }

        // Bulk delete
        var deleteIds = [];

        function bulkDelete(id) {
            "use strict";

            if ($(id).is(':checked')) {
                deleteIds.push(id.value);
                if (deleteIds.length > 0) {
                    $("#bulkDelete").removeClass('d-none').fadeIn("slow");

                    $("#bulkDelete").attr("onclick", "bulkDeleteOptimer('" + deleteIds +
                        "', '{{ __('delete') }}'); return false;");
                }
            } else {
                if (deleteIds.length == 1) {
                    $("#bulkDelete").addClass('d-none').fadeOut("slow");
                }
                deleteIds.splice($.inArray(id, deleteIds), deleteIds.length);
                $("#bulkDelete").attr("onclick", "bulkDeleteOptimer('" + deleteIds +
                    "', '{{ __('delete') }}'); return false;");
            }
        }

        // Bulk download
        var downloadIds = [];

        function bulkDownload(id) {
            "use strict";

            if ($(id).is(':checked')) {
                downloadIds.push(id.value);
                if (downloadIds.length > 0) {
                    $("#bulkDownload").removeClass('d-none').fadeIn("slow");
                    $("#bulkDownload").attr("onclick", "bulkDownloadOptimer('" + downloadIds +
                        "', '{{ __('download') }}'); return false;");
                }
            } else {
                if (downloadIds.length == 1) {
                    $("#bulkDownload").addClass('d-none').fadeOut("slow");
                }
                downloadIds.splice($.inArray(id, downloadIds), bulkDownload.length);
                $("#bulkDownload").attr("onclick", "bulkDownloadOptimer('" + downloadIds +
                    "', '{{ __('download') }}'); return false;");
            }
        }

        // Bulk Delete
        function bulkDeleteOptimer(deleteOptimerId) {
            "use strict";

            $("#bulk-delete-modal").modal("show");
            var bulk_delete_status = document.getElementById("bulk_delete_status");
            bulk_delete_status.innerHTML = "<?php echo __('If you proceed, you will deleted all selected media image.'); ?>"
            var bulk_delete_link = document.getElementById("bulk_delete_optimer_id");
            bulk_delete_link.getAttribute("href");
            bulk_delete_link.setAttribute("href", "{{ route('user.bulk.delete.media') }}?id=" + deleteOptimerId);
        }

        // Bulk Download
        function bulkDownloadOptimer(downloadOptimerId) {
            "use strict";

            $("#bulk-download-modal").modal("show");
            var bulk_download_status = document.getElementById("bulk_download_status");
            bulk_download_status.innerHTML = "<?php echo __('If you proceed, you will downloaded all selected media image.'); ?>"
            var bulk_download_link = document.getElementById("bulk_download_optimer_id");
            bulk_download_link.getAttribute("href");
            bulk_download_link.setAttribute("href", "{{ route('user.bulk.download.media') }}?id=" + downloadOptimerId);
        }
    </script>
@endsection
@endsection
