@extends('user.layouts.app')

{{-- Custom CSS & JS --}}
@section('custom-css')
<link href="{{ asset('css/dropzone.min.css')}}" rel="stylesheet">
<script src="{{ asset('js/dropzone.min.js')}}"></script>
@endsection

@php
// Byte conversion
function formatBytes($size, $precision = 2)
{
$base = log($size, 1024);
$suffixes = array('', 'kB', 'MB', 'GB', 'TB');

return round(pow(1024, $base - floor($base)), $precision) .''. $suffixes[floor($base)];
}
@endphp

@section('content')
<div class="page-wrapper">
    <div class="container-fluid">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        {{ __('Overview') }}
                    </div>
                    <h2 class="page-title">
                        {{ __('Upload Media') }}
                    </h2>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-fluid">
            <div class="row row-cards">

                {{-- Failed --}}
                <div class="alert alert-important alert-danger alert-dismissible" id="failed" role="alert">
                    <div class="d-flex">
                        <div id="failedMessage"></div>
                    </div>
                    <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                </div>

                {{-- Success --}}
                <div class="alert alert-important alert-success alert-dismissible" id="success" role="alert">
                    <div class="d-flex">
                        <div id="successMessage"></div>
                    </div>
                    <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                </div>

                <div class="col-sm-12 col-lg-12">
                    <div id="dropzone">
                        <form action="{{ route('user.upload.media') }}" class="dropzone" id="dropzone"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="dz-message">
                                {{ __('Drag and Drop Single/Multiple Files Here.') }} <br> <span class="text-primary">{{
                                    __('Upto') }} {{ formatBytes($plan_details->size) }}</span><br>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- Footer --}}
    @include('user.includes.footer')
</div>

{{-- Custom JS --}}
@section('custom-js')
<script type="text/javascript">
    "use strict";
    $('#success').hide();
    $('#failed').hide();
        Dropzone.options.dropzone = {
            maxFilesize  : `{{ $plan_details->size/1024/1024 }}`,
            acceptedFiles: `{{ $plan_details->access_types }}`,
            filesizeBase: `{{ $plan_details->storage }}`,
            timeout: 180000,
            success: function(file, response) {
                if(response.status == 'success') {
                    // Feature Request
                    $('#success').show(0).delay(5000).hide(0);
                    $('#successMessage').html(`<span>`+response.message+`</span>`);
                    // window.location.href = `{{ route('user.media') }}`;
                } else {
                    $('#failed').show(0).delay(5000).hide(0);
                    $('#failedMessage').html(`<span>`+response.message+`</span>`);
                }
            }
    };
</script>
@endsection
@endsection