@extends('user.layouts.app')

{{-- Custom CSS & JS --}}
@section('custom-css')
<script src="{{ asset('js/clipboard.min.js') }}"></script>
<style>
    .page-wrapper {
        flex: none !important;
        display: flex;
        flex-direction: column;
    }

    .mr-3 {
        margin-left: 0.3rem;
    }

    .mr-5 {
        margin-left: 1rem;
    }

    .mr-10 {
        margin-left: 2rem;
    }

    .mr-15 {
        margin-left: 3rem;
    }

    .float-right {
        float: right;
    }
</style>
@endsection

@section('content')
<div class="page-wrapper">
    <div class="container-fluid">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        {{ __('Overview') }}
                    </div>
                    <h2 class="page-title">
                        {{ __('For Developers - APIs') }}
                    </h2>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-fluid">

            {{-- Error --}}
            @if ($errors->any())
            <div class="alert alert-important alert-danger alert-dismissible" role="alert">
                <div class="d-flex">
                    @foreach ($errors->all() as $error)
                    <div>
                        {{ $error }}
                    </div>
                    @endforeach
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            @endif

            {{-- Success --}}
            @if(Session::has("success"))
            <div class="alert alert-important alert-success alert-dismissible" role="alert">
                <div class="d-flex">
                    <div>
                        {{Session::get('success')}}
                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            @endif

            {{-- Failed --}}
            @if(Session::has("failed"))
            <div class="alert alert-important alert-danger alert-dismissible" role="alert">
                <div class="d-flex">
                    <div>
                        {{Session::get('failed')}}
                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            @endif

            {{-- Check APIs --}}
            @if (isset(json_decode($apis->plan_details)->api))
            @if (json_decode($apis->plan_details)->api != "0")

            {{-- For developers --}}
            <div class="row row-cards">
                {{-- API Key Section --}}
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">{{ __('API KEY') }}</h3>
                        </div>
                        @if (Auth::user()->api_key != "")
                        <div class="card-body">
                            <div class="row row-cards">
                                <div class="mb-3 col-sm-12 col-md-12">
                                    {{-- API Key --}}
                                    <h4 class="card-title">
                                        <code
                                            id="apiKey">{{ \Illuminate\Support\Str::limit(Auth::user()->api_key, 20, $end='xxxxxxxxxxxxxxxxxxxxxxxxxx') }}</code>
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row align-items-center">
                                <div class="col">
                                    {{-- Show Key --}}
                                    <a class="btn btn-primary btn-icon show-key" data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="{{ __('Show Key') }}" onclick="showFullApiKey()">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-eye"
                                            width="24" height="24" viewBox="0 0 24 24" stroke-width="2"
                                            stroke="currentColor" fill="none" stroke-linecap="round"
                                            stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path d="M12 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                            <path
                                                d="M22 12c-2.667 4.667 -6 7 -10 7s-7.333 -2.333 -10 -7c2.667 -4.667 6 -7 10 -7s7.333 2.333 10 7">
                                            </path>
                                        </svg>
                                    </a>

                                    {{-- Hide Key --}}
                                    <a class="btn btn-primary btn-icon hide-key" data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="{{ __('Hide Key') }}" onclick="hideFullApiKey()">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                            class="icon icon-tabler icon-tabler-eye-off" width="24" height="24"
                                            viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path d="M3 3l18 18"></path>
                                            <path d="M10.584 10.587a2 2 0 0 0 2.828 2.83"></path>
                                            <path
                                                d="M9.363 5.365a9.466 9.466 0 0 1 2.637 -.365c4 0 7.333 2.333 10 7c-.778 1.361 -1.612 2.524 -2.503 3.488m-2.14 1.861c-1.631 1.1 -3.415 1.651 -5.357 1.651c-4 0 -7.333 -2.333 -10 -7c1.369 -2.395 2.913 -4.175 4.632 -5.341">
                                            </path>
                                        </svg>
                                    </a>

                                    {{-- Copy Key --}}
                                    <a class="btn btn-primary btn-icon copyBoard" data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="{{ __('Copy Key') }}"
                                        data-clipboard-text="{{ Auth::user()->api_key }}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                            viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <rect x="8" y="8" width="12" height="12" rx="2" />
                                            <path d="M16 8v-2a2 2 0 0 0 -2 -2h-8a2 2 0 0 0 -2 2v8a2 2 0 0 0 2 2h2" />
                                        </svg>
                                    </a>
                                </div>
                                <div class="col-auto">
                                    <form action="{{ route('user.generate.key') }}" method="post">
                                        @csrf
                                        <button type="submit" class="btn btn-primary">{{ __('Generate') }}</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @else
                        <div class="empty">
                            <p class="empty-title">{{ __('Key Not Found') }}</p>
                            <div class="empty-action">
                                <form action="{{ route('user.generate.key') }}" method="post">
                                    @csrf
                                    <button type="submit" class="btn btn-primary">{{ __('Generate') }}</button>
                                </form>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>

                {{-- APIs Documentation --}}
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">{{ __('API Documentation') }}</h3>
                        </div>
                        <div class="card-body">
                            <div class="accordion" id="accordion-example">
                                {{-- Get optimized images --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading-1">
                                        <button class="accordion-button " type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse-1" aria-expanded="true">
                                            {{ __('Get optimized images')}}
                                        </button>
                                    </h2>
                                    <div id="collapse-1" class="accordion-collapse collapse"
                                        data-bs-parent="#accordion-example">
                                        <div class="accordion-body pt-0">
                                            <div class="col-lg-12 col-xl-12">
                                                <div class="mb-3">
                                                    <h4> {{ URL::to('/') }}/api/get-images <span
                                                            class="badge bg-primary float-right text-white">GET</span></h4>
                                                    <span>{{ __('Authorization') }} : YOUR_API_KEY</span><br>
                                                </div>

                                                <div class="row">
                                                    <div class="col-lg-12 col-xl-12 mb-2">
                                                        <div class="bg-dark text-white px-2 py-3">
                                                            <h6 class="mb-2">{{ __('Request Parameters') }}</h6>
                                                            <div class="flex">
                                                                -
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12 col-xl-21">
                                                        <div class="bg-dark text-white px-2 py-3">
                                                            <h6 class="mb-2">{{ __('Response') }}</h6>
                                                            <code class="text-white">
                                                                <div class="mr-3">{</div>
                                                                    <div class="mr-5">"status": true,</div>
                                                                        <div class="mr-5">"overall_optimized_images": 1,</div>
                                                                            <div class="mr-5">"today": 1,</div>
                                                                                <div class="mr-5">"today_optimized_size": "13.99kB",</div>
                                                                                    <div class="mr-5">"all_images": [</div>
                                                                                        <div class="mr-10">{</div>
                                                                                            <div class="mr-15">"image_id": "10772022359773",</div>
                                                                                                <div class="mr-15">"name": "Download-WebP-Images-in-Chrome-as-JPG-or-PNG-1.webp",</div>
                                                                                                    <div class="mr-15">"width": 1000,</div>
                                                                                                        <div class="mr-15">"height": 564,</div>
                                                                                                            <div class="mr-15">"url": "https://optimer.s3.ap-south-1.amazonaws.com/files/2/optimize/80178261414838.webp",</div>
                                                                                                                <div class="mr-15">"size": 14326,</div>
                                                                                                                    <div class="mr-15">"created_at": "2023-02-09T12:50:19.000000Z"</div>
                                                                                                                        <div class="mr-10">}</div>
                                                                                                                            <div class="mr-5">]</div>
                                                                                                                                <div class="mr-3">}</div>
                                                            </code>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Get media images --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading-2">
                                        <button class="accordion-button " type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse-2" aria-expanded="true">
                                            {{ __('Get Media images')}}
                                        </button>
                                    </h2>
                                    <div id="collapse-2" class="accordion-collapse collapse"
                                        data-bs-parent="#accordion-example">
                                        <div class="accordion-body pt-0">
                                            <div class="col-lg-12 col-xl-12">
                                                <div class="mb-3">
                                                    <h4> {{ URL::to('/') }}/api/get-media <span
                                                            class="badge bg-primary float-right text-white">GET</span></h4>
                                                    <span>{{ __('Authorization') }} : YOUR_API_KEY</span><br>
                                                </div>

                                                <div class="row">
                                                    <div class="col-lg-12 col-xl-12 mb-2">
                                                        <div class="bg-dark text-white px-2 py-3">
                                                            <h6 class="mb-2">{{ __('Request Parameters') }}</h6>
                                                            <div class="flex">
                                                                -
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12 col-xl-21">
                                                        <div class="bg-dark text-white px-2 py-3">
                                                            <h6 class="mb-2">{{ __('Response') }}</h6>
                                                            <code class="text-white">
                                                                <div class="mr-3">{</div>
                                                                    <div class="mr-5">"status": true,</div>
                                                                        <div class="mr-5">"overall_media_images": 1,</div>
                                                                            <div class="mr-5">"today": 1,</div>
                                                                                    <div class="mr-5">"all_images": [</div>
                                                                                        <div class="mr-10">{</div>
                                                                                            <div class="mr-15">"image_id": "10772022359773",</div>
                                                                                                <div class="mr-15">"name": "Download-WebP-Images-in-Chrome-as-JPG-or-PNG-1.webp",</div>
                                                                                                    <div class="mr-15">"width": 1000,</div>
                                                                                                        <div class="mr-15">"height": 564,</div>
                                                                                                            <div class="mr-15">"url": "https://optimer.s3.ap-south-1.amazonaws.com/files/2/optimize/80178261414838.webp",</div>
                                                                                                                <div class="mr-15">"size": 14326,</div>
                                                                                                                    <div class="mr-15">"created_at": "2023-02-09T12:50:19.000000Z"</div>
                                                                                                                        <div class="mr-10">}</div>
                                                                                                                            <div class="mr-5">]</div>
                                                                                                                                <div class="mr-3">}</div>
                                                            </code>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Upload images --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading-3">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse-3" aria-expanded="false">
                                            {{ __('Upload images')}}
                                        </button>
                                    </h2>
                                    <div id="collapse-3" class="accordion-collapse collapse"
                                        data-bs-parent="#accordion-example">
                                        <div class="accordion-body pt-0">
                                            <div class="col-lg-12 col-xl-12">
                                                <div class="mb-3">
                                                    <h4> {{ URL::to('/') }}/api/upload <span
                                                            class="badge bg-primary float-right text-white">POST</span></h4>
                                                    <span>{{ __('Authorization') }} : YOUR_API_KEY</span><br>
                                                    <span>{{ __('Content-type') }}: form/data</span>
                                                </div>

                                                <div class="row">
                                                    <div class="col-lg-12 col-xl-12 mb-2">
                                                        <div class="bg-dark text-white px-2 py-3">
                                                            <h6 class="mb-2">{{ __('Request Parameters') }}</h6>
                                                            <div class="flex">
                                                                <p><span class="badge bg-primary text-white">{{ __('Required')
                                                                        }}</span> images[]
                                                                    - Array (File)</p>
                                                                <p><span class="badge bg-primary text-white">{{ __('Required')
                                                                        }}</span>
                                                                    compression_ratio - Integer (Eg: 30)</p>
                                                                <p><span class="badge bg-primary text-white">{{ __('Optional')
                                                                        }}</span>
                                                                    media_upload - String (Eg: true / false)</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12 col-xl-21">
                                                        <div class="bg-dark text-white px-2 py-3">
                                                            <h6 class="mb-2">{{ __('Response') }}</h6>
                                                            <code class="text-white">
                                                                <div class="mr-3">{</div>
                                                                    <div class="mr-5">"status": true,</div>
                                                                        <div class="mr-5">"download_url": [</div>
                                                                            <div class="mr-10">"https://optimer.s3.ap-south-1.amazonaws.com/files/2/optimize/80178261414838.webp"</div>
                                                                                <div class="mr-5">]</div>
                                                                                    <div class="mr-3">}</div>
                                                            </code>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Delete --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading-4">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse-4" aria-expanded="false">
                                            {{ __('Delete') }}
                                        </button>
                                    </h2>
                                    <div id="collapse-4" class="accordion-collapse collapse"
                                        data-bs-parent="#accordion-example">
                                        <div class="accordion-body pt-0">
                                            <div class="col-lg-12 col-xl-12">
                                                <div class="mb-3">
                                                    <h4> {{ URL::to('/') }}/api/delete <span
                                                            class="badge bg-primary float-right text-white">GET</span></h4>
                                                    <span>{{ __('Authorization') }} : YOUR_API_KEY</span><br>
                                                    <span>{{ __('Content-type') }}: application/json</span>
                                                </div>

                                                <div class="row">
                                                    <div class="col-lg-12 col-xl-12 mb-2">
                                                        <div class="bg-dark text-white px-2 py-3">
                                                            <h6 class="mb-2">{{ __('Request Parameters') }}</h6>
                                                            <div class="flex">
                                                                <p><span class="badge bg-primary text-white">{{ __('Required')
                                                                        }}</span>
                                                                    image_id
                                                                    - Array (Eg : ["98515682461707", "98518182369707"])
                                                                </p>
                                                                <p><span class="badge bg-primary text-white">{{ __('Optional')
                                                                        }}</span>
                                                                    permanent_delete - Boolean (Eg: true / false)</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12 col-xl-21">
                                                        <div class="bg-dark text-white px-2 py-3">
                                                            <h6 class="mb-2">{{ __('Response') }}</h6>
                                                            <code class="text-white">
                                                                <div class="mr-3">{</div>
                                                                    <div class="mr-5">"status": true,</div>
                                                                        <div class="mr-5">"delete": [</div>
                                                                            <div class="mr-10">true,</div>
                                                                            <div class="mr-10">true</div>
                                                                                <div class="mr-5">]</div>
                                                                                    <div class="mr-3">}</div>
                                                            </code>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Get Single Image --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading-5">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse-5" aria-expanded="false">
                                            {{ __('Get Single Image') }}
                                        </button>
                                    </h2>
                                    <div id="collapse-5" class="accordion-collapse collapse"
                                        data-bs-parent="#accordion-example">
                                        <div class="accordion-body pt-0">
                                            <div class="col-lg-12 col-xl-12">
                                                <div class="mb-3">
                                                    <h4> {{ URL::to('/') }}/api/get-single-image <span
                                                            class="badge bg-primary float-right text-white">GET</span></h4>
                                                    <span>{{ __('Authorization') }} : YOUR_API_KEY</span><br>
                                                    <span>{{ __('Content-type') }}: application/json</span>
                                                </div>

                                                <div class="row">
                                                    <div class="col-lg-12 col-xl-12 mb-2">
                                                        <div class="bg-dark text-white px-2 py-3">
                                                            <h6 class="mb-2">{{ __('Request Parameters') }}</h6>
                                                            <div class="flex">
                                                                <p><span class="badge bg-primary text-white">{{ __('Required')
                                                                        }}</span>
                                                                    image_id
                                                                    - String (Eg : "98515682461707")
                                                                </p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12 col-xl-21">
                                                        <div class="bg-dark text-white px-2 py-3">
                                                            <h6 class="mb-2">{{ __('Response') }}</h6>
                                                            <code class="text-white">
                                                                <div class="mr-3">{</div>
                                                                    <div class="mr-5">"status": true,</div>
                                                                                    <div class="mr-5">"single_image": </div>
                                                                                        <div class="mr-10">{</div>
                                                                                            <div class="mr-15">"image_id": "10772022359773",</div>
                                                                                                <div class="mr-15">"name": "Download-WebP-Images-in-Chrome-as-JPG-or-PNG-1.webp",</div>
                                                                                                    <div class="mr-15">"width": 1000,</div>
                                                                                                        <div class="mr-15">"height": 564,</div>
                                                                                                            <div class="mr-15">"url": "https://optimer.s3.ap-south-1.amazonaws.com/files/2/optimize/80178261414838.webp",</div>
                                                                                                                <div class="mr-15">"size": 14326,</div>
                                                                                                                    <div class="mr-15">"created_at": "2023-02-09T12:50:19.000000Z"</div>
                                                                                                                        <div class="mr-10">}</div>
                                                                                                                                <div class="mr-3">}</div>
                                                            </code>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Get check status --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading-6">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse-6" aria-expanded="false">
                                            {{ __('Check Status') }}
                                        </button>
                                    </h2>
                                    <div id="collapse-6" class="accordion-collapse collapse"
                                        data-bs-parent="#accordion-example">
                                        <div class="accordion-body pt-0">
                                            <div class="col-lg-12 col-xl-12">
                                                <div class="mb-3">
                                                    <h4> {{ URL::to('/') }}/api/check-status <span
                                                            class="badge bg-primary float-right text-white">GET</span></h4>
                                                    <span>{{ __('Authorization') }} : YOUR_API_KEY</span><br>
                                                </div>

                                                <div class="row">
                                                    <div class="col-lg-12 col-xl-12 mb-2">
                                                        <div class="bg-dark text-white px-2 py-3">
                                                            <h6 class="mb-2">{{ __('Request Parameters') }}</h6>
                                                            <div class="flex">
                                                                -
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12 col-xl-21">
                                                        <div class="bg-dark text-white px-2 py-3">
                                                            <h6 class="mb-2">{{ __('Response') }}</h6>
                                                            <code class="text-white">
                                                                <div class="mr-3">{</div>
                                                                    <div class="mr-5">"status": true,</div>
                                                                        <div class="mr-5">"maximum_optimize": "Unlimited",</div>
                                                                        <div class="mr-5">"available_optimize": "Unlimited",</div>
                                                                        <div class="mr-5">"current_storage": "20GB",</div>
                                                                        <div class="mr-5">"used_storage": 0,</div>
                                                                        <div class="mr-5">"available_storage": "20GB"</div>
                                                                        <div class="mr-3">}</div>
                                                            </code>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @else
                <div class="empty">
                    <div class="empty-img"><img src="./static/illustrations/undraw_printing_invoices_5r4r.svg"
                            height="128" alt="">
                    </div>
                    <p class="empty-title">{{ __('You do not have permission to access the conversation API based on your existing plan. Choose a plan to access the conversation API.') }}</p>
                    <div class="empty-action">
                        <a href="{{ route('user.plans') }}" class="btn btn-primary">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-id" width="24"
                                height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <rect x="3" y="4" width="18" height="16" rx="3"></rect>
                                <circle cx="9" cy="10" r="2"></circle>
                                <line x1="15" y1="8" x2="17" y2="8"></line>
                                <line x1="15" y1="12" x2="17" y2="12"></line>
                                <line x1="7" y1="16" x2="17" y2="16"></line>
                            </svg>
                            {{ __('Choose Plan') }}
                        </a>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
    @endif

    {{-- Footer --}}
    @include('user.includes.footer')
</div>

{{-- Custom JS --}}
@section('custom-js')
<script>
    // Default
    $(".hide-key").css("display", "none");
    $(".show-key").css("display", "inline-flex");

    // Copyboard
var clipboard = new ClipboardJS('.copyBoard');

clipboard.on('success', function(e) {
    swal({
        title: `{{ __("Copied!") }}`,
        text: `{{ __("API Key was copied.") }}`,
        icon: "success",
        buttons: false,
        timer: 2000
    });
});

clipboard.on('error', function(e) {
    swal({
        title: `{{ __("Oops!") }}`,
        text: `{{ __("Something wrong.") }}`,
        icon: "error",
        buttons: false,
        timer: 2000
    });
});

// Show full api key
function showFullApiKey() {
    "use strict";
    $(".hide-key").css("display", "inline-flex");
    $(".show-key").css("display", "none");
    var apiKey = document.getElementById("apiKey");
    apiKey.innerHTML = `{{ Auth::user()->api_key }}`;
}

// Hide full api key
function hideFullApiKey() {
    "use strict";
    $(".show-key").css("display", "inline-flex");
    $(".hide-key").css("display", "none");
    var apiKey = document.getElementById("apiKey");
    apiKey.innerHTML = `{{ \Illuminate\Support\Str::limit(Auth::user()->api_key, 20, $end='xxxxxxxxxxxxxxxxxxxxxxxxxx') }}`;
}
</script>
@endsection
@endsection