@extends('user.layouts.app')

@php
// Byte conversion
function formatBytes($size, $precision = 2)
{
$base = log($size, 1024);
$suffixes = array('', 'kB', 'MB', 'GB', 'TB');
$result = round(pow(1024, $base - floor($base)), $precision) .''. $suffixes[floor($base)];
if($result != "NAN ") {
return $result;
} else {
return $result = 0;
}
}
@endphp

@section('content')
<div class="page-wrapper">
    <div class="container-fluid">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        {{ __('Overview') }}
                    </div>
                    <h2 class="page-title">
                        {{ __('Dashboard') }}
                    </h2>
                </div>
                {{-- Create new Optimize --}}
                <div class="col-12 col-md-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('user.create.optimer') }}" class="btn btn-primary d-none d-sm-inline-block">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-upload"
                                width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M4 17v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-2"></path>
                                <polyline points="7 9 12 4 17 9"></polyline>
                                <line x1="12" y1="4" x2="12" y2="16"></line>
                            </svg>
                            {{ __('Optimize') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-fluid">

            {{-- Access deined --}}
            @if(Session::has("access"))
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        {{Session::get('access')}}
                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            @endif

            {{-- Failed --}}
            @if(Session::has("failed"))
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        {{Session::get('failed')}}
                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            @endif

            {{-- Success --}}
            @if(Session::has("success"))
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        {{Session::get('success')}}
                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            @endif

            <div class="row row-deck row-cards">
                {{-- Current plan --}}
                <div class="col-6 col-lg-3">
                    <div class="card bg-custom5">
                        <div class="card-body text-custom">
                            <div class="d-flex align-items-center mb-3">
                                <div class="subheader">{{ __('Current Plan') }}</div>
                            </div>
                            @if ($active_plan->price == 0)
                            <p class="h1">{{ __($active_plan->name) }}</p>
                            <p>{{ __('FREE PLAN') }}</p>
                            @else
                            <p class="h1"><b>{{ __($active_plan->name) }}</b></h3>
                            <p class="fw-bold mb-3">{{ __('Remaining Days') }} : {{ $remaining_days > 0 ? (int) $remaining_days . __(' Day(s) Left') : __('Plan Expired!') }}</p>
                            @endif
                            <a class="h5 text-primary" href="{{ route('user.plans') }}">
                                {{ __('Show details') }}
                            </a>
                        </div>
                    </div>
                </div>

                {{-- Optimize --}}
                <div class="col-6 col-lg-3">
                    <div class="card bg-custom6">
                        <div class="card-body text-custom">
                            <div class="d-flex align-items-center mb-3">
                                <div class="subheader">{{ __('Today Optimize Images') }}</div>
                            </div>
                            <p class="h1">{{ $today_optimers_count }}</p>
                            <a class="h5 text-primary" href="{{ route('user.all.optimer') }}">
                                {{ __('Show details') }}
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-6 col-lg-3">
                    <div class="card bg-custom7">
                        <div class="card-body text-custom">
                            <div class="d-flex align-items-center mb-3">
                                <div class="subheader">{{ __('Today Saved') }}</div>
                            </div>
                            <p class="h1">{{ $today_optimized_image_size != 0 ?
                                formatBytes($today_optimized_image_size) : 0 }}</p>
                            <a class="h5 text-primary" href="{{ route('user.all.optimer') }}">
                                {{ __('Show details') }}
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-6 col-lg-3">
                    <div class="card bg-custom8">
                        <div class="card-body text-custom">
                            <div class="row">
                                <div class="col-6 col-lg-6">
                                    <small class="h4 mb-3">{{ __('Storage Usage') }}</small>
                                    <p class="mb-3"><strong>{{ $storageUsage != 0 ? formatBytes($storageUsage) : 0 }} </strong> {{ __('of') }} <strong>{{ $current_storage != 0 ? formatBytes($current_storage) : 0 }}</strong></p>
                                </div>
                                <div class="col-6 col-lg-6">
                                    <h1 class="float-right">{{ number_format((float)$storageUsage/$current_storage*100,
                                        2, '.', '') }}%</h1>
                                </div>
                            </div>
                            <div class="progress progress-separated mb-3">
                                <div class="progress-bar bg-danger" role="progressbar"
                                    style="width: {{ number_format((float)$storageUsage/$current_storage*100, 2, '.', '') }}%"
                                    aria-label="Regular"></div>
                            </div>
                            <div class="row">
                                <div class="col-auto d-flex align-items-center pe-2">
                                    <span class="legend me-2 bg-danger"></span>
                                    <span>{{ __('Used') }}</span>
                                </div>
                                <div class="col-auto d-flex align-items-center ps-2">
                                    <span class="legend me-2"></span>
                                    <span>{{ __('Free') }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Recent Optimize --}}
                <div class="col-md-12 col-lg-21">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">{{ __('Recent 10 Optimizes') }}</h3>
                        </div>
                        <div class="card-table table-responsive">
                            <table class="table table-vcenter card-table" id="table">
                                <thead>
                                    <tr>
                                        <th>{{ __('S.No') }}</th>
                                        <th>{{ __('Uploaded on') }}</th>
                                        <th>{{ __('Name') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {{-- Optimize images --}}
                                    @foreach ($optimers as $optimer)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ formatDateForUser($optimer->created_at) }}</td>
                                        <td data-label="Name">
                                            <a href="{{ asset($optimer->actual_image) }}" target="_blank">
                                                <div class="d-flex py-1 align-items-center">
                                                    <span class="avatar me-2"
                                                        style="background-image: url({{ asset($optimer->actual_image) }})"></span>
                                                    <div class="flex-fill">
                                                        <div class="font-weight-small">{{ __('File Name') }} : {{
                                                            Str::ucfirst($optimer->name) }}</div>
                                                        <small>{{ __('File Size') }} : {{
                                                            formatBytes($optimer->actual_image_size) }}</small> |
                                                        <small>{{ __('Saved Size') }} : {{
                                                            formatBytes($optimer->optimized_image_size) }}</small>
                                                    </div>
                                                </div>
                                            </a>
                                        </td>
                                        <td class="text-end">
                                            <span class="dropdown">
                                                <button class="btn small-btn dropdown-toggle align-text-top"
                                                    data-bs-boundary="viewport" data-bs-toggle="dropdown"
                                                    aria-expanded="false">{{ __('Actions') }}</button>
                                                <div class="dropdown-menu dropdown-menu-end" style="">
                                                    <a class="dropdown-item"
                                                        href="{{ route('user.download.optimer', $optimer->id) }}">{{
                                                        __('Download') }}</a>
                                                    <a class="dropdown-item" href="#"
                                                        onclick="deleteOptimer('{{ $optimer->id }}', '{{ __('delete') }}'); return false;">{{
                                                        __('Delete') }}</a>
                                                </div>
                                            </span>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    {{-- Footer --}}
    @include('user.includes.footer')
</div>

{{-- Delete Optimize Modal --}}
<div class="modal modal-blur fade" id="delete-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="modal-title">{{ __('Are you sure?')}}</div>
                <div id="delete_status"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary me-auto" data-bs-dismiss="modal">{{
                    __('Cancel')}}</button>
                <a class="btn btn-danger" id="delete_optimer_id">{{ __('Yes, proceed')}}</a>
            </div>
        </div>
    </div>
</div>

{{-- Custom JS --}}
@section('custom-js')
<script>
    // Delete Optimer
function deleteOptimer(deleteOptimerId, deleteOptimerStatus) {
    "use strict";
    $("#delete-modal").modal("show");
    var delete_status = document.getElementById("delete_status");
    delete_status.innerHTML = "<?php echo __('If you proceed, you will') ?> " + deleteOptimerStatus + " <?php echo __('this optimize image.') ?>"
    var delete_link = document.getElementById("delete_optimer_id");
    delete_link.getAttribute("href");
    delete_link.setAttribute("href", "{{ route('user.delete.optimer') }}?id=" + deleteOptimerId);
}
</script>
@endsection
@endsection