@php
    // Settings
    use App\Models\Setting;
    use App\Models\Config;
    use App\Models\Page;

    $setting = Setting::where('status', 1)->first();
    $page = Page::where('slug', 'home')->where('status', 1)->get();
    $config = Config::get();

    // Selected theme
    $theme = 'classic';
    $section = 'errors.classic.429';
    $topbar = 'website.classic.includes.topbar';
    $footer = 'website.classic.includes.footer';
    if ($config[48]->config_value == '330599619570398') {
        $theme = 'modern';
        $section = 'errors.modern.429';
        $topbar = 'website.modern.includes.topbar';
        $footer = 'website.modern.includes.footer';
    }
@endphp

@extends('layouts.' . $theme, ['title' => '429'. ' - ' . $page[0]->meta_title])

@section('content')

{{-- Topbar --}}
@include($topbar)

{{-- 419 --}}
@include($section)

{{-- Footer --}}
@include($footer)

@endsection