@php
    // Settings
    use App\Models\Setting;
    use App\Models\Config;
    use App\Models\Page;
    use Artesaos\SEOTools\Facades\JsonLd;
    use Artesaos\SEOTools\Facades\SEOMeta;
    use Artesaos\SEOTools\Facades\SEOTools;
    use Artesaos\SEOTools\Facades\OpenGraph;

    $page = Page::where('slug', 'home')->where('status', 1)->get();
    $setting = Setting::where('status', 1)->first();
    $config = Config::get();

    // Seo Tools
    SEOTools::setTitle(trans('Verify Email') . ' - ' . $page[0]->meta_title);
    SEOTools::setDescription($page[0]->description);

    SEOMeta::setTitle(trans('Verify Email') . ' - ' . $page[0]->meta_title);
    SEOMeta::setDescription($page[0]->description);
    SEOMeta::addMeta('article:section', trans('Verify Email') . ' - ' . $page[0]->meta_title, 'property');
    SEOMeta::addKeyword([$page[0]->keywords]);

    OpenGraph::setTitle(trans('Verify Email') . ' - ' . $page[0]->meta_title);
    OpenGraph::setDescription($page[0]->description);
    OpenGraph::setUrl(URL::full());
    OpenGraph::addImage([asset($setting->site_logo), 'size' => 300]);

    JsonLd::setTitle(trans('Verify Email') . ' - ' . $page[0]->meta_title);
    JsonLd::setDescription($page[0]->description);
    JsonLd::addImage(asset($setting->site_logo));

    $recaptcha_configuration = [
        'RECAPTCHA_ENABLE' => env('RECAPTCHA_ENABLE', ''),
        'RECAPTCHA_SITE_KEY' => env('RECAPTCHA_SITE_KEY', ''),
        'RECAPTCHA_SECRET_KEY' => env('RECAPTCHA_SECRET_KEY', ''),
    ];

    $setting['recaptcha_configuration'] = $recaptcha_configuration;

    // Selected theme
    $theme = 'classic';
    $section = 'auth.classic.verify';
    $topbar = 'website.classic.includes.topbar';
    $footer = 'website.classic.includes.footer';
    if ($config[48]->config_value == '330599619570398') {
        $theme = 'modern';
        $section = 'auth.modern.verify';
        $topbar = 'website.modern.includes.topbar';
        $footer = 'website.modern.includes.footer';
    }
@endphp

@extends('layouts.' . $theme)

@section('content')
    {{-- Topbar --}}
    @if ($config[46]->config_value == 'yes')
        @include($topbar)
    @endif

    {{-- Login section --}}
    @include($section, ['settings' => $setting])

    {{-- Footer --}}
    @if ($config[46]->config_value == 'yes')
        @include($footer)
    @endif
@endsection
