@php
    // Settings
    use App\Models\Setting;
    use App\Models\Config;

    $setting = Setting::where('status', 1)->first();
    $config = Config::get();

    // Selected theme
    $theme = 'classic';
    $section = 'auth.classic.register';
    $topbar = 'website.classic.includes.topbar';
    $footer = 'website.classic.includes.footer';
    if ($config[48]->config_value == '330599619570398') {
        $theme = 'modern';
        $section = 'auth.modern.register';
        $topbar = 'website.modern.includes.topbar';
        $footer = 'website.modern.includes.footer';
    }
@endphp

@extends('layouts.' . $theme)

@section('content')

{{-- Topbar --}}
@if ($config[46]->config_value == "yes")
    @include($topbar)
@endif

{{-- Login section --}}
@include($section)

{{-- Footer --}}
@if ($config[46]->config_value == "yes")
    @include($footer)
@endif
 
{{-- Show / Hide Password --}}
@section('custom-js')
<script>
    function showPassword() {
        "use strict";
        var temp = document.getElementById("password");
        if (temp.type === "password") {
            temp.type = "text";
        } else {
            temp.type = "password";
        }
    }

    function showConfirmPassword() {
        "use strict";
        var temp = document.getElementById("password-confirm");
        if (temp.type === "password") {
            temp.type = "text";
        } else {
            temp.type = "password";
        }
    }
</script>
@endsection
@endsection