{{-- Queries --}}
@php
    use App\Models\Config;
    use App\Models\Setting;
    use App\Models\Page;
    use Artesaos\SEOTools\Facades\JsonLd;
    use Artesaos\SEOTools\Facades\SEOMeta;
    use Artesaos\SEOTools\Facades\SEOTools;
    use Artesaos\SEOTools\Facades\OpenGraph;

    $page = Page::where('slug', 'home')->where('status', 1)->get();
    $config = Config::get();
    $setting = Setting::where('status', 1)->first();

    // Seo Tools
    SEOTools::setTitle(trans('Reset Password') . ' - ' . $page[0]->meta_title);
    SEOTools::setDescription($page[0]->description);

    SEOMeta::setTitle(trans('Reset Password') . ' - ' . $page[0]->meta_title);
    SEOMeta::setDescription($page[0]->description);
    SEOMeta::addMeta('article:section', trans('Reset Password') . ' - ' . $page[0]->meta_title, 'property');
    SEOMeta::addKeyword([$page[0]->keywords]);

    OpenGraph::setTitle(trans('Reset Password') . ' - ' . $page[0]->meta_title);
    OpenGraph::setDescription($page[0]->description);
    OpenGraph::setUrl(URL::full());
    OpenGraph::addImage([asset($setting->site_logo), 'size' => 300]);

    JsonLd::setTitle(trans('Reset Password') . ' - ' . $page[0]->meta_title);
    JsonLd::setDescription($page[0]->description);
    JsonLd::addImage(asset($setting->site_logo));

    $recaptcha_configuration = [
        'RECAPTCHA_ENABLE' => env('RECAPTCHA_ENABLE', ''),
        'RECAPTCHA_SITE_KEY' => env('RECAPTCHA_SITE_KEY', ''),
        'RECAPTCHA_SECRET_KEY' => env('RECAPTCHA_SECRET_KEY', ''),
    ];

    $setting['recaptcha_configuration'] = $recaptcha_configuration;

    // Selected theme
    $theme = 'classic';
    $section = 'auth.classic.reset';
    $topbar = 'website.classic.includes.topbar';
    $footer = 'website.classic.includes.footer';
    if ($config[48]->config_value == '330599619570398') {
        $theme = 'modern';
        $section = 'auth.modern.reset';
        $topbar = 'website.modern.includes.topbar';
        $footer = 'website.modern.includes.footer';
    }
@endphp

@extends('layouts.' . $theme)

@section('content')
    {{-- Custom CSS --}}
@section('custom-css')
    <style type="text/css">
        a:hover {
            cursor: pointer;
        }
    </style>
@endsection

{{-- Topbar --}}
@if ($config[46]->config_value == 'yes')
@include($topbar)
@endif

{{-- Login section --}}
@include($section, ['settings' => $setting])

{{-- Footer --}}
@if ($config[46]->config_value == 'yes')
@include($footer)
@endif

{{-- Show / Hide Password --}}
@section('custom-js')
    <script>
        function showPassword() {
            "use strict";
            var temp = document.getElementById("password");
            if (temp.type === "password") {
                temp.type = "text";
            } else {
                temp.type = "password";
            }
        }

        function showConfirmPassword() {
            "use strict";
            var temp = document.getElementById("password-confirm");
            if (temp.type === "password") {
                temp.type = "text";
            } else {
                temp.type = "password";
            }
        }
    </script>
@endsection
@endsection
