<section class="relative py-12 md:py-12 bg-gray-900 overflow-hidden h-screen">
    <img
    class="absolute bottom-0 left-0 w-full xl:-mb-24" src="{{ asset('modern/assets/sign-up/half-circle-dark.png') }}" alt="{{ config('app.name') }}">
    <div class="relative container px-4 mx-auto">
        <div>
            <div class="max-w-md p-8 mb-8 mx-auto bg-gray-900 border border-gray-700 rounded-2xl shadow-lg">
                <h3 class="font-heading tracking-tight text-4xl font-bold text-white mb-4">{{ __('Verify Your Email Address') }}</h3>

                {{-- Resent --}}
                @if (session('resent'))
                    <div class="alert flex flex-row items-center bg-gradient-to-br from-cyanGreen-800 to-cyan-800 p-5 rounded border-b-2 mb-3"
                        data-aos="fade-up" data-aos-delay="100">
                        <div class="alert-content">
                            <div class="alert-description text-sm text-{{ $config[11]->config_value }}-600">
                                {{ __('A fresh verification link has been sent to your email address.') }}
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Information --}}
                <div class="alert flex flex-row items-center bg-red-200 p-5 rounded border-b-2 border-red-300 mb-3"
                    data-aos="fade-up" data-aos-delay="100">
                    <div
                        class="alert-icon flex items-center bg-red-100 border-2 border-red-500 justify-center h-10 w-10 flex-shrink-0 rounded-full">
                        <span class="text-red-500">
                            <svg fill="currentColor" viewBox="0 0 20 20" class="h-6 w-6">
                                <path fill-rule="evenodd"
                                    d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                    clip-rule="evenodd"></path>
                            </svg>
                        </span>
                    </div>
                    <div class="alert-content">
                        <div class="alert-description text-sm text-red-600">
                            {{ __('Before proceeding, please check your email for a verification link.') }}
                            {{ __('If you did not receive the email') }},
                        </div>
                    </div>
                </div>

                {{-- Form --}}
                <form method="POST" action="{{ route('verification.resend') }}" data-aos="fade-up"
                    data-aos-delay="100">
                    @csrf

                    <button
                        class="xs:flex-shrink-0 group relative w-full h-12 mb-3 flex items-center justify-center px-4 p-px font-bold text-gray-900 bg-yellowGreen-600 rounded-lg transition-all duration-300 focus:outline-none"
                        type="submit">
                        <div
                            class="absolute top-0 left-0 w-full h-full rounded-lg ring ring-yellowGreen-900 animate-pulse group-hover:ring-0 transition duration-300">
                        </div>
                        <span>{{ __('click here to request another') }}</span>
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>
