<section class="relative py-12 md:py-12 bg-gray-900 overflow-hidden"><img
        class="absolute bottom-0 left-0 w-full xl:-mb-24" src="{{ asset('modern/assets/sign-up/half-circle-dark.png') }}" alt="{{ config('app.name') }}">
    <div class="relative container px-4 mx-auto">
        <div>
            <div class="max-w-md p-8 mb-8 mx-auto bg-gray-900 border border-gray-700 rounded-2xl shadow-lg">
                <h3 class="font-heading tracking-tight text-4xl font-bold text-white mb-4">{{ __('Sign Up') }}</h3>
                <p class="text-gray-400 mb-8">{{ __('Create your account with your work email.') }}</p>

                {{-- Form --}}
                <form method="POST" action="{{ route('register') }}" data-aos="fade-up" data-aos-delay="100">
                    @csrf

                    {{-- Name --}}
                    <div class="mb-8">
                        <label class="block mb-2 text-sm font-medium text-white" for="name">{{ __('Name') }}</label>
                        <input
                            class="py-2 px-4 h-11 w-full text-gray-500 placeholder-gray-500 bg-gray-900 border border-gray-700 focus:border-teal-800 shadow-sm outline-none ring ring-transparent focus:ring-teal-800 rounded-lg"
                            type="text" id="name" placeholder="{{ __('Patryk') }}" name="name" value="{{ old('name') }}" autocomplete="name" autofocus required>
                        
                        @error('name')
                            <span class="invalid-feedback mt-1 text-white" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    
                    {{-- Email --}}
                    <div class="mb-8">
                        <label class="block mb-2 text-sm font-medium text-white" for="email">{{ __('Email') }}</label>
                        <input
                            class="py-2 px-4 h-11 w-full text-gray-500 placeholder-gray-500 bg-gray-900 border border-gray-700 focus:border-teal-800 shadow-sm outline-none ring ring-transparent focus:ring-teal-800 rounded-lg"
                            type="email" id="email" name="email" value="{{ old('email') }}" autocomplete="email" placeholder="{{ __('dev@domain.com') }}" required>

                        @error('email')
                            <span class="invalid-feedback mt-1 text-white" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>

                    {{-- Password --}}
                    <div class="mb-8">
                        <label class="block mb-2 text-sm font-medium text-white" for="">{{ __('Password') }}</label>
                        <div class="relative">
                            <input
                                class="relative py-2 px-4 h-11 w-full text-gray-500 placeholder-gray-500 bg-gray-900 border border-gray-700 focus:border-teal-800 shadow-sm outline-none ring ring-transparent focus:ring-teal-800 rounded-lg"
                                type="password" name="password" id="password" required autocomplete="new-password" placeholder="{{ __('************') }}">
                            
                            @error('password')
                            <span class="invalid-feedback mt-1 text-white" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror

                            {{-- Show password --}}
                            <button type="button" title="{{ __('Show password') }}" data-bs-toggle="tooltip" onclick="showPassword()"
                                class="absolute top-1/2 right-0 mr-3 transform -translate-y-1/2 inline-block focus:outline-none text-gray-500 hover:text-yellowGreen-600">
                                <svg width="20" height="20" viewbox="0 0 20 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M2.5 10.8334C5.5 4.16671 14.5 4.16671 17.5 10.8334" stroke="currentColor"
                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path
                                        d="M10 14.1666C8.61929 14.1666 7.5 13.0473 7.5 11.6666C7.5 10.2859 8.61929 9.16663 10 9.16663C11.3807 9.16663 12.5 10.2859 12.5 11.6666C12.5 13.0473 11.3807 14.1666 10 14.1666Z"
                                        stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                </svg>
                            </button>
                        </div>
                    </div>

                    {{-- Confirm Password --}}
                    <div class="mb-8">
                        <label class="block mb-2 text-sm font-medium text-white" for="">{{ __('Confirm Password') }}</label>
                        <div class="relative">
                            <input
                                class="relative py-2 px-4 h-11 w-full text-gray-500 placeholder-gray-500 bg-gray-900 border border-gray-700 focus:border-teal-800 shadow-sm outline-none ring ring-transparent focus:ring-teal-800 rounded-lg"
                                type="password" name="password_confirmation" id="password-confirm" autocomplete="new-password" placeholder="{{ __('************') }}" required>

                            {{-- Show password --}}
                            <button type="button" title="{{ __('Show password') }}" data-bs-toggle="tooltip" onclick="showConfirmPassword()"
                                class="absolute top-1/2 right-0 mr-3 transform -translate-y-1/2 inline-block focus:outline-none text-gray-500 hover:text-yellowGreen-600">
                                <svg width="20" height="20" viewbox="0 0 20 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M2.5 10.8334C5.5 4.16671 14.5 4.16671 17.5 10.8334" stroke="currentColor"
                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path
                                        d="M10 14.1666C8.61929 14.1666 7.5 13.0473 7.5 11.6666C7.5 10.2859 8.61929 9.16663 10 9.16663C11.3807 9.16663 12.5 10.2859 12.5 11.6666C12.5 13.0473 11.3807 14.1666 10 14.1666Z"
                                        stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                </svg>
                            </button>
                        </div>
                    </div>

                    {{-- Recaptcha --}}
                    @if ($settings['recaptcha_configuration']['RECAPTCHA_ENABLE'] == 'on')
                        <div class="mb-8">
                            {!! htmlFormSnippet() !!}
                        </div>
                    @endif

                    <button
                        class="xs:flex-shrink-0 group relative w-full h-12 mb-8 flex items-center justify-center px-4 p-px font-bold text-gray-900 bg-yellowGreen-600 rounded-lg transition-all duration-300 focus:outline-none"
                        type="submit">
                        <div
                            class="absolute top-0 left-0 w-full h-full rounded-lg ring ring-yellowGreen-900 animate-pulse group-hover:ring-0 transition duration-300">
                        </div>
                        <span>{{ __('Sign Up') }}</span>
                    </button>
                </form>
            </div>
            {{-- Login --}}
            @if (Route::has('login'))
            <div class="text-center">
                <p class="text-sm">
                    <span class="mr-1 text-gray-500">{{ __('Already have an account?') }}</span>
                    <a class="inline-block text-yellowGreen-600 hover:text-yellowGreen-500 font-semibold"
                        href="{{ route('login') }}">{{ __('Login') }}</a>
                </p>
            </div>
            @endif
        </div>
    </div>
</section>
