<section class="relative py-12 md:py-12 bg-gray-900 overflow-hidden h-screen"><img
    class="absolute bottom-0 left-0 w-full xl:-mb-24" src="{{ asset('modern/assets/sign-up/half-circle-dark.png') }}" alt="{{ config('app.name') }}">
    <div class="relative container px-4 mx-auto">
        <div>
            <div class="max-w-md p-8 mb-8 mx-auto bg-gray-900 border border-gray-700 rounded-2xl shadow-lg">
                <h3 class="font-heading tracking-tight text-4xl font-bold text-white mb-4">{{ __('Reset Password') }}</h3>

                {{-- Success --}}
                @if (session('status'))
                    <div class="alert flex flex-row items-center bg-{{ $config[11]->config_value }}-200 p-5 rounded border-b-2 border-{{ $config[11]->config_value }}-300 mb-3"
                        data-aos="fade-up" data-aos-delay="100">
                        <div class="alert-content">
                            <div class="alert-description text-sm text-{{ $config[11]->config_value }}-600">
                                {{ session('status') }}
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Form --}}
                <form method="POST" action="{{ route('password.email') }}" data-aos="fade-up" data-aos-delay="100">
                    @csrf

                    {{-- Email --}}
                    <div class="mb-8">
                        <label class="block mb-2 text-sm font-medium text-white" for="email">{{ __('Email') }}</label>
                        <input
                            class="py-2 px-4 h-11 w-full text-gray-500 placeholder-gray-500 bg-gray-900 border border-gray-700 focus:border-teal-800 shadow-sm outline-none ring ring-transparent focus:ring-teal-800 rounded-lg"
                            type="email" name="email" id="email" value="{{ old('email') }}" autocomplete="email" placeholder="{{ __('dev@domain.com') }}" required>
                    
                        @error('email')
                            <span class="invalid-feedback mt-1 text-white" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>

                    {{-- Recaptcha --}}
                    @if ($settings['recaptcha_configuration']['RECAPTCHA_ENABLE'] == 'on')
                        <div class="mb-8">
                            {!! htmlFormSnippet() !!}
                        </div>
                    @endif

                    <button
                        class="xs:flex-shrink-0 group relative w-full h-12 mb-3 flex items-center justify-center px-4 p-px font-bold text-gray-900 bg-yellowGreen-600 rounded-lg transition-all duration-300 focus:outline-none"
                        type="submit">
                        <div
                            class="absolute top-0 left-0 w-full h-full rounded-lg ring ring-yellowGreen-900 animate-pulse group-hover:ring-0 transition duration-300">
                        </div>
                        <span>{{ __('Send Password Reset Link') }}</span>
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>
