<section class="relative py-12 md:py-12 bg-gray-900 overflow-hidden h-screen">
    <img
    class="absolute bottom-0 left-0 w-full xl:-mb-24" src="{{ asset('modern/assets/sign-up/half-circle-dark.png') }}" alt="{{ config('app.name') }}">
    <div class="relative container px-4 mx-auto">
        <div>
            <div class="max-w-md p-8 mb-8 mx-auto bg-gray-900 border border-gray-700 rounded-2xl shadow-lg">
                <h3 class="font-heading tracking-tight text-4xl font-bold text-white mb-4">{{ __('Confirm Password') }}</h3>

                {{-- Information --}}
                <div class="alert flex flex-row items-center bg-red-200 p-5 rounded border-b-2 border-red-300 mb-3"
                    data-aos="fade-up" data-aos-delay="100">
                    <div class="alert-content">
                        <div class="alert-description text-sm text-red-600">
                            {{ __('Please confirm your password before continuing.') }}
                        </div>
                    </div>
                </div>

                {{-- Success --}}
                @if (session('status'))
                    <div class="alert flex flex-row items-center bg-{{ $config[11]->config_value }}-200 p-5 rounded border-b-2 border-{{ $config[11]->config_value }}-300 mb-3"
                        data-aos="fade-up" data-aos-delay="100">
                        <div class="alert-content">
                            <div class="alert-description text-sm text-{{ $config[11]->config_value }}-600">
                                {{ session('status') }}
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Form --}}
                <form method="POST" action="{{ route('password.confirm') }}" data-aos="fade-up" data-aos-delay="100">
                    @csrf

                    {{-- Password --}}
                    <div class="mb-1">
                        <label class="block mb-2 text-sm font-medium text-white" for="">{{ __('Password') }}</label>
                        <div class="relative">
                            <input
                                class="relative py-2 px-4 h-11 w-full text-gray-500 placeholder-gray-500 bg-gray-900 border border-gray-700 focus:border-teal-800 shadow-sm outline-none ring ring-transparent focus:ring-teal-800 rounded-lg"
                                type="password" name="password" id="password" required autocomplete="current-password" placeholder="{{ __('************') }}">
                            
                            @error('password')
                            <span class="invalid-feedback mt-1 text-white" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror

                            {{-- Show password --}}
                            <button type="button" title="{{ __('Show password') }}" data-bs-toggle="tooltip" onclick="showPassword()"
                                class="absolute top-1/2 right-0 mr-3 transform -translate-y-1/2 inline-block focus:outline-none text-gray-500 hover:text-yellowGreen-600">
                                <svg width="20" height="20" viewbox="0 0 20 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M2.5 10.8334C5.5 4.16671 14.5 4.16671 17.5 10.8334" stroke="currentColor"
                                        stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path
                                        d="M10 14.1666C8.61929 14.1666 7.5 13.0473 7.5 11.6666C7.5 10.2859 8.61929 9.16663 10 9.16663C11.3807 9.16663 12.5 10.2859 12.5 11.6666C12.5 13.0473 11.3807 14.1666 10 14.1666Z"
                                        stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                </svg>
                            </button>
                        </div>
                    </div>

                    {{-- Forget password --}}
                    @if (Route::has('password.request'))
                    <div class="text-right mb-8">
                        <a
                            class="inline-block text-sm font-semibold text-yellowGreen-600 hover:text-yellowGreen-500 {{ App::isLocale('ar') || App::isLocale('ur') || App::isLocale('he') ? 'rtl-justify-between' : 'justify-between' }}"
                            href="{{ route('password.request') }}">{{ __('Forgot your password?') }}
                        </a>
                    </div>
                    @endif

                    <button
                        class="xs:flex-shrink-0 group relative w-full h-12 mb-3 flex items-center justify-center px-4 p-px font-bold text-gray-900 bg-yellowGreen-600 rounded-lg transition-all duration-300 focus:outline-none"
                        type="submit">
                        <div
                            class="absolute top-0 left-0 w-full h-full rounded-lg ring ring-yellowGreen-900 animate-pulse group-hover:ring-0 transition duration-300">
                        </div>
                        <span>{{ __('Confirm Password') }}</span>
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>
