@php
    // Settings
    use App\Models\Setting;
    use App\Models\Config;

    $setting = Setting::where('status', 1)->first();
    $config = Config::get();

    // Selected theme
    $theme = 'classic';
    $section = 'auth.classic.login';
    $topbar = 'website.classic.includes.topbar';
    $footer = 'website.classic.includes.footer';
    if ($config[48]->config_value == '330599619570398') {
        $theme = 'modern';
        $section = 'auth.modern.login';
        $topbar = 'website.modern.includes.topbar';
        $footer = 'website.modern.includes.footer';
    }
@endphp

@extends('layouts.' . $theme)

@section('content')
{{-- Custom CSS --}}
@section('custom-css')
    <link rel="stylesheet" href="{{ asset('css/custom.css') }}">
@endsection

{{-- Topbar --}}
@if ($config[46]->config_value == "yes")
    @include($topbar)
@endif

{{-- Login section --}}
@include($section)

{{-- Footer --}}
@if ($config[46]->config_value == "yes")
    @include($footer)
@endif

{{-- Show / Hide Password --}}
@section('custom-js')
    <script>
        function showPassword() {
            "use strict";
            var temp = document.getElementById("password");
            if (temp.type === "password") {
                temp.type = "text";
            } else {
                temp.type = "password";
            }
        }
    </script>
@endsection
@endsection
