@extends('admin.layouts.app')

{{-- Custom CSS & JS --}}
@section('custom-css')
    <link rel="stylesheet" href="{{ asset('css/lightgallery.min.css') }}" />
    <script src="{{ asset('js/lightgallery.min.js') }}"></script>
    <script src="{{ asset('js/clipboard.min.js') }}"></script>
@endsection

@section('content')
    <div class="page-wrapper">
        <div class="container-fluid">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <div class="page-pretitle">
                            {{ __('Overview') }}
                        </div>
                        <h2 class="page-title">
                            {{ __('View User') }}
                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-body">
            <div class="container-fluid">
                <div class="row row-deck row-cards">
                    {{-- User details --}}
                    <div class="col-sm-12 col-lg-12">
                        <div class="card">
                            <div class="card">
                                <div class="card-body p-4 text-center">
                                    <span class="avatar avatar-xl mb-3 avatar-rounded"
                                        style="background-image: url({{ $user_details->profile_image == '' ? asset('images/profile.png') : $user_details->profile_image }})"></span>
                                    <h3 class="m-0 mb-1 text-center">{{ $user_details->name }}</h3>
                                    <div>
                                        {{ $user_details->email == '' ? __('Not Available') : $user_details->email }}</div>
                                    <div class="mt-3">
                                        <span
                                            class="badge bg-green-lt text-white">{{ $user_details->role_id == 2 ? __('Customer') : '' }}</span>
                                    </div>
                                </div>
                                <div class="d-flex">
                                    <a href="mailto:{{ $user_details->email == '' ? __('Not Available') : $user_details->email }}"
                                        class="card-btn">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon me-2" width="24"
                                            height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <rect x="3" y="5" width="18" height="14" rx="2" />
                                            <polyline points="3 7 12 13 21 7" />
                                        </svg>
                                        {{ __('Email') }}</a>
                                    <a href="#" class="card-btn"
                                        onclick="loginUser('{{ $user_details->id }}'); return false;">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                            viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path
                                                d="M14 8v-2a2 2 0 0 0 -2 -2h-7a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h7a2 2 0 0 0 2 -2v-2" />
                                            <path d="M20 12h-13l3 -3m0 6l-3 -3" />
                                        </svg>
                                        {{ __('Login via Admin') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- OPTIMIZE --}}
                    @if (env('APP_TYPE') == 'OPTIMIZE' || env('APP_TYPE') == 'BOTH')
                        <div class="col-sm-12 col-lg-12">
                            <div class="card px-2 py-1">
                                <div class="card-header">
                                    <h6 class="page-title">{{ __('Optimize Images') }}</h6>
                                </div>
                                <div class="row row-cards" id="captions">
                                    @if (!empty($optimers) && $optimers->count())
                                        {{-- Optimize Images --}}
                                        @foreach ($optimers as $optimer)
                                            <div class="col-sm-6 col-lg-3">
                                                <div class="card card-sm">
                                                    <div class="d-block">
                                                        <div class="item card-img-top img-responsive img-responsive-16by9"
                                                            data-src="{{ $optimer->optimized_image }}"
                                                            data-sub-html="<h4>{{ __('Name') }} : {{ $optimer->name }}</h4>"
                                                            style="background-image: url({{ asset($optimer->optimized_image) }})">
                                                        </div>
                                                    </div>

                                                    <div class="card-body">
                                                        <div class="d-flex align-items-center">
                                                            <div>
                                                                <div class="font-weight-bold mb-2">
                                                                    {{ strlen($optimer->name) > 20 ? substr($optimer->name, 0, 20) . '...' : $optimer->name }}
                                                                </div>
                                                                <div class="small"><small>
                                                                        {{ __('Uploaded on:') }}
                                                                        {{ formatDateForUser($optimer->created_at) }}
                                                                    </small></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="empty">
                                            <div class="empty-img"><img
                                                    src="{{ asset('images/undraw_printing_invoices_5r4r.svg') }}" width="250"
                                                    height="128" alt="">
                                            </div>
                                            <p class="empty-title">{{ __('No optimize images found') }}</p>
                                            <p class="empty-subtitle">
                                                {{ __('Try adjusting your add to find what you are looking for.') }}
                                            </p>
                                        </div>
                                    @endif

                                    {{-- Pagination --}}
                                    <div class="col-lg-12">
                                        {{ $optimers->links() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif

                </div>
            </div>
        </div>
        @include('admin.includes.footer')
    </div>

    {{-- User login modal --}}
    <div class="modal modal-blur fade" id="login-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title">{{ __('Are you sure login into the user?') }}</div>
                    <div>{{ __('Note : If you proceed, you will lose your admin session.') }}</div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary me-auto"
                        data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <a href="{{ route('admin.login-as.user', $user_details->id) }}" target="_blank"
                        class="btn btn-danger">{{ __('Yes, proceed') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- Custom JS --}}
@section('custom-js')
    <script>
        $('#captions').lightGallery({
            thumbnail: true,
            download: false,
            selector: '.item'
        });

        function loginUser(parameter) {
            "use strict";
            $("#login-modal").modal("show");
        }
    </script>
@endsection
@endsection
