@extends('admin.layouts.app')

{{-- Custom CSS --}}
@section('custom-css')
    <style>
        .code {
            background: #333 !important;
            color: #fff !important;
            font-family: monospace !important;
        }
        small {
            font-size: 12px;
            letter-spacing: 0;
        }
    </style>
@endsection

@section('content')
    <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
            <div class="container-fluid">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <h2 class="page-title">
                            {{ __('Settings') }}
                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page body -->
        <div class="page-body">
            <div class="container-fluid">
                {{-- Failed --}}
                @if (Session::has('failed'))
                    <div class="alert alert-important alert-danger alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('failed') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                {{-- Success --}}
                @if (Session::has('success'))
                    <div class="alert alert-important alert-success alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('success') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif
                <div class="card">
                    <div class="row g-0">
                        {{-- Links --}}
                        @include('admin.pages.settings.include.links', ['link' => 'website'])

                        <div class="col-12 col-md-9 d-flex flex-column">
                            <form action="{{ route('admin.change.website.settings') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <h2 class="mb-4"{{ __('Website Configuration Settings') }}</h2>
                                    <div class="row">

                                        {{-- Themes --}}
                                        <div class="col-md-12 col-xl-12">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Themes') }}</label>
                                                <div class="row g-2">
                                                    {{-- Themes --}}
                                                    @foreach ($themes as $theme)
                                                    <div class="col-6 col-sm-6">
                                                        <label class="form-imagecheck mb-2">
                                                          <input name="theme_id" type="radio" value="{{ $theme->theme_id }}" class="form-imagecheck-input" {{ $config[48]->config_value == $theme->theme_id ? "checked" : "" }} />
                                                          <span class="form-imagecheck-figure">
                                                            <img src="{{ asset($theme->cover_image) }}" alt="{{ $theme->theme_name }}" class="form-imagecheck-image">
                                                          </span>
                                                        </label>
                                                      </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Theme Colors --}}
                                        <div class="col-md-12 col-xl-12">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Theme Colors') }}</label>
                                                <div class="row g-2">
                                                    <div class="col-auto">
                                                        <label class="form-colorinput">
                                                            <input name="app_theme" type="radio" value="blue" class="form-colorinput-input" {{ $config[11]->config_value == 'blue' ? 'checked' : '' }} />
                                                            <span class="form-colorinput-color bg-blue"></span>
                                                        </label>
                                                    </div>
                                                    <div class="col-auto">
                                                        <label class="form-colorinput form-colorinput-light">
                                                            <input name="app_theme" type="radio" value="indigo" class="form-colorinput-input" {{ $config[11]->config_value == 'indigo' ? 'checked' : '' }} />
                                                            <span class="form-colorinput-color bg-indigo"></span>
                                                        </label>
                                                    </div>
                                                    <div class="col-auto">
                                                        <label class="form-colorinput">
                                                            <input name="app_theme" type="radio" value="green" class="form-colorinput-input" {{$config[11]->config_value == 'green' ? 'checked' : '' }} />
                                                            <span class="form-colorinput-color bg-green"></span>
                                                        </label>
                                                    </div>
                                                    <div class="col-auto">
                                                        <label class="form-colorinput">
                                                            <input name="app_theme" type="radio" value="yellow" class="form-colorinput-input" {{ $config[11]->config_value == 'yellow' ? 'checked' : '' }} />
                                                            <span class="form-colorinput-color bg-yellow"></span>
                                                        </label>
                                                    </div>
                                                    <div class="col-auto">
                                                        <label class="form-colorinput">
                                                            <input name="app_theme" type="radio" value="red" class="form-colorinput-input" {{ $config[11]->config_value == 'red' ? 'checked' : '' }} />
                                                            <span class="form-colorinput-color bg-red"></span>
                                                        </label>
                                                    </div>
                                                    <div class="col-auto">
                                                        <label class="form-colorinput">
                                                            <input name="app_theme" type="radio" value="purple" class="form-colorinput-input" {{ $config[11]->config_value == 'purple' ? 'checked' : '' }} />
                                                            <span class="form-colorinput-color bg-purple"></span>
                                                        </label>
                                                    </div>
                                                    <div class="col-auto">
                                                        <label class="form-colorinput">
                                                            <input name="app_theme" type="radio" value="pink" class="form-colorinput-input" {{ $config[11]->config_value == 'pink' ? 'checked' : '' }} />
                                                            <span class="form-colorinput-color bg-pink"></span>
                                                        </label>
                                                    </div>
                                                    <div class="col-auto">
                                                        <label class="form-colorinput form-colorinput-light">
                                                            <input name="app_theme" type="radio" value="gray"class="form-colorinput-input" {{ $config[11]->config_value == 'gray' ? 'checked' : '' }} />
                                                            <span class="form-colorinput-color bg-muted"></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Home Banner Image --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('Banner Image') }} <small>({{ __('Recommended size : 1000 x 667') }})</small></div>
                                                <input type="file" class="form-control" name="primary_image" placeholder="{{ __('Banner Image') }}" accept=".png,.jpg,.jpeg,.gif,.svg" />
                                            </div>
                                        </div>

                                        {{-- Website Logo --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('Website Logo') }} <small>({{ __('Recommended size : 200 x 90') }})</small></div>
                                                <input type="file" class="form-control" name="site_logo" placeholder="{{ __('Website Logo') }}" accept=".png,.jpg,.jpeg,.gif,.svg" />
                                            </div>
                                        </div>

                                        {{-- Favicon --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('Favicon') }} <small>({{ __('Recommended size : 200 x 200') }})</small></div>
                                                <input type="file" class="form-control" name="favi_icon" placeholder="{{ __('Favicon') }}" accept=".png,.jpg,.jpeg,.gif,.svg" />
                                            </div>
                                        </div>

                                        {{-- App Name --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('App Name') }}</label>
                                                <input type="text" class="form-control" name="app_name" maxlength="50" value="{{ config('app.name') }}" placeholder="{{ __('App Name') }}">
                                            </div>
                                        </div>

                                        {{-- Site Name --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Site Name') }}</label>
                                                <input type="text" class="form-control" name="site_name" maxlength="50" value="{{ $settings->site_name }}" placeholder="{{ __('Site Name') }}" required>
                                            </div>
                                        </div>

                                        @php
                                        // CSS
                                        $customCss = "";
                                        $customCss = str_replace('<style>', '', $settings->custom_css);
                                        $customCss = str_replace('</style>', '', $customCss);

                                        // JS
                                        $customJs = "";
                                        $customJs = str_replace('<script>', '', $settings->custom_js);
                                        $customJs = str_replace('</script>', '', $customJs);
                                        @endphp

                                        {{-- Custom CSS --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Custom CSS') }}</label>
                                                <textarea class="form-control code" name="custom_css" id="custom_css" cols="30" rows="5" data-bs-toggle="autosize" maxlength="25000">
                                                <style>
                                                    {{ trim($customCss) }}
                                                </style></textarea>
                                            </div>
                                        </div>

                                        {{-- Custom JS --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Custom JS') }}</label>
                                                <textarea class="form-control code" name="custom_js" id="custom_js" cols="30" rows="5" data-bs-toggle="autosize" maxlength="25000">
                                                <script>
                                                    {{ trim($customJs) }}
                                                </script></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent mt-auto">
                                    <div class="btn-list justify-content-end">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('Update') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Footer --}}
        @include('admin.includes.footer')
    </div>

    {{-- Custom JS --}}
@section('custom-js')
    <script>
        function validatePort(input) {
            "use strict";

            const maxLength = 5; // Set your desired max length
            if (input.value.length > maxLength) {
                input.value = input.value.slice(0, maxLength);
            }
        }
    </script>
@endsection
@endsection
