@extends('admin.layouts.app')

{{-- Custom CSS --}}
@section('custom-css')
    <style>
        .code {
            background: #333 !important;
            color: #fff !important;
            font-family: monospace !important;
        }
        small {
            font-size: 12px;
            letter-spacing: 0;
        }
    </style>
@endsection

@section('content')
    <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
            <div class="container-fluid">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <h2 class="page-title">
                            {{ __('Settings') }}
                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page body -->
        <div class="page-body">
            <div class="container-fluid">
                {{-- Failed --}}
                @if (Session::has('failed'))
                    <div class="alert alert-important alert-danger alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('failed') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                {{-- Success --}}
                @if (Session::has('success'))
                    <div class="alert alert-important alert-success alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('success') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif
                <div class="card">
                    <div class="row g-0">
                        {{-- Links --}}
                        @include('admin.pages.settings.include.links', ['link' => 'payments'])

                        <div class="col-12 col-md-9 d-flex flex-column">
                            <form action="{{ route('admin.change.payments.settings') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <h2 class="mb-4"{{ __('Payment Methods Configuration Settings') }}</h2>
                                    <div class="row">
                                        {{-- Paypal Settings --}}
                                        <h2 class="page-title mb-5">{{ __('Paypal Settings') }}</h2>
                                        {{-- Mode --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Mode' )}}</label>
                                                <select class="form-select" placeholder="Select a payment mode" id="select-tags-advanced" name="paypal_mode" required>
                                                    <option value="sandbox" {{ $config[3]->config_value == 'sandbox' ? 'selected' : '' }}>{{ __('Sandbox') }}</option>
                                                    <option value="live" {{ $config[3]->config_value == 'live' ? 'selected' : '' }}>{{ __('Live') }}</option>
                                                </select>
                                            </div>
                                        </div>

                                        {{-- Client Key --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Client Key') }}</label>
                                                <input type="text" class="form-control" name="paypal_client_key" value="{{ $config[4]->config_value }}" placeholder="{{ __('Client Key') }}" required>
                                            </div>
                                        </div>

                                        {{-- Secret --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label" required>{{ __('Secret') }}</label>
                                                <input type="text" class="form-control" name="paypal_secret" value="{{ $config[5]->config_value }}" placeholder="{{ __('Secret') }}" required>
                                            </div>
                                        </div>

                                        {{-- Razorpay Settings --}}
                                        <h2 class="page-title my-3">{{ __('Razorpay Settings') }}</h2>

                                        {{-- Client Key --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Client Key') }}</label>
                                                <input type="text" class="form-control" name="razorpay_client_key" value="{{ $config[6]->config_value }}" placeholder="{{ __('Client Key') }}" required>
                                            </div>
                                        </div>

                                        {{-- Secret --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Secret') }}</label>
                                                <input type="text" class="form-control" name="razorpay_secret" value="{{ $config[7]->config_value }}" placeholder="{{ __('Secret') }}" required>
                                            </div>
                                        </div>

                                        {{-- PhonePe Settings --}}
                                        <h2 class="page-title my-3">
                                            {{ __('PhonePe Settings') }}
                                        </h2>
                                        {{-- Client Key --}}
                                        <div class="col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Merchant ID')
                                                    }}</label>
                                                <input type="text" class="form-control" name="merchantId"
                                                    value="{{ $config[49]->config_value }}"
                                                    placeholder="{{ __('Merchant ID') }}" required>
                                            </div>
                                        </div>

                                        {{-- Salt Key --}}
                                        <div class="col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Salt Key') }}</label>
                                                <input type="text" class="form-control" name="saltKey"
                                                    value="{{ $config[50]->config_value }}"
                                                    placeholder="{{ __('Salt Key') }}" required>
                                            </div>
                                        </div>

                                        {{-- Stripe Settings --}}
                                        <h2 class="page-title my-3">{{ __('Stripe Settings') }}</h2>

                                        {{-- Publishable Key --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Publishable Key') }}</label>
                                                <input type="text" class="form-control" name="stripe_publishable_key" value="{{ $config[9]->config_value }}" placeholder="{{ __('Publishable Key') }}" required>
                                            </div>
                                        </div>

                                        {{-- Secret --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Secret') }}</label>
                                                <input type="text" class="form-control" name="stripe_secret" value="{{ $config[10]->config_value }}" placeholder="{{ __('Secret') }}" required>
                                            </div>
                                        </div>

                                        {{-- Paystack Settings --}}
                                        <h2 class="page-title my-3">{{ __('Paystack Settings') }}</h2>

                                        {{-- Publishable Key --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Public Key') }}</label>
                                                <input type="text" class="form-control" name="paystack_public_key" value="{{ $config[41]->config_value }}" placeholder="{{ __('Public Key') }}" required>
                                            </div>
                                        </div>

                                        {{-- Secret --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Secret Key') }}</label>
                                                <input type="text" class="form-control" name="paystack_secret" value="{{ $config[42]->config_value }}" placeholder="{{ __('Secret Key') }}" required>
                                            </div>
                                        </div>

                                        {{-- Merchant Email --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Merchant Email') }}</label>
                                                <input type="text" class="form-control" name="merchant_email" value="{{ $config[44]->config_value }}" placeholder="{{ __('Merchant Email') }}" required>
                                            </div>
                                        </div>

                                        {{-- Mollie Settings --}}
                                        <h2 class="page-title my-3">{{ __('Mollie Settings') }}</h2>

                                        {{-- Key --}}
                                        <div class="col-md-8 col-xl-8">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Key') }}</label>
                                                <input type="text" class="form-control" name="mollie_key" value="{{ $config[45]->config_value }}" placeholder="{{ __('Key') }}" required>
                                            </div>
                                        </div>

                                        {{-- Offline (Bank Transfer) Settings --}}
                                        <div class="col-md-6 col-xl-6 mt-3">
                                            <h2 class="page-title my-3">{{ __('Offline (Bank Transfer) Settings') }}</h2>
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Offline (Bank Transfer) Details') }}</label>
                                                <textarea class="form-control" name="bank_transfer" rows="3" placeholder="{{ __('Offline (Bank Transfer) Details') }}" required>{{ $config[31]->config_value }}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent mt-auto">
                                    <div class="btn-list justify-content-end">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('Update') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Footer --}}
        @include('admin.includes.footer')
    </div>

    {{-- Custom JS --}}
@section('custom-js')
    <script>
        function validatePort(input) {
            "use strict";

            const maxLength = 5; // Set your desired max length
            if (input.value.length > maxLength) {
                input.value = input.value.slice(0, maxLength);
            }
        }
    </script>
@endsection
@endsection
