@extends('admin.layouts.app')

{{-- Custom CSS --}}
@section('custom-css')
    <style>
        .code {
            background: #333 !important;
            color: #fff !important;
            font-family: monospace !important;
        }
        small {
            font-size: 12px;
            letter-spacing: 0;
        }
    </style>
@endsection

@section('content')
    <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
            <div class="container-fluid">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <h2 class="page-title">
                            {{ __('Settings') }}
                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page body -->
        <div class="page-body">
            <div class="container-fluid">
                {{-- Failed --}}
                @if (Session::has('failed'))
                    <div class="alert alert-important alert-danger alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('failed') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                {{-- Success --}}
                @if (Session::has('success'))
                    <div class="alert alert-important alert-success alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('success') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif
                <div class="card">
                    <div class="row g-0">
                        {{-- Links --}}
                        @include('admin.pages.settings.include.links', ['link' => 'optimer'])

                        <div class="col-12 col-md-9 d-flex flex-column">
                            <form action="{{ route('admin.change.optimer.settings') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <h2 class="mb-4"{{ __('Optimizer Configuration Settings') }}</h2>
                                    <div class="row">
                                        {{-- Email Configuration Settings --}}
                                        <h2 class="page-title mb-5">{{ __('Optimizer Website Configurations') }}</h2>

                                        {{-- Show Optimizer in Website? --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label required" for="optimer_enable">{{ __('Show Optimizer? (Website)') }}</label>
                                                <select name="optimer_enable" id="optimer_enable"
                                                    class="form-control" required>
                                                    <option value="1" {{ $config[34]->config_value == 1 ? ' selected' : '' }}>{{ __('Yes') }}</option>
                                                    <option value="0" {{ $config[34]->config_value == 0 ? ' selected' : '' }}>{{ __('No') }}</option>
                                                </select>
                                            </div>
                                        </div>

                                        {{-- Upload Limit (Website) --}}
                                        <div class="col-md-4 col-xl-4 mb-2">
                                            <div class="mb-3">
                                                <label class="form-label required" for="image_limit">{{ __('Upload Files Limit (Website)') }}</label>
                                                <input type="number" class="form-control" name="limit_upto" value="{{ $config[35]->config_value }}" placeholder="{{ __('Upload Files Limit (Website)') }}" min="1" required>
                                            </div>
                                        </div>

                                        {{-- Maximum upload Size (Website) --}}
                                        <div class="col-md-4 col-xl-4 mb-2">
                                            <div class="mb-3">
                                                <label class="form-label required" for="image_limit">{{ __('Maximum Upload Size in MB (Website)') }}</label>
                                                <input type="number" class="form-control" name="size_upto" value="{{ $config[36]->config_value }}" placeholder="{{ __('Maximum Upload Size in kb (Website)') }}" min="1" required>
                                            </div>
                                        </div>

                                        {{-- Maximum optimize counts for IP Address (Website) --}}
                                        <div class="col-md-6 col-xl-6 mb-2">
                                            <div class="mb-3">
                                                <label class="form-label required" for="ip_address">{{ __('Maximum optimize count for IP Address (Website)') }}</label>
                                                <input type="number" class="form-control" name="ip_address" value="{{ $config[40]->config_value }}" min="1" placeholder="{{ __('Maximum optimize count for IP Address (Website)') }}" min="1" required>
                                            </div>
                                        </div>

                                        {{-- Supported Formats (Website) --}}
                                        <div class="col-md-6 col-xl-6 mb-2">
                                            <div class="mb-3">
                                                <div class="form-label required">{{ __('Supported Formats (Website)') }}</div>
                                                <select class="form-select" name="support_types[]" multiple="" required>
                                                    <option value=".jpg" {{ in_array('.jpg', json_decode($config[37]->config_value)) ? 'selected' : '' }}>{{ __('.JPG') }}</option>
                                                    <option value=".jpeg" {{ in_array('.jpeg', json_decode($config[37]->config_value)) ? 'selected' : '' }}>{{ __('.JPEG') }}</option>
                                                    <option value=".png" {{ in_array('.png', json_decode($config[37]->config_value)) ? 'selected' : '' }}>{{ __('.PNG') }}</option>
                                                    <option value=".webp" {{ in_array('.webp', json_decode($config[37]->config_value)) ? 'selected' : '' }}>{{ __('.WEBP') }}</option>
                                                    <option value=".svg" {{ in_array('.svg', json_decode($config[37]->config_value)) ? 'selected' : '' }}>{{ __('.SVG') }}</option>
                                                    <option value=".gif" {{ in_array('.gif', json_decode($config[37]->config_value)) ? 'selected' : '' }}>{{ __('.GIF') }}</option>
                                                </select>
                                            </div>
                                        </div>

                                        {{-- Optimize Settings --}}
                                        <h2 class="page-title my-2">{{ __('Optimize Settings') }}</h2>

                                        {{-- JPG/JPEG Maximum Quality --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('JPG/JPEG Maximum Quality') }}</label>
                                                <input type="number" class="form-control" name="jpg_quality" min="1" max="100" value="{{ $config[38]->config_value }}" placeholder="{{ __('JPG/JPEG Maximum Quality') }}" required>
                                                <small>{{ __('Default : 30') }}</small><br>
                                                <small>{{ __('Images will be optimized based on the default size.') }}</small>
                                            </div>
                                        </div>

                                        {{-- SVG Maximum Quality --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('SVG Maximum Quality') }}</label>
                                                <input type="number" class="form-control" name="svg_quality" min="1" max="100" value="{{ $config[39]->config_value }}" placeholder="{{ __('SVG Maximum Quality') }}" required>
                                                <small>{{ __('Default : 50') }}</small><br>
                                                <small>{{ __('Images will be optimized based on the default size.') }}</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent mt-auto">
                                    <div class="btn-list justify-content-end">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('Update') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Footer --}}
        @include('admin.includes.footer')
    </div>

    {{-- Custom JS --}}
@section('custom-js')
    <script>
        function validatePort(input) {
            "use strict";

            const maxLength = 5; // Set your desired max length
            if (input.value.length > maxLength) {
                input.value = input.value.slice(0, maxLength);
            }
        }
    </script>
@endsection
@endsection
