@extends('admin.layouts.app')

{{-- Custom CSS --}}
@section('custom-css')
    <style>
        .code {
            background: #333 !important;
            color: #fff !important;
            font-family: monospace !important;
        }
        small {
            font-size: 12px;
            letter-spacing: 0;
        }
    </style>
@endsection

@section('content')
    <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
            <div class="container-fluid">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <h2 class="page-title">
                            {{ __('Settings') }}
                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page body -->
        <div class="page-body">
            <div class="container-fluid">
                {{-- Failed --}}
                @if (Session::has('failed'))
                    <div class="alert alert-important alert-danger alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('failed') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                {{-- Success --}}
                @if (Session::has('success'))
                    <div class="alert alert-important alert-success alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('success') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif
                <div class="card">
                    <div class="row g-0">
                        {{-- Links --}}
                        @include('admin.pages.settings.include.links', ['link' => 'google'])

                        <div class="col-12 col-md-9 d-flex flex-column">
                            <form action="{{ route('admin.change.google.settings') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <h2 class="mb-4"{{ __('Google Configuration Settings') }}</h2>
                                    <div class="row">
                                        {{-- Google reCAPTCHA Settings --}}
                                        <h2 class="page-title mb-5">{{ __('Google reCAPTCHA Configuration Settings') }}</h2>

                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('reCAPTCHA Enable') }}</div>
                                                <select class="form-select" placeholder="Select a reCAPTCHA" id="recaptcha_enable" name="recaptcha_enable">
                                                    <option value="on" {{ $settings->recaptcha_configuration['RECAPTCHA_ENABLE'] == 'on' ? 'checked' : '' }}>{{ __('On') }}</option>
                                                    <option value="off" {{ $settings->recaptcha_configuration['RECAPTCHA_ENABLE'] == 'off' ? 'checked' : '' }}>{{ __('Off') }}</option>
                                                </select>
                                            </div>
                                            <small>{{ __('If you did not get a reCAPTCHA (v2 Checkbox), create a') }}<a href="https://www.google.com/recaptcha/about/" target="_blank">{{ __('reCAPTCHA') }}</a> </small>
                                        </div>

                                        {{-- reCAPTCHA Site Key --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('reCAPTCHA Site Key') }}</label>
                                                <input type="text" class="form-control" name="recaptcha_site_key" value="{{ $settings->recaptcha_configuration['RECAPTCHA_SITE_KEY'] }}" placeholder="{{ __('reCAPTCHA Site Key') }}">
                                            </div>
                                        </div>

                                        {{-- reCAPTCHA Secret Key --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('reCAPTCHA Secret Key') }}</label>
                                                <input type="text" class="form-control" name="recaptcha_secret_key" value="{{ $settings->recaptcha_configuration['RECAPTCHA_SECRET_KEY'] }}" placeholder="{{ __('reCAPTCHA Secret Key') }}">
                                            </div>
                                        </div>

                                        {{-- Google OAuth Settings --}}
                                        <h2 class="page-title my-4">{{ __('Google OAuth Configuration Settings') }}</h2>

                                        {{-- Google Auth Enable --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('Google Auth Enable') }}</div>
                                                <select class="form-select" placeholder="Select a reCAPTCHA"
                                                    id="google_auth_enable" name="google_auth_enable">
                                                    <option value="on" {{ $settings->google_configuration['GOOGLE_ENABLE'] == 'on' ? 'checked' : '' }}>{{ __('On') }}</option>
                                                    <option value="off" {{ $settings->google_configuration['GOOGLE_ENABLE'] == 'off' ? 'checked' : '' }}>{{ __('Off') }}</option>
                                                </select>
                                            </div>
                                        </div>

                                        {{-- Google Client ID --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Google Client ID') }}</label>
                                                <input type="text" class="form-control" name="google_client_id" value="{{ $settings->google_configuration['GOOGLE_CLIENT_ID'] }}" placeholder="{{ __('Google CLIENT ID') }}">
                                            </div>
                                        </div>

                                        {{-- Google Client Secret --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Google Client Secret') }}</label>
                                                <input type="text" class="form-control" name="google_client_secret" value="{{ $settings->google_configuration['GOOGLE_CLIENT_SECRET'] }}" placeholder="{{ __('Google CLIENT Secret') }}">
                                            </div>
                                        </div>

                                        {{-- Google Redirect --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Google Redirect') }}</label>
                                                <input type="text" class="form-control" name="google_redirect" value="{{ $settings->google_configuration['GOOGLE_REDIRECT'] }}" placeholder="{{ __('Google Redirect') }}">
                                            </div>
                                        </div>
                                        <small>{{ __('If you did not get a google OAuth Client ID & Secret Key, follow a') }} <a href="https://support.google.com/cloud/answer/6158849?hl=en#zippy=%2Cuser-consent%2Cpublic-and-internal-applications%2Cauthorized-domains/" target="_blank">{{ __(' steps') }}</a> </small>

                                        {{-- Google Analytics ID --}}
                                        <div class="col-md-6 col-xl-6 mt-3">
                                            <h2 class="page-title my-3">{{ __('Google Analytics Configuration Settings') }}</h2>
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Google Analytics ID') }}</label>
                                                <input type="text" class="form-control" name="google_analytics_id" value="{{ $settings->analytics_id }}" placeholder="{{ __('Google Analytics ID') }}" required>
                                            </div>
                                            <small>{{ __('If you did not get a google analytics id, create a') }} <a href="https://analytics.google.com/analytics/web/" target="_blank">{{ __('new analytics id.') }}</a> </small>
                                        </div>

                                        {{-- Google Tag ID --}}
                                        <div class="col-md-6 col-xl-6 mt-3">
                                            <h2 class="page-title my-3">{{ __('Google Tag Manager Settings') }}</h2>
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Google Tag ID') }}</label>
                                                <input type="text" class="form-control" name="google_tag" value="{{ $settings->google_tag }}" placeholder="{{ __('Google Tag ID') }}...">
                                            </div>
                                        </div>

                                        {{-- Google AdSense --}}
                                        <div class="col-md-12 col-xl-12 mt-3">
                                            <h2 class="page-title my-3">{{ __('Google AdSense Configuration Settings') }}</h2>
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Google AdSense code') }}</label>
                                                <div class="input-group mb-2">
                                                    <span class="input-group-text">{{ __('https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=') }}</span>
                                                    <input type="text" class="form-control " name="adsense_code" value="{{ $settings->adsense_code }}" placeholder="{{ __('Google AdSense code') }}" autocomplete="off">
                                                </div>
                                                <small>{{ __("Note") }} :</small><br>
                                                <small>{{ __("Enter your AdSense code for enable AdSense") }}</small><br>
                                                <small>{{ __("Type DISABLE for disable AdSense") }}</small><br>
                                            </div>
                                            <small>{{ __('If you did not get a google adsense code, create a') }} <a href="https://www.google.com/adsense/new" target="_blank">{{ __('new adsense code.') }}</a> </small>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent mt-auto">
                                    <div class="btn-list justify-content-end">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('Update') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Footer --}}
        @include('admin.includes.footer')
    </div>

    {{-- Custom JS --}}
@section('custom-js')
    <script>
        function validatePort(input) {
            "use strict";

            const maxLength = 5; // Set your desired max length
            if (input.value.length > maxLength) {
                input.value = input.value.slice(0, maxLength);
            }
        }
    </script>
@endsection
@endsection
