@extends('admin.layouts.app')

{{-- Custom CSS --}}
@section('custom-css')
    <script type="text/javascript" src="{{ asset('js/tom-select.base.min.js') }}"></script>
    <style>
        .code {
            background: #333 !important;
            color: #fff !important;
            font-family: monospace !important;
        }
        small {
            font-size: 12px;
            letter-spacing: 0;
        }
    </style>
@endsection

@section('content')
    <div class="page-wrapper">
        <!-- Page header --> 
        <div class="page-header d-print-none">
            <div class="container-fluid">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <h2 class="page-title">
                            {{ __('Settings') }}
                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page body -->
        <div class="page-body">
            <div class="container-fluid">
                {{-- Failed --}}
                @if (Session::has('failed'))
                    <div class="alert alert-important alert-danger alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('failed') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                {{-- Success --}}
                @if (Session::has('success'))
                    <div class="alert alert-important alert-success alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('success') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif
                <div class="card">
                    <div class="row g-0">
                        {{-- Links --}}
                        @include('admin.pages.settings.include.links', ['link' => 'general'])

                        <div class="col-12 col-md-9 d-flex flex-column">
                            <form action="{{ route('admin.change.general.settings') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <h2 class="mb-4"{{ __('General Configuration Settings') }}</h2>

                                        <div class="row">
                                            {{-- Show Website Frontend? --}}
                                            <div class="col-md-4 col-xl-6">
                                                <div class="mb-3">
                                                    <label class="form-label required" for="show_website">{{ __('Show Website Frontend?') }}</label>
                                                    <select name="show_website" id="show_website" class="form-control" required>
                                                        <option value="yes" {{ $config[46]->config_value == 'yes' ? ' selected' : '' }}>{{ __('Yes') }}</option>
                                                        <option value="no" {{ $config[46]->config_value == 'no' ? ' selected' : '' }}>{{ __('No') }}</option>
                                                    </select>
                                                    <small>{{ __('If there is no website frontend, the website will automatically go to the login page.') }}</small>
                                                </div>
                                            </div>

                                            {{-- Script Type --}}
                                            <div class="col-md-4 col-xl-6">
                                                <div class="mb-3">
                                                    <label class="form-label required"
                                                        for="app_type">{{ __('Application Type') }}</label>
                                                    <select name="app_type" id="app_type" class="form-control" required>
                                                        <option value="OPTIMIZE" {{ env('APP_TYPE') == 'OPTIMIZE' ? ' selected' : '' }}>{{ __('OPTIMIZE') }}</option>
                                                    </select>
                                                </div>
                                            </div>

                                            {{-- Timezone --}}
                                            <div class="col-md-4 col-xl-6">
                                                <div class="mb-3">
                                                    <label class="form-label required" for="timezone">{{ __('Timezone') }}</label>
                                                    <select name="timezone" id="timezone" class="form-control" required>
                                                        @foreach (timezone_identifiers_list() as $timezone)
                                                            <option value="{{ $timezone }}" {{ $config[2]->config_value == $timezone ? ' selected' : '' }}>{{ $timezone }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            {{-- Currency --}}
                                            <div class="col-md-4 col-xl-6">
                                                <div class="mb-3">
                                                    <label class="form-label required" for="currency">{{ __('Currency') }}</label>
                                                    <select name="currency" id="currency" class="form-control" required>
                                                        @foreach ($currencies as $currency)
                                                        <option value="{{ $currency->iso_code }}" {{ $config[1]->config_value == $currency->iso_code ? ' selected' : '' }}>{{ $currency->name }} ({{ $currency->symbol }})</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            {{-- Currency format type --}}
                                            <div class=" col-xl-4 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label required"
                                                        for="currency_format">{{ __('Currency Format') }}</label>
                                                    <select name="currency_format" id="currency_format"
                                                        class="form-select" required>
                                                        <option value="1,234,567.89"
                                                            {{ $config[56]->config_value == '1,234,567.89' ? 'selected' : '' }}>
                                                            {{ __('1,234,567.89') }}</option>
                                                        <option value="12,34,567.89"
                                                            {{ $config[56]->config_value == '12,34,567.89' ? 'selected' : '' }}>
                                                            {{ __('12,34,567.89') }}</option>
                                                        <option value="1.234.567,89"
                                                            {{ $config[56]->config_value == '1.234.567,89' ? 'selected' : '' }}>
                                                            {{ __('1.234.567,89') }}</option>
                                                        <option value="1 234 567,89"
                                                            {{ $config[56]->config_value == '1 234 567,89' ? 'selected' : '' }}>
                                                            {{ __('1 234 567,89') }}</option>
                                                        <option value="1'234'567.89"
                                                            {{ $config[56]->config_value == "1'234'567.89" ? 'selected' : '' }}>
                                                            {{ __("1'234'567.89") }}</option>
                                                    </select>
                                                </div>
                                            </div>

                                            {{-- Currency Decimals Places --}}
                                            <div class="col-xl-4 mb-2">
                                                <div class="mb-3">
                                                    <label class="form-label required"
                                                        for="currency_decimals_place">{{ __('Decimals Places') }}</label>
                                                    <input type="number" class="form-control reduce-control"
                                                        name="currency_decimals_place" id="currency_decimals_place"
                                                        value="{{ $config[57]->config_value }}"
                                                        placeholder="{{ __('Decimals Places') }}" min="0"
                                                        step="1" max="3" required>
                                                    <small
                                                        class="text-muted">{{ __('If you don\'t need decimal vale, set 0') }}</small>
                                                </div>
                                            </div>

                                            {{-- Date Time Format --}}
                                            <div class="col-xl-6 mb-2">
                                                <div class="mb-3">
                                                    <label class="form-label required"
                                                        for="date_time_format">{{ __('Date Time Format') }}</label>
                                                    <select name="date_time_format" id="date_time_format"
                                                        class="form-select" required>
                                                        @php
                                                            $availableDateTimeFormats = getDateTimeFormats();
                                                        @endphp
                                                        @foreach ($availableDateTimeFormats as $key => $value)
                                                            <option value="{{ $key }}"
                                                                {{ $config[55]->config_value == $key ? 'selected' : '' }}>
                                                                {{ $value }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            {{-- Default Language --}}
                                            <div class="col-xl-6 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label required"
                                                        for="default_language">{{ __('Default Language') }}</label>
                                                    <select name="default_language" id="default_language"
                                                        class="form-select" required>
                                                        @php
                                                            $availableLanguages = [
                                                                'en' => __('English'),
                                                                'ar' => __('Arabic'),
                                                                'bn' => __('Bangla'),
                                                                'bg' => __('Bulgarian'),
                                                                'zh' => __('Chinese'),
                                                                'nl' => __('Dutch'),
                                                                'fr' => __('French'),
                                                                'de' => __('German'),
                                                                'hi' => __('Hindi'),
                                                                'he' => __('Hebrew'),
                                                                'hu' => __('Hungarian'),
                                                                'id' => __('Indonesian'),
                                                                'it' => __('Italian'),
                                                                'ja' => __('Japanese'),
                                                                'lt' => __('Lithuanian'),
                                                                'ms' => __('Malay'),
                                                                'pt' => __('Portuguese'),
                                                                'pl' => __('Polish'),
                                                                'ro' => __('Romanian'),
                                                                'ru' => __('Russian'),
                                                                'es' => __('Spanish'),
                                                                'si' => __('Sinhala'),
                                                                'sv' => __('Swedish'),
                                                                'ta' => __('Tamil'),
                                                                'th' => __('Thai'),
                                                                'tr' => __('Turkish'),
                                                                'ur' => __('Urdu'),
                                                                'vi' => __('Vietnamese'),
                                                            ];
                                                        @endphp

                                                        @foreach ($availableLanguages as $code => $name)
                                                            <option value="{{ $code }}"
                                                                {{ $defaultLanguage == $code ? 'selected' : '' }}>
                                                                {{ $name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            {{-- Website Languages --}}
                                            <div class="col-xl-12 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label required"
                                                        for="language">{{ __('Website Languages') }}</label>
                                                    <select name="languages[]" id="languages" class="form-select"
                                                        required multiple>
                                                        @php
                                                            $availableLanguages = [
                                                                'en' => __('English'),
                                                                'ar' => __('Arabic'),
                                                                'bn' => __('Bangla'),
                                                                'bg' => __('Bulgarian'),
                                                                'zh' => __('Chinese'),
                                                                'nl' => __('Dutch'),
                                                                'fr' => __('French'),
                                                                'de' => __('German'),
                                                                'hi' => __('Hindi'),
                                                                'he' => __('Hebrew'),
                                                                'hu' => __('Hungarian'),
                                                                'id' => __('Indonesian'),
                                                                'it' => __('Italian'),
                                                                'ja' => __('Japanese'),
                                                                'lt' => __('Lithuanian'),
                                                                'ms' => __('Malay'),
                                                                'pt' => __('Portuguese'),
                                                                'pl' => __('Polish'),
                                                                'ro' => __('Romanian'),
                                                                'ru' => __('Russian'),
                                                                'es' => __('Spanish'),
                                                                'si' => __('Sinhala'),
                                                                'sv' => __('Swedish'),
                                                                'ta' => __('Tamil'),
                                                                'th' => __('Thai'),
                                                                'tr' => __('Turkish'),
                                                                'ur' => __('Urdu'),
                                                                'vi' => __('Vietnamese'),
                                                            ];
                                                        @endphp

                                                        @foreach ($availableLanguages as $code => $name)
                                                            <option value="{{ $code }}"
                                                                @if (in_array($code, $selectedLanguages ?? [])) selected @endif>
                                                                {{ $name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            {{-- Default Plan Term Detting --}}
                                            <div class="col-md-4 col-xl-4">
                                                <h2 class="page-title my-3">
                                                    {{ __('Plan Term Settings') }}
                                                </h2>
                                                <div class="mb-3">
                                                    <label class="form-label required" for="term">{{ __('Default Plan Term') }}</label>
                                                    <select name="term" id="term" class="form-control" required>
                                                        <option value="monthly" {{ $config[8]->config_value == 'monthly' ? 'selected' : '' }}>{{ __('Monthly') }}</option>
                                                        <option value="yearly" {{ $config[8]->config_value == 'yearly' ? 'selected' : '' }}>{{ __('Yearly') }}</option>
                                                    </select>
                                                </div>
                                            </div>

                                            {{-- Cookie Consent Settings --}}
                                            <div class="col-md-4 col-xl-4">
                                                <h2 class="page-title my-3">
                                                    {{ __('Cookie Consent Settings') }}
                                                </h2>
                                                <div class="mb-3">
                                                    <label class="form-label required" for="cookie">{{ __('Cookie Consent Settings') }}</label>
                                                    <select name="cookie" id="cookie" class="form-control" required>
                                                        <option value="true" {{ $settings->image_limit['COOKIE_CONSENT_ENABLED'] == true ? ' selected' : '' }}>{{ __('Enable') }}</option>
                                                        <option value="false" {{ $settings->image_limit['COOKIE_CONSENT_ENABLED'] == false ? ' selected' : '' }}>{{ __('Disable') }}</option>
                                                    </select>
                                                </div>
                                            </div>

                                            {{-- Default Image Upload Limit --}}
                                            <div class="col-md-4 col-xl-4 mb-2">
                                                <h2 class="page-title my-3">
                                                    {{ __('Image Upload Limit') }}
                                                </h2>
                                                <div class="mb-3">
                                                    <label class="form-label" for="image_limit">{{ __('Size') }}</label>
                                                    <input type="number" class="form-control" name="image_limit" value="{{ $settings->image_limit['SIZE_LIMIT'] }}" placeholder="{{ __('Size') }}" min="1024">
                                                </div>
                                            </div>

                                            {{-- Tawk Chat Settings --}}
                                            <div class="col-md-6 col-xl-6">
                                                <h2 class="page-title my-3">
                                                    {{ __('Tawk Chat Settings') }}
                                                </h2>
                                                <div class="mb-3">
                                                    <label class="form-label">{{ __('Tawk Chat URL (s1.src)') }}</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">{{ __('https://embed.tawk.to/') }}</span>
                                                        <input type="text" class="form-control" name="tawk_chat_bot_key" value="{{ $settings->tawk_chat_key }}" placeholder="{{ __('Tawk Chat Key') }}" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                </div>
                                <div class="card-footer bg-transparent mt-auto">
                                    <div class="btn-list justify-content-end">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('Update') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Footer --}}
        @include('admin.includes.footer')
    </div>

    {{-- Custom JS --}}
@section('custom-js')
    <script>
        function validatePort(input) {
            "use strict";

            const maxLength = 5; // Set your desired max length
            if (input.value.length > maxLength) {
                input.value = input.value.slice(0, maxLength);
            }
        }
    </script>
    <script>
        tinymce.init({
            selector: 'textarea#bank_transfer',
            plugins: 'code preview importcss searchreplace autolink autosave save directionality visualblocks visualchars link table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
            menubar: 'file edit view insert format tools table help',
            toolbar: 'undo redo | bold italic underline strikethrough | fontfamily fontsize blocks | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | pagebreak | link',
            toolbar_sticky: true,
            height: 200,
            menubar: false,
            statusbar: false,
            autosave_interval: '30s',
            autosave_prefix: '{path}{query}-{id}-',
            autosave_restore_when_empty: false,
            autosave_retention: '2m',
            content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }',
        });
    </script>
    <script>
        // Array of element IDs
        var elementSelectors = ['show_website', 'registration_page', 'show_home_slider', 'timezone', 'languages',
            'date_time_format', 'default_language', 'currency', 'currency_format', 'term', 'cookie',
            'show_whatsapp_chatbot', 'paypal_mode', 'toyyibpay_mode', 'paddle_environment', 'paytr_mode',
            'recaptcha_enable', 'google_auth_enable', 'mail_encryption', 'disable_user_email_verification',
            'enable_subdomain', 'maintenance_mode'
        ];

        // Function to initialize TomSelect and enforce the "required" attribute
        function initializeTomSelectWithRequired(el) {
            new TomSelect(el, {
                copyClassesToDropdown: false,
                dropdownClass: 'dropdown-menu ts-dropdown',
                optionClass: 'dropdown-item',
                controlInput: '<input>',
                maxOptions: null,
                render: {
                    item: function(data, escape) {
                        if (data.customProperties) {
                            return '<div><span class="dropdown-item-indicator">' + data.customProperties +
                                '</span>' + escape(data.text) + '</div>';
                        }
                        return '<div>' + escape(data.text) + '</div>';
                    },
                    option: function(data, escape) {
                        if (data.customProperties) {
                            return '<div><span class="dropdown-item-indicator">' + data.customProperties +
                                '</span>' + escape(data.text) + '</div>';
                        }
                        return '<div>' + escape(data.text) + '</div>';
                    },
                },
            });

            // Ensure the "required" attribute is enforced
            el.addEventListener('change', function() {
                if (el.value) {
                    el.setCustomValidity('');
                } else {
                    el.setCustomValidity('This field is required');
                }
            });

            // Trigger validation on load
            el.dispatchEvent(new Event('change'));
        }

        // Loop through each element ID
        elementSelectors.forEach(function(id) {
            // Check if the element exists
            var el = document.getElementById(id);
            if (el) {
                // Apply TomSelect and enforce the "required" attribute
                initializeTomSelectWithRequired(el);
            }
        });
    </script>
@endsection
@endsection
