@extends('admin.layouts.app')

{{-- Custom CSS --}}
@section('custom-css')
    <style>
        .code {
            background: #333 !important;
            color: #fff !important;
            font-family: monospace !important;
        }
        small {
            font-size: 12px;
            letter-spacing: 0;
        }
    </style>
@endsection

@section('content')
    <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
            <div class="container-fluid">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <h2 class="page-title">
                            {{ __('Settings') }}
                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page body -->
        <div class="page-body">
            <div class="container-fluid">
                {{-- Failed --}}
                @if (Session::has('failed'))
                    <div class="alert alert-important alert-danger alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('failed') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                {{-- Success --}}
                @if (Session::has('success'))
                    <div class="alert alert-important alert-success alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('success') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif
                <div class="card">
                    <div class="row g-0">
                        {{-- Links --}}
                        @include('admin.pages.settings.include.links', ['link' => 'email'])

                        <div class="col-12 col-md-9 d-flex flex-column">
                            <form action="{{ route('admin.change.email.settings') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <h2 class="mb-4"{{ __('Email Configuration Settings') }}</h2>
                                    <div class="row">
                                        {{-- Email Configuration Settings --}}
                                        <h2 class="page-title mb-5">{{ __('Email Configurations') }}</h2>

                                        {{-- Sender Name --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Sender Name') }}</label>
                                                <input type="text" class="form-control" name="mail_sender" value="{{ $settings->email_configuration['name'] }}" placeholder="{{ __('Sender Name') }}">
                                            </div>
                                        </div>

                                        {{-- Sender Email Address --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Sender Email Address') }}</label>
                                                <input type="text" class="form-control" name="mail_address" value="{{ $settings->email_configuration['address'] }}" placeholder="{{ __('Sender Email Address') }}">
                                            </div>
                                        </div>

                                        {{-- Mailer Driver --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Mailer Driver') }}</label>
                                                <input type="text" class="form-control" name="mail_driver" value="{{ $settings->email_configuration['driver'] }}" placeholder="{{ __('Mailer Driver') }}">
                                            </div>
                                        </div>

                                        {{-- Mailer Host --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Mailer Host') }}</label>
                                                <input type="text" class="form-control" name="mail_host" value="{{ $settings->email_configuration['host'] }}" placeholder="{{ __('Mailer Host') }}">
                                            </div>
                                        </div>

                                        {{-- Mailer Port --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Mailer Port') }}</label>
                                                <input type="number" class="form-control" name="mail_port" oninput="validatePort(this)" maxlength="4" value="{{ $settings->email_configuration['port'] }}" placeholder="{{ __('Mailer Port') }}">
                                            </div>
                                        </div>

                                        {{-- Mailer Encryption --}}
                                        <div class=" col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label" for="mail_encryption">{{ __('Mailer Encryption') }}</label>
                                                <select name="mail_encryption" id="mail_encryption" class="form-control">
                                                    <option value="tls" {{ $settings->email_configuration['encryption'] == 'tls' ? 'selected' : '' }}>{{ __('TLS/STARTTLS') }}</option>
                                                    <option value="ssl" {{ $settings->email_configuration['encryption'] == 'ssl' ? 'selected' : '' }}>{{ __('SSL') }}</option>
                                                </select>
                                            </div>
                                        </div>

                                        {{-- Mailer Username --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Mailer Username') }}</label>
                                                <input type="text" class="form-control" name="mail_username" maxlength="50" value="{{ $settings->email_configuration['username'] }}" placeholder="{{ __('Mailer Username') }}">
                                            </div>
                                        </div>

                                        {{-- Mailer Password --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ __('Mailer Password') }}</label>
                                                <input type="password" class="form-control" name="mail_password" value="{{ $settings->email_configuration['password'] }}" placeholder="{{ __('Mailer Password') }}">
                                            </div>
                                        </div>

                                        {{-- Test Mail --}}
                                        <div class="col-md-4 col-xl-4 mt-3">
                                            <div class="mb-3">
                                                <label class="form-label"></label>
                                                <a href="{{ route('admin.test.email') }}" class="btn btn-primary">{{ __('Test Mail') }}</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent mt-auto">
                                    <div class="btn-list justify-content-end">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('Update') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Footer --}}
        @include('admin.includes.footer')
    </div>

    {{-- Custom JS --}}
@section('custom-js')
    <script>
        function validatePort(input) {
            "use strict";

            const maxLength = 5; // Set your desired max length
            if (input.value.length > maxLength) {
                input.value = input.value.slice(0, maxLength);
            }
        }
    </script>
@endsection
@endsection
