@extends('admin.layouts.app')

{{-- Custom CSS --}}
@section('custom-css')
    <style>
        .code {
            background: #333 !important;
            color: #fff !important;
            font-family: monospace !important;
        }
        small {
            font-size: 12px;
            letter-spacing: 0;
        }
    </style>
@endsection

@section('content')
    <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
            <div class="container-fluid">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <h2 class="page-title">
                            {{ __('Settings') }}
                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page body -->
        <div class="page-body">
            <div class="container-fluid">
                {{-- Failed --}}
                @if (Session::has('failed'))
                    <div class="alert alert-important alert-danger alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('failed') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                {{-- Success --}}
                @if (Session::has('success'))
                    <div class="alert alert-important alert-success alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('success') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif
                <div class="card">
                    <div class="row g-0">
                        {{-- Links --}}
                        @include('admin.pages.settings.include.links', ['link' => 'backblaze'])

                        <div class="col-12 col-md-9 d-flex flex-column">
                            <form action="{{ route('admin.change.backblaze.s3.settings') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <h2 class="mb-4"{{ __('Backblaze Configuration Settings') }}</h2>
                                    <div class="row">
                                        {{-- Backblaze Configuration Settings --}}
                                        <h2 class="page-title mb-5">{{ __('Backblaze Configurations') }}</h2>

                                        {{-- Enable Backblaze? --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label" for="backblaze_enable">{{ __('Backblaze') }}</label>
                                                <select name="backblaze_enable" id="backblaze_enable" class="form-control">
                                                    <option value="on" {{ env('BACK_ENABLE')=='on' ? ' selected' : '' }}>{{ __('Enable') }}</option>
                                                    <option value="off" {{ env('BACK_ENABLE')=='off' ? ' selected' : '' }}>{{ __('Disable') }}</option>
                                                </select>
                                            </div>
                                        </div>

                                        {{-- Access Key ID --}}
                                        <div class="col-md-4 col-xl-4 mb-2">
                                            <div class="mb-3">
                                                <label class="form-label" for="backblaze_access_key">{{ __('Access Key ID') }}</label>
                                                <input type="text" class="form-control" name="backblaze_access_key" value="{{ env('BACK_ACCESS_KEY_ID') }}" placeholder="{{ __('Access Key ID (Eg: 5TF****************)') }}">
                                            </div>
                                        </div>

                                        {{-- Secret Access Key --}}
                                        <div class="col-md-4 col-xl-4 mb-2">
                                            <div class="mb-3">
                                                <label class="form-label" for="backblaze_secret_key">{{ __('Secret Access Key') }}</label>
                                                <input type="text" class="form-control" name="backblaze_secret_key" value="{{ env('BACK_SECRET_ACCESS_KEY') }}" placeholder="{{ __('Secret Access Key (Eg: 51w9************************)') }}">
                                            </div>
                                        </div>

                                        {{-- Default Region --}}
                                        <div class="col-md-4 col-xl-4 mb-2">
                                            <div class="mb-3">
                                                <label class="form-label" for="backblaze_default_region">{{ __('Access Region') }}</label>
                                                <input type="text" class="form-control" name="backblaze_default_region" value="{{ env('BACK_DEFAULT_REGION') }}" placeholder="{{ __('Default Region (Eg: ap-east-1)') }}">
                                            </div>
                                        </div>

                                        {{-- Bucket --}}
                                        <div class="col-md-4 col-xl-4 mb-2">
                                            <div class="mb-3">
                                                <label class="form-label" for="backblaze_bucket">{{ __('Bucket') }}</label>
                                                <input type="text" class="form-control" name="backblaze_bucket" value="{{ env('BACK_BUCKET') }}" placeholder="{{ __('Bucket (Eg: ap-east-1)') }}">
                                            </div>
                                        </div>

                                        {{-- End point --}}
                                        <div class="col-md-4 col-xl-4 mb-2">
                                            <div class="mb-3">
                                                <label class="form-label" for="wasabi_end_point">{{ __('Endpoint') }}</label>
                                                <input type="text" class="form-control" name="wasabi_end_point" value="{{ env('BACK_ENDPOINT') }}" placeholder="{{ __('Bucket (Eg: https://s1.ap-east-1.backblazeb2.com)') }}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent mt-auto">
                                    <div class="btn-list justify-content-end">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('Update') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Footer --}}
        @include('admin.includes.footer')
    </div>

    {{-- Custom JS --}}
@section('custom-js')
    <script>
        function validatePort(input) {
            "use strict";

            const maxLength = 5; // Set your desired max length
            if (input.value.length > maxLength) {
                input.value = input.value.slice(0, maxLength);
            }
        }
    </script>
@endsection
@endsection
