@extends('admin.layouts.app')

{{-- Custom CSS --}}
@section('custom-css')
    <style>
        .code {
            background: #333 !important;
            color: #fff !important;
            font-family: monospace !important;
        }
        small {
            font-size: 12px;
            letter-spacing: 0;
        }
    </style>
@endsection

@section('content')
    <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
            <div class="container-fluid">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <h2 class="page-title">
                            {{ __('Settings') }}
                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page body -->
        <div class="page-body">
            <div class="container-fluid">
                {{-- Failed --}}
                @if (Session::has('failed'))
                    <div class="alert alert-important alert-danger alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('failed') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                {{-- Success --}}
                @if (Session::has('success'))
                    <div class="alert alert-important alert-success alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('success') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif
                <div class="card">
                    <div class="row g-0">
                        {{-- Links --}}
                        @include('admin.pages.settings.include.links', ['link' => 'aws'])
                        
                        <div class="col-12 col-md-9 d-flex flex-column">
                            <form action="{{ route('admin.change.aws.s3.settings') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <h2 class="mb-4"{{ __('AWS Configuration Settings') }}</h2>
                                    <div class="row">
                                        {{-- AWS Configuration Settings --}}
                                        <h2 class="page-title mb-5">{{ __('AWS Configurations') }}</h2>

                                        {{-- Enable AWS? --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label" for="aws_enable">{{ __('AWS') }}</label>
                                                <select name="aws_enable" id="aws_enable" class="form-control">
                                                    <option value="on" {{ env('AWS_ENABLE')=='on' ? ' selected' : '' }}>{{ __('Enable') }}</option>
                                                    <option value="off" {{ env('AWS_ENABLE')=='off' ? ' selected' : '' }}>{{ __('Disable') }}</option>
                                                </select>
                                            </div>
                                        </div>

                                        {{-- Access Key ID --}}
                                        <div class="col-md-4 col-xl-4 mb-2">
                                            <div class="mb-3">
                                                <label class="form-label" for="aws_access_key">{{ __('Access Key ID') }}</label>
                                                <input type="text" class="form-control" name="aws_access_key" value="{{ env('AWS_ACCESS_KEY_ID') }}" placeholder="{{ __('Access Key ID (Eg: AKI****************)') }}">
                                            </div>
                                        </div>

                                        {{-- Secret Access Key --}}
                                        <div class="col-md-4 col-xl-4 mb-2">
                                            <div class="mb-3">
                                                <label class="form-label" for="aws_secret_key">{{ __('Secret Access Key') }}</label>
                                                <input type="text" class="form-control" name="aws_secret_key" value="{{ env('AWS_SECRET_ACCESS_KEY') }}" placeholder="{{ __('Secret Access Key (Eg: RYaA********/E****************)') }}">
                                            </div>
                                        </div>

                                        {{-- Default Region --}}
                                        <div class="col-md-4 col-xl-4 mb-2">
                                            <div class="mb-3">
                                                <label class="form-label" for="aws_default_region">{{ __('Access Region') }}</label>
                                                <input type="text" class="form-control" name="aws_default_region" value="{{ env('AWS_DEFAULT_REGION') }}" placeholder="{{ __('Default Region (Eg: ap-east-1)') }}">
                                            </div>
                                        </div>

                                        {{-- Bucket --}}
                                        <div class="col-md-4 col-xl-4 mb-2">
                                            <div class="mb-3">
                                                <label class="form-label" for="aws_bucket">{{ __('Bucket') }}</label>
                                                <input type="text" class="form-control" name="aws_bucket" value="{{ env('AWS_BUCKET') }}" placeholder="{{ __('Bucket (Eg: ap-east-1)') }}">
                                            </div>
                                        </div>

                                        {{-- Use Path Style Endpoint --}}
                                        <div class="col-md-4 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label" for="optimer_enable">{{ __('Use Path Style Endpoint') }}</label>
                                                <select name="aws_end_point" id="aws_end_point" class="form-control">
                                                    <option value="true" {{ env('AWS_USE_PATH_STYLE_ENDPOINT')== true ? ' selected' : '' }}>{{ __('true') }}</option>
                                                    <option value="false" {{ env('AWS_USE_PATH_STYLE_ENDPOINT')== false ? ' selected' : '' }}>{{ __('false') }}</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent mt-auto">
                                    <div class="btn-list justify-content-end">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('Update') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Footer --}}
        @include('admin.includes.footer')
    </div>

    {{-- Custom JS --}}
@section('custom-js')
    <script>
        function validatePort(input) {
            "use strict";

            const maxLength = 5; // Set your desired max length
            if (input.value.length > maxLength) {
                input.value = input.value.slice(0, maxLength);
            }
        }
    </script>
@endsection
@endsection
