@extends('admin.layouts.app')

@section('content')
<div class="page-wrapper">
    <div class="container-fluid">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        {{ __('Overview') }}
                    </div>
                    <h2 class="page-title">
                        {{ __('Edit Plan') }}
                    </h2>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-fluid">
            <div class="row row-deck row-cards">
                {{-- Update Plan --}}
                <div class="col-sm-12 col-lg-12">
                    <form action="{{ route('admin.update.plan') }}" method="post" class="card">
                        @csrf

                        {{-- Failed --}}
                        @if (Session::has("failed"))
                        <div class="alert alert-important alert-danger alert-dismissible" role="alert">
                            <div class="d-flex">
                                <div>
                                    {{Session::get('failed')}}
                                </div>
                            </div>
                            <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                        </div>
                        @endif

                        {{-- Success --}}
                        @if(Session::has("success"))
                        <div class="alert alert-important alert-success alert-dismissible" role="alert">
                            <div class="d-flex">
                                <div>
                                    {{Session::get('success')}}
                                </div>
                            </div>
                            <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                        </div>
                        @endif

                        <div class="card-header">
                            <h4 class="page-title">{{ __('Plan Details') }}</h4>
                        </div>
                        <div class="card-body">

                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="row">
                                        <input type="hidden" class="form-control" name="plan_id"
                                            placeholder="{{ __('Plan ID') }}" value="{{ $plan_details->id }}"
                                            readonly>

                                        {{-- Recommended --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('Recommended') }}</div>
                                                <label class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" name="recommended"
                                                        {{ $plan_details->recommended == 1 ? 'checked' : '' }}>
                                                </label>
                                            </div>
                                        </div>

                                        {{-- Private Plan --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('Private Plan') }}</div>
                                                <label class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" name="is_private" {{
                                                        $plan_details->is_private == 1 ? 'checked' : '' }}>
                                                </label>
                                                <small>{{ __('This plan does not show on the customer page. Only the admin panel can assign this plan to the customer.') }} </small>
                                            </div>
                                        </div>

                                        {{-- Plan Name --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Plan Name') }}</label>
                                                <input type="text" class="form-control" name="name"
                                                    placeholder="{{ __('Plan Name') }}"
                                                    value="{{ $plan_details->name }}" required>
                                            </div>
                                        </div>

                                        {{-- Plan Description --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Description') }}</label>
                                                <textarea class="form-control" name="description" rows="3"
                                                    placeholder="{{ __('Description') }}.."
                                                    required>{{ $plan_details->description }}</textarea>

                                            </div>
                                        </div>

                                        {{-- Plan Pricing --}}
                                        <h2 class="page-title my-3">
                                            {{ __('Plan Prices') }}
                                        </h2>
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Price') }} <span>({{ __('For free: 0, forever: 9999')
                                                        }})</span></label>
                                                <input type="number" class="form-control" name="price" min="0"
                                                    step="0.01" placeholder="{{ __('Price') }}"
                                                    value="{{ $plan_details->price }}" required>
                                            </div>
                                        </div>

                                        {{-- Validity --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Validity') }} <span>({{ __('Enter no. of days') }})
                                                        ({{ __('For forever: 9999') }})</span></label>
                                                <input type="number" class="form-control" name="validity" min="1"
                                                    max="9999" placeholder="{{ __('Validity') }}"
                                                    value="{{ $plan_details->validity }}" required>
                                            </div>
                                        </div>

                                        {{-- Plan Features --}}
                                        <h2 class="page-title my-3">
                                            {{ __('Plan Features') }}
                                        </h2>

                                        {{-- Formats --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Formats') }}</label>
                                                <input type="number" class="form-control" name="formats" min="1" max="5"
                                                    placeholder="{{ __('Formats') }}"
                                                    value="{{ $plan_details->formats }}" required>
                                            </div>
                                        </div>

                                        {{-- No. Of Optimize Images --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('No. Of Optimize Images') }}
                                                    <span>({{ __('For unlimited: 9999')
                                                        }})</span></label>
                                                <input type="number" class="form-control" name="maximum" min="1"
                                                    max="9999" placeholder="{{ __('No. Of Optimize Images') }}"
                                                    value="{{ $plan_details->maximum }}" required>
                                            </div>
                                        </div>

                                        {{-- Maximum Upload Size --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Upload Limit') }}</label>
                                                <input type="number" class="form-control" name="size"
                                                    oninput="formatBytesToMb(this.value)" step="512"
                                                    placeholder="{{ __('Upload Limit') }}"
                                                    value="{{ $plan_details->size }}" required>
                                                <span class="text-primary mb-2" id="uploadLimit"></span><br>
                                                <span class="text-primary mb-2">{{ __('Ex: 1MB * 1024 * 1024') }} </span>
                                            </div>
                                        </div>

                                        {{-- Storage --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required">{{ __('Storage') }}</label>
                                                <input type="number" class="form-control" name="storage"
                                                    oninput="formatMbToGb(this.value)" step="512"
                                                    placeholder="{{ __('Storage') }}"
                                                    value="{{ $plan_details->storage }}" required>
                                                <span class="text-primary mb-2" id="storageLimit"></span><br>
                                                <span class="text-primary mb-2">{{ __('Ex: 1GB * 1024 * 1024 * 1024') }} </span>
                                            </div>
                                        </div>

                                        {{-- Conversation APIs --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('Conversation APIs') }}</div>
                                                <label class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" name="api" id="api" {{
                                                        $plan_details->api ==
                                                    1 ? 'checked' : '' }}>
                                                </label>
                                            </div>
                                        </div>

                                        {{-- APIs Request --}}
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label {{ $plan_details->api == 1 ? 'required' : '' }}" id="limitLable">{{ __('APIs Request') }}</label>
                                                <input type="number" class="form-control" name="limit" id="limit" min="0" value="{{ $plan_details->limit != 0 ? $plan_details->limit : '' }}"
                                                    placeholder="{{ __('APIs Request') }}" {{ $plan_details->api == 1 ? 'required' : '' }}">
                                            </div>
                                        </div>

                                        {{-- Cloud Storage (S3) --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('Cloud Storage (S3)') }}</div>
                                                <label class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" {{
                                                        $plan_details->s3 == 1 ? 'checked' : '' }} name="s3">
                                                </label>
                                            </div>
                                        </div>

                                        {{-- PNG --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('PNG') }}</div>
                                                <label class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" {{
                                                        $plan_details->png ==
                                                    1 ? 'checked' : '' }} name="png">
                                                </label>
                                            </div>
                                        </div>

                                        {{-- JPG --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('JPG') }}</div>
                                                <label class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" {{
                                                        $plan_details->jpg ==
                                                    1 ? 'checked' : '' }} name="jpg">
                                                </label>
                                            </div>
                                        </div>

                                        {{-- SVG --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('SVG') }}</div>
                                                <label class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" {{
                                                        $plan_details->svg ==
                                                    1 ? 'checked' : '' }} name="svg">
                                                </label>
                                            </div>
                                        </div>

                                        {{-- WEBP --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('WEBP') }}</div>
                                                <label class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" {{
                                                        $plan_details->webp ==
                                                    1 ? 'checked' : '' }} name="webp">
                                                </label>
                                            </div>
                                        </div>

                                        {{-- GIF --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('GIF') }}</div>
                                                <label class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" {{
                                                        $plan_details->gif ==
                                                    1 ? 'checked' : '' }} name="gif">
                                                </label>
                                            </div>
                                        </div>

                                        {{-- Daily Usage Statistics --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('Daily Usage Statistics') }}</div>
                                                <label class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" {{
                                                        $plan_details->statistics ==
                                                    1 ? 'checked' : '' }}
                                                    name="statistics">
                                                </label>
                                            </div>
                                        </div>

                                        {{-- Media Library --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('Media Library') }}</div>
                                                <label class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" {{
                                                        $plan_details->media_library ==
                                                    1 ? 'checked' : '' }}
                                                    name="media_library">
                                                </label>
                                            </div>
                                        </div>

                                        {{-- Additional Tools --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('Additional Tools') }}</div>
                                                <label class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" {{
                                                        $plan_details->additional_tools ==
                                                    1 ? 'checked' : '' }}
                                                    name="additional_tools">
                                                </label>
                                            </div>
                                        </div>

                                        {{-- Support --}}
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <div class="form-label">{{ __('Support') }}</div>
                                                <label class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" name="support" {{
                                                        $plan_details->support == 1 ? 'checked' : '' }}>
                                                </label>
                                            </div>
                                        </div>

                                        <div class="text-end">
                                            <div class="d-flex">
                                                <button type="submit" class="btn btn-primary btn-md ms-auto">
                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                        class="icon icon-tabler icon-tabler-edit" width="24" height="24"
                                                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                                        fill="none" stroke-linecap="round" stroke-linejoin="round">
                                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                                        <path
                                                            d="M9 7h-3a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-3">
                                                        </path>
                                                        <path d="M9 15h3l8.5 -8.5a1.5 1.5 0 0 0 -3 -3l-8.5 8.5v3">
                                                        </path>
                                                        <line x1="16" y1="5" x2="19" y2="8"></line>
                                                    </svg>
                                                    {{ __('Update') }}
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    {{-- Footer --}}
    @include('admin.includes.footer')
</div>

{{-- Custom JS --}}
@section('custom-js')
<script>
    // Default Size & storage
    formatBytesToMb(`{{ $plan_details->size }}`);
    formatMbToGb(`{{ $plan_details->storage }}`);

    // Bytes to mb
    function formatBytesToMb(bytes, decimals = 2) {
        if (!+bytes) return '0 Bytes';

        const k = 1024;
        const dm = decimals < 0 ? 0 : decimals;
        const sizes = ['Bytes', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];

        const i = Math.floor(Math.log(bytes) / Math.log(k));

        const uploadLimit = `${parseFloat((bytes / Math.pow(k, i)).toFixed(dm))} ${sizes[i]}`;
        $('#uploadLimit').html(`{{ __('Conversions : ') }}`+bytes+`{{ __(' Bytes = ') }}`+uploadLimit);
    }

    // Mb to GB
    function formatMbToGb(bytes, decimals = 2) {
        if (!+bytes) return '0 Bytes';

        const k = 1024;
        const dm = decimals < 0 ? 0 : decimals;
        const sizes = ['Bytes', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];

        const i = Math.floor(Math.log(bytes) / Math.log(k));

        const storageLimit = `${parseFloat((bytes / Math.pow(k, i)).toFixed(dm))} ${sizes[i]}`;
        $('#storageLimit').html(`{{ __('Conversions : ') }}`+bytes+`{{ __(' Bytes = ') }}`+storageLimit);
    }

    // Check limit
    $(function () {
        $("#api").click(function () {
            if ($(this).is(":checked")) {
                $("#limitLable").addClass('required');
                $("#limit").prop('required',true);
                $("#limit").val(`{{ $plan_details->limit }}`);
            } else {
                $("#limitLable").removeClass('required');
                $("#limit").prop('required',false);
                $("#limit").val('');
            }
        });
    });
</script>
@endsection
@endsection