@extends('admin.layouts.app')

{{-- Custom CSS --}}
@section('custom-css')
    <!-- include libraries(jQuery, bootstrap) -->
    <link rel="stylesheet" href="{{ asset('css/editor.css') }}">
    <script src="{{ asset('js/bootstrap.min.js') }}"></script>

    <!-- include summernote css/js -->
    <link href="{{ asset('css/summernote.min.css') }}" rel="stylesheet">
    <script src="{{ asset('js/summernote.min.js') }}"></script>
    <script src="{{ asset('js/script.js') }}"></script>

<style>
button.note-btn {
    padding: 5px 10px !important;
}
</style>
@endsection

@section('content')
    <div class="page-wrapper">
        <div class="container-fluid">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <div class="page-pretitle">
                            {{ __('Overview') }}
                        </div>
                        <h2 class="page-title">
                            {{ __('Edit Page') }}
                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-body">
            <div class="container-fluid">

                {{-- Error --}}
                <div class="alert alert-important alert-danger alert-dismissible d-none" role="alert" id="fillError">
                    <div class="d-flex">
                        <div>
                            {{ __('Fill the all the required fields') }}
                        </div>
                    </div>
                    <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                </div>

                {{-- Failed --}}
                @if (Session::has('failed'))
                    <div class="alert alert-important alert-danger alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('failed') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                {{-- Success --}}
                @if (Session::has('success'))
                    <div class="alert alert-important alert-success alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('success') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                <div class="row row-deck row-cards">
                    {{-- Update page --}}
                    <div class="col-sm-12 col-lg-12">
                        <form action="{{ route('admin.update.custom.page') }}" method="post" enctype="multipart/form-data"
                            class="card" id="customPageForm">
                            @csrf
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-xl-12">
                                        <div class="row">

                                            <input type="hidden" class="form-control" value="{{ $page->id }}"
                                                name="page_id" required />

                                            {{-- Title --}}
                                            <div class="col-md-6 col-xl-6">
                                                <div class="mb-3">
                                                    <div class="form-label required">{{ __('Title') }}</div>
                                                    <input type="text" class="form-control" name="title"
                                                        value="{{ $page->title }}" placeholder="{{ __('Title') }}"
                                                        required />
                                                </div>
                                            </div>

                                            {{-- Slug --}}
                                            <div class="col-md-6 col-xl-6">
                                                <div class="mb-3">
                                                    <div class="form-label required">{{ __('Slug') }}</div>
                                                    <input type="text" class="form-control" name="slug"
                                                        value="{{ $page->slug }}" placeholder="{{ __('Slug') }}"
                                                        required />
                                                </div>
                                            </div>

                                            {{-- Body --}}
                                            <div class="col-md-12 col-xl-12">
                                                <div class="mb-3">
                                                    <div class="form-label required">{{ __('Body') }}</div>
                                                    <textarea name="body" id="body" cols="30" rows="5" class="form-control"
                                                        placeholder="{{ __('Body') }}" required>{{ $page->body }}</textarea>
                                                </div>
                                            </div>

                                            <h2 class="page-title mt-3 mb-3">
                                                {{ __('SEO Configurations') }}
                                            </h2>

                                            {{-- Meta Title --}}
                                            <div class="col-md-6 col-xl-6">
                                                <div class="mb-3">
                                                    <label class="form-label required">{{ __('Title') }}</label>
                                                    <textarea class="form-control" name="meta_title" rows="2" placeholder="{{ __('Title') }}" required>{{ $page->meta_title }}</textarea>
                                                </div>
                                            </div>

                                            {{-- Meta Description --}}
                                            <div class="col-md-12 col-xl-12">
                                                <div class="mb-3">
                                                    <div class="form-label required">{{ __('Description') }}</div>
                                                    <textarea name="meta_description" id="meta_description" cols="30" rows="2" class="form-control"
                                                        placeholder="{{ __('Description') }}" required>{{ $page->description }}</textarea>
                                                </div>
                                            </div>

                                            {{-- Keywords --}}
                                            <div class="col-md-12 col-xl-12">
                                                <div class="mb-3">
                                                    <label class="form-label">{{ __('Keywords') }}</label>
                                                    <textarea class="form-control required" name="meta_keywords" rows="2"
                                                        placeholder="{{ __('Keywords (Keyword 1, Keyword 2)') }}" required>{{ $page->keywords }}</textarea>
                                                </div>
                                            </div>

                                            <div class="text-end">
                                                <div class="d-flex">
                                                    <button type="submit" class="btn btn-primary btn-md ms-auto">
                                                        {{ __('Update') }}
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        {{-- Footer --}}
        @include('admin.includes.footer')
    </div>

    {{-- Custom JS --}}
@section('custom-js')
    <script>
        $(document).ready(function() {
            "use strict";
            $('#body').summernote({
                dialogsInBody: true,
                dialogsFade: false,
                codeviewFilter: true,
                codeviewIframeFilter: true,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['fontname', ['fontname']],
                    ['fontsize', ['fontsize']],
                    ['height', ['height']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['picture', 'video']],
                    ['view', ['codeview']],
                ],
            });

            $('.codeview').on('click', function() {
                "use strict";
                if ($('#body').summernote('codeview.isActivated')) {
                    $('#body').summernote('codeview.deactivate');
                    prevent();
                }
            });
        });


        $('#customPageForm').on('submit', function(e) {
            "use strict";
            if ($('#body').summernote('isEmpty')) {
                $('#fillError').attr("class", "alert alert-important alert-danger alert-dismissible");
                e.preventDefault();
            }
        })
    </script>
@endsection
@endsection
