@extends('admin.layouts.app')

@php
    // Byte conversion
    function formatBytes($size, $precision = 2)
    {
        $base = log($size, 1024);
        $suffixes = ['', 'kB', 'MB', 'GB', 'TB'];

        return round(pow(1024, $base - floor($base)), $precision) . ' ' . $suffixes[floor($base)];
    }
@endphp

{{-- Custom CSS & JS --}}
@section('custom-css')
    <link rel="stylesheet" href="{{ asset('css/lightgallery.min.css') }}" />
    <script src="{{ asset('js/lightgallery.min.js') }}"></script>
    <script src="{{ asset('js/clipboard.min.js') }}"></script>

    <style>
        .page-wrapper {
            flex: none !important;
            display: flex;
            flex-direction: column;
        }

        .word-break {
            display: block;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
    </style>
@endsection

@section('content')
    <div class="page-wrapper">
        <div class="container-fluid">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <div class="page-pretitle">
                            {{ __('Overview') }}
                        </div>
                        <h2 class="page-title">
                            {{ __('Trash') }}
                        </h2>
                    </div>

                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">
                        <div class="d-flex">
                            <a onclick="emptyTrash('{{ Auth::user()->id }}', 'permanent delete'); return false;"
                                class="btn btn-primary">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-trash"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                    fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M4 7l16 0"></path>
                                    <path d="M10 11l0 6"></path>
                                    <path d="M14 11l0 6"></path>
                                    <path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12"></path>
                                    <path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3"></path>
                                </svg>
                                {{ __('Empty Trash') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="page-body">
            <div class="container-fluid">

                {{-- Failed --}}
                @if (Session::has('failed'))
                    <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('failed') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                {{-- Success --}}
                @if (Session::has('success'))
                    <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('success') }}
                            </div>

                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                <div class="row row-cards" id="captions">
                    @if (!empty($trashes) && $trashes->count())
                        @foreach ($trashes as $trash)
                            <div class="col-6 col-lg-3">
                                <div class="card card-sm">
                                    <div class="d-block">
                                        <div class="item card-img-top img-responsive img-responsive-16by9"
                                            data-src="{{ $trash->actual_image }}"
                                            data-sub-html="<h4>{{ __('Name') }} : {{ $trash->actual_image }}</h4>"
                                            style="background-image: url({{ asset($trash->actual_image) }})">
                                        </div>
                                    </div>

                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-lg-10 col-10">
                                                <div class="font-weight-bold mb-2 word-break">
                                                    {{ $trash->name }}
                                                </div>
                                                <div class="small">
                                                    <small>{{ __('Uploaded on:') }}{{ formatDateForUser($trash->created_at) }}</small>
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-2">
                                                <div class="card-actions">
                                                    <div class="dropdown">
                                                        <a href="#" class="btn-action dropdown-toggle"
                                                            data-bs-toggle="dropdown" aria-haspopup="true"
                                                            aria-expanded="false"><!-- Download SVG icon from http://tabler-icons.io/i/dots-vertical -->
                                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon"
                                                                width="24" height="24" viewBox="0 0 24 24"
                                                                stroke-width="2" stroke="currentColor" fill="none"
                                                                stroke-linecap="round" stroke-linejoin="round">
                                                                <path stroke="none" d="M0 0h24v24H0z" fill="none">
                                                                </path>
                                                                <path d="M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                                <path d="M12 19m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                                <path d="M12 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                            </svg>
                                                        </a>
                                                        <div class="dropdown-menu dropdown-menu-end" style="">
                                                            <a class="dropdown-item" data-bs-toggle="tooltip"
                                                                data-bs-placement="top" title="{{ __('Restore') }}"
                                                                onclick="restoreOptimer('{{ $trash->id }}', 'restore'); return false;"
                                                                title="{{ __('Restore') }}">
                                                                {{ __('Restore') }}
                                                            </a>
                                                            <a class="dropdown-item" data-bs-toggle="tooltip"
                                                                data-bs-placement="top"
                                                                title="{{ __('Permanent Delete') }}"
                                                                onclick="deleteOptimer('{{ $trash->id }}', 'permanent delete'); return false;"
                                                                title="{{ __('Permanent Delete') }}">
                                                                {{ __('Permanent Delete') }}
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div class="empty">
                            <div class="empty-img"><img src="{{ asset('images/empty.svg') }}"  width="300" height="128"
                                    alt="">
                            </div>
                            <h2 class="empty-title">{{ __('No files found in Trash') }}</h2>
                            <p class="empty-subtitle">
                                {{ __("Only item(s) deleted are shown here. Click 'empty trash' to delete item(s) permanently.") }}
                            </p>
                        </div>
                    @endif

                    <div class="col-lg-12">
                        {{-- Paginate --}}
                        {{ $trashes->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Footer --}}
    @include('admin.includes.footer')
    </div>

    {{-- Restore Optimize Modal --}}
    <div class="modal modal-blur fade" id="restore-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title">{{ __('Are you sure?') }}</div>
                    <div id="restore_status"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary me-auto"
                        data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <a class="btn btn-danger" id="restore_optimer_id">{{ __('Yes, proceed') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- Permanent Delete Optimize Modal --}}
    <div class="modal modal-blur fade" id="delete-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title">{{ __('Are you sure?') }}</div>
                    <div id="delete_status"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary me-auto"
                        data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <a class="btn btn-danger" id="delete_optimer_id">{{ __('Yes, proceed') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- Empty Trash Modal --}}
    <div class="modal modal-blur fade" id="empty-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title">{{ __('Are you sure?') }}</div>
                    <div id="empty_status"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary me-auto"
                        data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <a class="btn btn-danger" id="empty_trash">{{ __('Yes, proceed') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- Custom JS --}}
@section('custom-js')
    <script>
        "use strict";
        $('#captions').lightGallery({
            thumbnail: true,
            download: false,
            selector: '.item'
        });

        // Restore Optimer
        function restoreOptimer(restoreOptimerId, restoreOptimerStatus) {
            "use strict";
            $("#restore-modal").modal("show");
            var restorestatus = document.getElementById("restore_status");
            restore_status.innerHTML = "<?php echo __('If you proceed, you will'); ?> " + restoreOptimerStatus + " <?php echo __('this optimize image.'); ?>"
            var restore_link = document.getElementById("restore_optimer_id");
            restore_link.getAttribute("href");
            restore_link.setAttribute("href", "{{ route('admin.restore') }}?id=" + restoreOptimerId);
        }
        // Permanent Delete Optimer
        function deleteOptimer(deleteOptimerId, deleteOptimerStatus) {
            "use strict";
            $("#delete-modal").modal("show");
            var delete_status = document.getElementById("delete_status");
            delete_status.innerHTML = "<?php echo __('If you proceed, you will'); ?> " + deleteOptimerStatus + " <?php echo __('this optimize image.'); ?>"
            var delete_link = document.getElementById("delete_optimer_id");
            delete_link.getAttribute("href");
            delete_link.setAttribute("href", "{{ route('admin.permanent.delete.optimer') }}?id=" + deleteOptimerId);
        }

        // Empty Trash
        function emptyTrash(authId, status) {
            "use strict";
            $("#empty-modal").modal("show");
            var emptyStatus = document.getElementById("empty_status");
            emptyStatus.innerHTML = "<?php echo __('If you proceed, you will'); ?> " + status + " <?php echo __('this all trash images.'); ?>"
            var empty_trash = document.getElementById("empty_trash");
            empty_trash.getAttribute("href");
            empty_trash.setAttribute("href", "{{ route('admin.empty.trash') }}?id=" + authId);
        }
    </script>
@endsection
@endsection
