@extends('admin.layouts.app')

@php
    // Byte conversion
    function formatBytes($size, $precision = 2)
    {
        $base = log($size, 1024);
        $suffixes = ['', 'kB', 'MB', 'GB', 'TB'];

        return round(pow(1024, $base - floor($base)), $precision) . '' . $suffixes[floor($base)];
    }
@endphp

{{-- Custom CSS & JS --}}
@section('custom-css')
    <link rel="stylesheet" href="{{ asset('css/lightgallery.min.css') }}" />
    <script src="{{ asset('js/lightgallery.min.js') }}"></script>
    <script src="{{ asset('js/clipboard.min.js') }}"></script>
    <style>
        .form-imagecheck {
            width: 100%;
        }

        .form-imagecheck-figure {
            box-shadow: none !important;
        }

        .form-imagecheck-input:checked~.form-imagecheck-figure {
            border-color: #ffffff00 !important;
        }

        .word-break {
            display: block;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
    </style>
@endsection

@section('content')
    <div class="page-wrapper">
        <div class="container-fluid">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <div class="page-pretitle">
                            {{ __('Overview') }}
                        </div>
                        <h2 class="page-title">
                            {{ __('Optimizer') }}
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">
                        <div class="d-flex">
                            <a class="btn btn-primary mx-1 d-none" id="bulk_download_optimer_id"
                                data-route="{{ route('admin.bulk.download') }}" data-bs-toggle="tooltip"
                                data-bs-placement="top" title="{{ __('Bulk Download') }}">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-file-zip"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                    fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M6 20.735a2 2 0 0 1 -1 -1.735v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2h-1" />
                                    <path d="M11 17a2 2 0 0 1 2 2v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a2 2 0 0 1 2 -2z" />
                                    <path d="M11 5l-1 0" />
                                    <path d="M13 7l-1 0" />
                                    <path d="M11 9l-1 0" />
                                    <path d="M13 11l-1 0" />
                                    <path d="M11 13l-1 0" />
                                    <path d="M13 15l-1 0" />
                                </svg>
                                <span class="d-none d-sm-inline-block">{{ __('Download') }}</span>
                            </a>
                            <a class="btn btn-primary mx-1 d-none" id="bulk_delete_optimer_id"
                                data-route="{{ route('admin.bulk.delete') }}" data-bs-toggle="tooltip"
                                data-bs-placement="top" title="{{ __('Bulk Delete') }}">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-trash"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                    fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M4 7l16 0" />
                                    <path d="M10 11l0 6" />
                                    <path d="M14 11l0 6" />
                                    <path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12" />
                                    <path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3" />
                                </svg>
                                <span class="d-none d-sm-inline-block">{{ __('Delete') }}</span>
                            </a>
                            <a href="{{ route('admin.create.optimer') }}" class="btn btn-primary mx-1">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-upload"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                    fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M4 17v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-2"></path>
                                    <polyline points="7 9 12 4 17 9"></polyline>
                                    <line x1="12" y1="4" x2="12" y2="16"></line>
                                </svg>
                                <span class="d-none d-sm-inline-block">{{ __('Upload') }}</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-body">
            <div class="container-fluid">

                {{-- Failed --}}
                @if (Session::has('failed'))
                    <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('failed') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                {{-- Success --}}
                @if (Session::has('success'))
                    <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                        <div class="d-flex">
                            <div>
                                {{ Session::get('success') }}
                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                <div class="row mb-4">
                    {{-- Today Optimizer Images --}}
                    <div class="col-6 col-lg-4 mb-2">
                        <div class="card bg-custom4">
                            <div class="card-body text-custom">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="subheader">{{ __('Today Optimizes') }}</div>
                                </div>
                                <div class="h1">{{ $today_optimized_images }}</div>
                            </div>
                        </div>
                    </div>

                    {{-- Today Optimizer Size --}}
                    <div class="col-6 col-lg-4 mb-2">
                        <div class="card bg-custom5">
                            <div class="card-body text-custom">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="subheader">{{ __('Today Optimize') }}</div>
                                </div>
                                <div class="h1">
                                    {{ $today_optimized_image_size != 0 ? formatBytes($today_optimized_image_size) : 0 }}
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Overall Optimize Size --}}
                    <div class="col-12 col-lg-4 mb-2">
                        <div class="card bg-custom6">
                            <div class="card-body text-custom">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="subheader">{{ __('Overall Optimize') }}</div>
                                </div>
                                <div class="h1">
                                    {{ $overall_optimized_image_size != 0 ? formatBytes($overall_optimized_image_size) : 0 }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row row-cards" id="captions">
                    @if (!empty($optimers) && $optimers->count())
                        {{-- Optimize Images --}}
                        @foreach ($optimers as $optimer)
                            <div class="col-6 col-lg-3">
                                <div class="card card-sm">
                                    <div class="d-block">
                                        <div class="item card-img-top img-responsive img-responsive-16by9"
                                            data-src="{{ $optimer->optimized_image }}"
                                            data-sub-html="<h4>{{ __('Name') }} : {{ $optimer->name }}</h4>"
                                            style="background-image: url({{ asset($optimer->optimized_image) }})">
                                        </div>
                                    </div>

                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-lg-2 col-2">
                                                <input class="form-check-input" type="checkbox"
                                                    value="{{ $optimer->id }}" class="form-imagecheck-input"
                                                    onclick="bulkDelete(this), bulkDownload(this)">
                                            </div>
                                            <div class="col-lg-8 col-8">
                                                <div class="font-weight-bold mb-2 word-break">
                                                    {{ $optimer->name }}
                                                </div>
                                                <div class="small">
                                                    <small>{{ __('Uploaded on:') }}{{ formatDateForUser($optimer->created_at) }}</small>
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-2">
                                                <div class="card-actions">
                                                    <div class="dropdown">
                                                        <a href="#" class="btn-action dropdown-toggle"
                                                            data-bs-toggle="dropdown" aria-haspopup="true"
                                                            aria-expanded="false"><!-- Download SVG icon from http://tabler-icons.io/i/dots-vertical -->
                                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon"
                                                                width="24" height="24" viewBox="0 0 24 24"
                                                                stroke-width="2" stroke="currentColor" fill="none"
                                                                stroke-linecap="round" stroke-linejoin="round">
                                                                <path stroke="none" d="M0 0h24v24H0z" fill="none">
                                                                </path>
                                                                <path d="M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                                <path d="M12 19m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                                <path d="M12 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                            </svg>
                                                        </a>
                                                        <div class="dropdown-menu dropdown-menu-end" style="">
                                                            <a class="dropdown-item copyBoard" data-bs-toggle="tooltip"
                                                                data-bs-placement="top" title="{{ __('Copy') }}"
                                                                data-clipboard-text="{{ url($optimer->optimized_image) }}">
                                                                {{ __('Copy') }}
                                                            </a>
                                                            <a class="dropdown-item" href="#"
                                                                data-bs-toggle="tooltip"
                                                                onclick="downloadImage('{{ $optimer->optimized_image }}', '{{ $optimer->name }}'); return false;"
                                                                data-bs-placement="top" title="{{ __('Download') }}">
                                                                {{ __('Download') }}
                                                            </a>
                                                            <a class="dropdown-item" href="#"
                                                                data-bs-toggle="tooltip" data-bs-placement="top"
                                                                title="{{ __('Delete') }}"
                                                                onclick="deleteOptimer('{{ $optimer->id }}', '{{ __('delete') }}'); return false;">
                                                                {{ __('Delete') }}
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div class="empty">
                            <div class="empty-img"><img src="{{ asset('images/undraw_printing_invoices_5r4r.svg') }}"
                                    width="300" height="128" alt="">
                            </div>
                            <p class="empty-title">{{ __('No optimize images found') }}</p>
                            <p class="empty-subtitle">
                                {{ __('Try adjusting your add to find what you are looking for.') }}
                            </p>
                        </div>
                    @endif

                    {{-- Pagination --}}
                    <div class="col-lg-12">
                        {{ $optimers->links() }}
                    </div>
                </div>
            </div>
        </div>

        {{-- Footer --}}
        @include('admin.includes.footer')
    </div>

    {{-- Delete Optimize Modal --}}
    <div class="modal modal-blur fade" id="delete-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title">{{ __('Are you sure?') }}</div>
                    <div id="delete_status"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary me-auto"
                        data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <a class="btn btn-danger" id="delete_optimer_id">{{ __('Yes, proceed') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- Bulk Delete Optimize Modal --}}
    <div class="modal modal-blur fade" id="bulk-delete-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title">{{ __('Are you sure?') }}</div>
                    <div id="bulk_delete_status"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary me-auto"
                        data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <a class="btn btn-danger" id="route_bulk_delete_optimer_id">{{ __('Yes, proceed') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- Bulk Download Optimize Modal --}}
    <div class="modal modal-blur fade" id="bulk-download-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title">{{ __('Are you sure?') }}</div>
                    <div id="bulk_download_status"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary me-auto"
                        data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <a class="btn btn-danger" id="route_bulk_download_optimer_ids">{{ __('Yes, proceed') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- Download Optimize --}}
    <div class="modal modal-blur fade" id="download-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title">{{ __('Download Formats') }}</div>
                    <div class="row">
                        <div class="col-6 col-sm-4 col-md-2 col-xl-3 py-3">
                            <a class="btn btn-blue w-100" id="jpgImage">
                                {{ __('JPG') }}
                            </a>
                        </div>
                        <div class="col-6 col-sm-4 col-md-2 col-xl-3 py-3">
                            <a class="btn btn-blue w-100" id="pngImage">
                                {{ __('PNG') }}
                            </a>
                        </div>
                        <div class="col-6 col-sm-4 col-md-2 col-xl-3 py-3">
                            <a class="btn btn-blue w-100" id="gifImage">
                                {{ __('GIF') }}
                            </a>
                        </div>
                        <div class="col-6 col-sm-4 col-md-2 col-xl-3 py-3">
                            <a class="btn btn-blue w-100" id="webpImage">
                                {{ __('WEBP') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Custom JS --}}
@section('custom-js')
    <script>
        // Delete Optimer
        function deleteOptimer(deleteOptimerId, deleteOptimerStatus) {
            "use strict";
            $("#delete-modal").modal("show");
            var delete_status = document.getElementById("delete_status");
            delete_status.innerHTML = "<?php echo __('If you proceed, you will'); ?> " + deleteOptimerStatus + " <?php echo __('this optimize data.'); ?>"
            var delete_link = document.getElementById("delete_optimer_id");
            delete_link.getAttribute("href");
            delete_link.setAttribute("href", "{{ route('admin.delete.optimer') }}?id=" + deleteOptimerId);
        }

        "use strict";
        $('#captions').lightGallery({
            thumbnail: true,
            download: false,
            selector: '.item'
        });

        // Copyboard
        var clipboard = new ClipboardJS('.copyBoard');

        clipboard.on('success', function(e) {
            swal({
                title: `{{ __('Copied!') }}`,
                text: `{{ __('Image URL was copied.') }}`,
                icon: "success",
                buttons: false,
                timer: 2000
            });
        });

        clipboard.on('error', function(e) {
            swal({
                title: `{{ __('Oops!') }}`,
                text: `{{ __('Something wrong.') }}`,
                icon: "error",
                buttons: false,
                timer: 2000
            });
        });

        // Download Image
        function downloadImage(imageUrl, imageName) {
            "use strict";

            $("#download-modal").modal("show");
            var JpgImage = document.getElementById("jpgImage");
            JpgImage.getAttribute("href");
            JpgImage.setAttribute("href", "{{ route('admin.download.image') }}?image=" + imageUrl + "&name=" + imageName +
                "&format=jpg");

            var PngImage = document.getElementById("pngImage");
            PngImage.getAttribute("href");
            PngImage.setAttribute("href", "{{ route('admin.download.image') }}?image=" + imageUrl + "&name=" + imageName +
                "&format=png");

            var gifImage = document.getElementById("gifImage");
            gifImage.getAttribute("href");
            gifImage.setAttribute("href", "{{ route('admin.download.image') }}?image=" + imageUrl + "&name=" + imageName +
                "&format=gif");

            var webpImage = document.getElementById("webpImage");
            webpImage.getAttribute("href");
            webpImage.setAttribute("href", "{{ route('admin.download.image') }}?image=" + imageUrl + "&name=" + imageName +
                "&format=webp");
        }

        // Bulk delete
        var deleteIds = [];

        function bulkDelete(id) {
            if ($(id).is(':checked')) {
                // Add the id to the deleteIds array if not already present
                if ($.inArray(id.value, deleteIds) === -1) {
                    deleteIds.push(id.value);
                }
            } else {
                // Remove the id from the deleteIds array
                deleteIds = $.grep(deleteIds, function(value) {
                    return value !== id.value;
                });
            }

            // Update the bulkDelete button and its behavior
            updateBulkDeleteButton();
        }

        function updateBulkDeleteButton() {
            var bulkDeleteButton = $("#bulk_delete_optimer_id");

            if (deleteIds.length > 0) {
                bulkDeleteButton.removeClass('d-none').fadeIn("slow");
                bulkDeleteButton.attr("onclick", "bulkDeleteOptimer('" + deleteIds.join(',') +
                    "', '{{ __('delete') }}'); return false;");
            } else {
                bulkDeleteButton.addClass('d-none').fadeOut("slow");
            }
        }

        // Bulk Delete
        function bulkDeleteOptimer(deleteOptimerId) {
            // Show the bulk delete modal
            $("#bulk-delete-modal").modal("show");

            // Set the content for bulk delete status
            $("#bulk_delete_status").html(`{{ __('If you proceed, you will delete all selected optimized images.') }}`);

            // Retrieve the route URL from the data attribute
            var route = $("#bulk_delete_optimer_id").data('route');

            // Update the href attribute for bulk delete link
            var deleteLink = $("#route_bulk_delete_optimer_id");
            deleteLink.attr("href", route + "?id=" + deleteOptimerId);
        }

        // Bulk download
        var downloadIds = [];

        function bulkDownload(id) {
            if ($(id).is(':checked')) {
                // Add the id to the downloadIds array if not already present
                if ($.inArray(id.value, downloadIds) === -1) {
                    downloadIds.push(id.value);
                }
            } else {
                // Remove the id from the downloadIds array
                downloadIds = $.grep(downloadIds, function(value) {
                    return value !== id.value;
                });
            }

            // Update the bulkDownload button and its behavior
            updateBulkDownloadButton();
        }

        function updateBulkDownloadButton() {
            var bulkDownloadButton = $("#bulk_download_optimer_id");

            if (downloadIds.length > 0) {
                bulkDownloadButton.removeClass('d-none').fadeIn("slow");
                bulkDownloadButton.attr("onclick", "bulkDownloadOptimer('" + downloadIds.join(',') +
                    "', '{{ __('download') }}'); return false;");
            } else {
                bulkDownloadButton.addClass('d-none').fadeOut("slow");
            }
        }

        // Bulk Download
        function bulkDownloadOptimer(downloadOptimerId) {
            // Show the bulk download modal
            $("#bulk-download-modal").modal("show");

            // Set the content for bulk download status
            $("#bulk_download_status").html(
                `{{ __('If you proceed, you will download all selected optimized images.') }}`);

            // Retrieve the route URL from the data attribute
            var route = $("#bulk_download_optimer_id").data('route');

            // Update the href attribute for bulk download link
            var downloadLink = $("#route_bulk_download_optimer_ids");
            downloadLink.attr("href", route + "?id=" + downloadOptimerId);
        }
    </script>
@endsection
@endsection
