@extends('admin.layouts.app')

@section('content')
{{-- Page Content --}}
<div class="page-wrapper">
    <div class="container-fluid">

        {{-- Failed --}}
        @if (Session::has("failed"))
        <div class="alert alert-important alert-danger alert-dismissible mt-3" role="alert">
            <div class="d-flex">
                <div>
                    {{Session::get('failed')}}
                </div>
            </div>
            <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
        </div>
        @endif

        {{-- Success --}}
        @if(Session::has("success"))
        <div class="alert alert-important alert-success alert-dismissible mt-3" role="alert">
            <div class="d-flex">
                <div>
                    {{Session::get('success')}}
                </div>
            </div>
            <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
        </div>
        @endif

        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        {{ __('Overview') }}
                    </div>
                    <h2 class="page-title">
                        {{ __('Dashboard') }}
                    </h2>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-fluid">
            <div class="row row-deck row-cards mb-5">
                {{-- This Month Income --}}
                <div class="col-6 col-lg-3">
                    <div class="card bg-custom1">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="subheader text-custom">{{ __('This Month Income') }}</div>
                            </div>
                            <div class="h1 text-custom">{{ currency($this_month_income) }}</div>
                        </div>
                    </div>
                </div>

                {{-- Today Income --}}
                <div class="col-6 col-lg-3">
                    <div class="card bg-custom2">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="subheader text-custom">{{ __('Today Income') }}</div>
                            </div>
                            <div class="h1 text-custom">{{ currency($today_income) }}</div>
                        </div>
                    </div>
                </div>

                {{-- Overall Users --}}
                <div class="col-6 col-lg-3">
                    <div class="card bg-custom3">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="subheader text-custom">{{ __('Overall Users') }}</div>
                            </div>
                            <div class="h1 text-custom">{{ $overall_users }}</div>
                        </div>
                    </div>
                </div>

                {{-- Today Users --}}
                <div class="col-6 col-lg-3">
                    <div class="card bg-custom4">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="subheader text-custom">{{ __('Today Users') }}</div>
                            </div>
                            <div class="h1 text-custom">{{ $today_users }}</div>
                        </div>
                    </div>
                </div>

                {{--  Sales Chart --}}
                <div class="col-12 col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <div>
                                <div class="row">
                                    <div class="col-9">
                                        <h3>{{ __('Total Sales Overview') }}</h3>
                                    </div>
                                </div>
                                
                                <div id="sales"></div>
                              </div>
                        </div>
                    </div>
                </div>

                {{-- Users Chart --}}
                <div class="col-12 col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <div>
                                <div class="row">
                                    <div class="col-9">
                                        <h3>{{ __('New Users Overview') }}</h3>
                                    </div>
                                </div>

                                <div id="users"></div>
                              </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Footer --}}
    @include('admin.includes.footer')
</div>


{{-- Custom JS --}}
@section('custom-js')
<script type="text/javascript" src="{{ asset('js/apexcharts.min.js') }}"></script>
<script>
// @formatter:off
document.addEventListener("DOMContentLoaded", function () {
    window.ApexCharts && (new ApexCharts(document.getElementById('sales'), {
        chart: {
            type: "line",
            fontFamily: 'inherit',
            height: 212,
            parentHeightOffset: 0,
            toolbar: {
                show: false,
            },
            animations: {
                enabled: true
            },
        },
        fill: {
            opacity: 1,
        },
        stroke: {
            width: 2,
            lineCap: "round",
            curve: "smooth",
        },
        series: [{
            name: `{{ __('Total Sales') }}`,
            data: [{{ $monthIncome }}]
        }],
        tooltip: {
            theme: 'dark'
        },
        grid: {
            padding: {
                top: -20,
                right: 0,
                left: -4,
                bottom: -4
            },
            strokeDashArray: 4,
        },
        xaxis: {
            labels: {
                padding: 0,
            },
            tooltip: {
                enabled: false
            },
            type: 'year',
        },
        yaxis: {
            labels: {
                padding: 4,
            },
        },
        labels: [`{{ __('Jan') }}`, `{{ __('Feb') }}`, `{{ __('Mar') }}`, `{{ __('Apr') }}`, `{{ __('May') }}`, `{{ __('Jun') }}`, `{{ __('Jul') }}`, `{{ __('Aug') }}`, `{{ __('Sep') }}`, `{{ __('Oct') }}`, `{{ __('Nov') }}`, `{{ __('Dec') }}`],
        colors: ["#22C55E"],
        legend: {
            show: false,
        },
    })).render();
});
// @formatter:on

// @formatter:off
document.addEventListener("DOMContentLoaded", function () {
    window.ApexCharts && (new ApexCharts(document.getElementById('users'), {
        chart: {
            type: "line",
            fontFamily: 'inherit',
            height: 212,
            parentHeightOffset: 0,
            toolbar: {
                show: false,
            },
            animations: {
                enabled: true
            },
        },
        fill: {
            opacity: 1,
        },
        stroke: {
            width: 2,
            lineCap: "round",
            curve: "smooth",
        },
        series: [{
            name: `{{ __('New Users') }}`,
            data: [{{ $monthUsers }}]
        }],
        tooltip: {
            theme: 'dark'
        },
        grid: {
            padding: {
                top: -20,
                right: 0,
                left: -4,
                bottom: -4
            },
            strokeDashArray: 4,
        },
        xaxis: {
            labels: {
                padding: 0,
            },
            tooltip: {
                enabled: false
            },
            type: 'year',
        },
        yaxis: {
            labels: {
                padding: 4,
            },
        },
        labels: [`{{ __('Jan') }}`, `{{ __('Feb') }}`, `{{ __('Mar') }}`, `{{ __('Apr') }}`, `{{ __('May') }}`, `{{ __('Jun') }}`, `{{ __('Jul') }}`, `{{ __('Aug') }}`, `{{ __('Sep') }}`, `{{ __('Oct') }}`, `{{ __('Nov') }}`, `{{ __('Dec') }}`],
        colors: ["#22C55E"],
        legend: {
            show: false,
        },
    })).render();
});
// @formatter:on
</script>
@endsection

@endsection