<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PlansTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('plans')->insert([
            "name" => "Beginner",
            "description" => "Nullam diam arcu, sodales quis convallis sit amet, sagittis varius ligula.",
            "price" => 0,
            "validity" => 31,
            "formats" => 2,
            "maximum" => 20,
            "size" => 5242880,
            "storage" => 1073741824,
            "s3" => 0,
            "png" => 1,
            "jpg" => 1,
            "svg" => 0,
            "webp" => 0,
            "gif" => 0,
            "statistics" => 1,
            "media_library" => 1,
            "api" => 0,
            "limit" => 0,
            "additional_tools" => 1,
            "recommended"  => 0,
            "support" => 0
        ]);

        DB::table('plans')->insert([
            "name"  => "Intermediate",
            "description"  => "Nullam diam arcu, sodales quis convallis sit amet, sagittis varius ligula.",
            "price"  => 24,
            "validity"  => 31,
            "formats" => 4,
            "maximum" => 1000,
            "size" => 10485760,
            "storage" => 5368709120,
            "s3" => 1,
            "png" => 1,
            "jpg" => 1,
            "svg" => 1,
            "webp" => 0,
            "gif" => 1,
            "statistics" => 1,
            "media_library" => 1,
            "api" => 1,
            "limit" => 100,
            "additional_tools" => 1,
            "recommended"  => 1,
            "support" => 1
        ]);

        DB::table('plans')->insert([
            "name"  => "Professional",
            "description"  => "Nullam diam arcu, sodales quis convallis sit amet, sagittis varius ligula.",
            "price"  => 48,
            "validity"  => 31,
            "formats" => 5,
            "maximum" => 9999,
            "size" => 20971520,
            "storage" => 21474836480,
            "s3" => 1,
            "png" => 1,
            "jpg" => 1,
            "svg" => 1,
            "webp" => 1,
            "gif" => 1,
            "statistics" => 1,
            "media_library" => 1,
            "api" => 1,
            "limit" => 1000,
            "additional_tools" => 1,
            "recommended"  => 0,
            "support" => 1
        ]);
    }
}
