<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOptimersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('optimers', function (Blueprint $table) {
            $table->increments('id');
            $table->longText('optimer_id')->nullable();
            $table->string('uploaded_by');
            $table->string('disk');
            $table->longText('name');
            $table->string('mime');
            $table->string('extension');
            $table->bigInteger('width');
            $table->bigInteger('height');
            $table->longText('actual_image');
            $table->longText('optimized_image');
            $table->longText('cdn_url');
            $table->bigInteger('actual_image_size');
            $table->bigInteger('optimized_image_size');
            $table->integer('status')->default(1);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent(); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('optimers');
    }
}
