<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePlansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('plans', function (Blueprint $table) {
            $table->increments('id')->uniqid();
            $table->boolean('is_private')->default(false);
            $table->string('name');
            $table->longText('description'); 
            $table->double('price', 15, 2);
            $table->integer('validity');
            $table->bigInteger('formats');
            $table->bigInteger('maximum');
            $table->bigInteger('size');
            $table->bigInteger('storage');
            $table->boolean('s3');
            $table->boolean('png');
            $table->boolean('jpg');
            $table->boolean('svg');
            $table->boolean('webp');
            $table->boolean('gif');
            $table->boolean('statistics');
            $table->boolean('media_library');
            $table->boolean('api')->default(0);
            $table->bigInteger('limit')->default(0);
            $table->boolean('additional_tools');
            $table->boolean('recommended')->default(false);
            $table->boolean('support');
            $table->boolean('status')->default(true);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('plans');
    }
}
