<?php

namespace App\Http\Middleware;

use Closure;
use Carbon\Carbon;
use App\Models\Plan;
use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Request as ModelsRequest;

class ApiCalls
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // Authorization
        $header = $request->header('Authorization');

        if (!isset($header)) {
            return response()->json('Invalid Request');
        }

        // Check user count
        $count = User::where('api_key', $header)->where('status', 1)->count();

        // User details
        $userDetails = User::where('api_key', $header)->where('status', 1)->first();

        // Check urser id
        if ($userDetails != null) {
            // APIs count
            $apiRequest = ModelsRequest::where('user_id', $userDetails->id)->whereDate('created_at', Carbon::today())->count();

            if (isset($header)) {
                if ($userDetails->role_id == 1 || json_decode($userDetails->plan_details)->api == "1" && $apiRequest < json_decode($userDetails->plan_details)->limit) {
                    if ($count > 0) {
                        // Delete yesterday APIs count
                        $previousApiRequest = ModelsRequest::where('user_id', $userDetails->id)->whereBetween('created_at', [Carbon::today()->subDay(30), Carbon::today()])->count();

                        if ($previousApiRequest > 1) {
                            ModelsRequest::where('user_id', $userDetails->id)->whereBetween('created_at', [Carbon::today()->subDay(30), Carbon::today()])->delete();
                        }

                        return $next($request);
                    } else {
                        return response(['status' => false, 'message' => 'Invalid Request'], 400);
                        return response()->json('Invalid Request');
                    }
                } else {
                    return response(['status' => false, 'message' => 'Daily API request limit has been reached.'], 400);
                }
            }
        } else {
            return response(['status' => false, 'message' => 'Invalid Request'], 400);
        }
    }
}
